/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.argument;

import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.argument.BooleanCliArgument;
import com.intellij.database.cli.argument.BooleanCliArgumentImpl;
import com.intellij.database.cli.argument.CommonPgArguments;
import com.intellij.database.cli.argument.DefaultValueCliArgument;
import com.intellij.database.cli.argument.DefaultValueCliArgumentImpl;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.database.cli.argument.StringCliArgumentImpl;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class CommonPgCliArguments {
    public static final DefaultValueCliArgument F_DIRECTORY = new DefaultValueCliArgumentImpl.Parameterized("Directory", CommonPgArguments.FORMAT, CommonPgArguments.DIR_FORMAT);
    public static final DefaultValueCliArgument F_TAR = new DefaultValueCliArgumentImpl.Parameterized("Tar archive", CommonPgArguments.FORMAT, CommonPgArguments.TAR_FORMAT);
    public static final DefaultValueCliArgument F_CUSTOM = new DefaultValueCliArgumentImpl.Parameterized("Custom-format archive", CommonPgArguments.FORMAT, CommonPgArguments.CUSTOM_FORMAT);
    public static final BooleanCliArgument CLEAN = new BooleanCliArgumentImpl("Clean database", CommonPgArguments.CLEAN_DATABASE);
    public static final BooleanCliArgument CREATE = new BooleanCliArgumentImpl("Create database", CommonPgArguments.CREATE_DATABASE);
    public static final BooleanCliArgument IF_EXISTS = new BooleanCliArgumentImpl("Add \"IF EXISTS\"", "--if-exists");
    public static final BooleanCliArgument DATA_ONLY = new BooleanCliArgumentImpl("Data only", CommonPgArguments.DATA_ONLY);
    public static final StringCliArgument DATABASE = new StringCliArgumentImpl.MaybeUnnamedArgument("Database", (Condition<DbElement>)DasUtil.byKind((ObjectKind)ObjectKind.DATABASE), CommonPgArguments.DB_NAME);
    public static final StringCliArgument TABLES = new StringCliArgumentImpl("Tables", CommonPgArguments.TABLE){

        @Override
        @NotNull
        public List<String> getStringsFromElements(@NotNull Collection<DbElement> elements, @NotNull CliContextDescriptor cd) {
            if (elements == null) {
                1.$$$reportNull$$$0(0);
            }
            if (cd == null) {
                1.$$$reportNull$$$0(1);
            }
            List<String> list = DbCliUtil.getTablesNames(elements);
            if (list == null) {
                1.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cd";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/argument/CommonPgCliArguments$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/argument/CommonPgCliArguments$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStringsFromElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getStringsFromElements";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final StringCliArgument SCHEMAS = new StringCliArgumentImpl.ElementsStringArgument("Schemas", DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA), CommonPgArguments.SCHEMA){

        @Override
        @NotNull
        public Function<String, String> getQuoter() {
            Function<String, String> function2 = DbCliUtil::pgQuote;
            if (function2 == null) {
                2.$$$reportNull$$$0(0);
            }
            return function2;
        }

        @Override
        @NotNull
        public Function<String, String> getUnquoter() {
            Function<String, String> unquoter = super.getUnquoter();
            Function<String, String> function2 = s -> StringUtil.unquoteString((String)((String)unquoter.apply((String)s)));
            if (function2 == null) {
                2.$$$reportNull$$$0(1);
            }
            return function2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/cli/argument/CommonPgCliArguments$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuoter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnquoter";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };

    private CommonPgCliArguments() {
    }
}

