/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

final class Stripe
extends JPanel
implements UISettingsListener {
    private final int myAnchor;
    private final ArrayList<StripeButton> myButtons = new ArrayList();
    private final MyKeymapManagerListener myWeakKeymapManagerListener;
    private Dimension myPrefSize;
    private StripeButton myDragButton;
    private Rectangle myDropRectangle;
    private final ToolWindowManagerImpl myManager;
    private JComponent myDragButtonImage;
    private LayoutData myLastLayoutData;
    private boolean myFinishingDrop;
    static final int DROP_DISTANCE_SENSIVITY = 20;
    private final Disposable myDisposable = Disposer.newDisposable();
    private BufferedImage myCachedBg;

    Stripe(int anchor2, ToolWindowManagerImpl manager) {
        super(new GridBagLayout());
        this.setOpaque(true);
        this.myManager = manager;
        this.myAnchor = anchor2;
        this.myWeakKeymapManagerListener = new MyKeymapManagerListener();
        this.setBorder(new AdaptiveBorder());
    }

    public void uiSettingsChanged(UISettings uiSettings) {
        this.updatePresentation();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updatePresentation();
        KeymapManagerEx.getInstanceEx().addWeakListener(this.myWeakKeymapManagerListener);
    }

    @Override
    public void removeNotify() {
        KeymapManagerEx.getInstanceEx().removeWeakListener(this.myWeakKeymapManagerListener);
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this)) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
        super.removeNotify();
    }

    void addButton(@NotNull StripeButton button, Comparator<StripeButton> comparator2) {
        if (button == null) {
            Stripe.$$$reportNull$$$0(0);
        }
        this.myPrefSize = null;
        this.myButtons.add(button);
        Collections.sort(this.myButtons, comparator2);
        this.add(button);
        this.revalidate();
    }

    void removeButton(@NotNull StripeButton button) {
        if (button == null) {
            Stripe.$$$reportNull$$$0(1);
        }
        this.myPrefSize = null;
        this.myButtons.remove(button);
        this.remove(button);
        this.revalidate();
    }

    public List<StripeButton> getButtons() {
        return Collections.unmodifiableList(this.myButtons);
    }

    @Override
    public void invalidate() {
        this.myPrefSize = null;
        super.invalidate();
    }

    @Override
    public void doLayout() {
        if (!this.myFinishingDrop) {
            this.myLastLayoutData = this.recomputeBounds(true, this.getSize());
        }
    }

    private LayoutData recomputeBounds(boolean setBounds, Dimension toFitWith) {
        return this.recomputeBounds(setBounds, toFitWith, false);
    }

    private LayoutData recomputeBounds(boolean setBounds, Dimension toFitWith, boolean noDrop) {
        boolean processDrop;
        LayoutData data = new LayoutData();
        int horizontaloffset = this.getHeight();
        data.eachY = 0;
        data.size = new Dimension();
        data.gap = 0;
        data.horizontal = this.isHorizontal();
        data.dragInsertPosition = -1;
        if (data.horizontal) {
            data.eachX = horizontaloffset - 1;
            data.eachY = 1;
        } else {
            data.eachX = 0;
        }
        data.fitSize = toFitWith != null ? toFitWith : new Dimension();
        Rectangle stripeSensetiveRec = new Rectangle(-20, -20, this.getWidth() + 40, this.getHeight() + 40);
        boolean bl = processDrop = this.isDroppingButton() && stripeSensetiveRec.intersects(this.myDropRectangle) && !noDrop;
        if (toFitWith == null) {
            for (StripeButton eachButton : this.myButtons) {
                if (!this.isConsideredInLayout(eachButton)) continue;
                Dimension eachSize = eachButton.getPreferredSize();
                data.fitSize.width = Math.max(eachSize.width, data.fitSize.width);
                data.fitSize.height = Math.max(eachSize.height, data.fitSize.height);
            }
        }
        int gap = 0;
        if (toFitWith != null) {
            LayoutData layoutData = this.recomputeBounds(false, null, true);
            gap = data.horizontal ? toFitWith.width - horizontaloffset - layoutData.size.width - data.eachX : toFitWith.height - layoutData.size.height - data.eachY;
            if (processDrop) {
                gap = data.horizontal ? (gap -= this.myDropRectangle.width + data.gap) : (gap -= this.myDropRectangle.height + data.gap);
            }
            gap = Math.max(gap, 0);
        }
        int insertOrder = -1;
        boolean sidesStarted = false;
        for (StripeButton eachButton : this.getButtonsToLayOut()) {
            insertOrder = eachButton.getDecorator().getWindowInfo().getOrder();
            Dimension eachSize = eachButton.getPreferredSize();
            if (!sidesStarted && eachButton.getWindowInfo().isSplit()) {
                if (processDrop) {
                    this.tryDroppingOnGap(data, gap, eachButton.getWindowInfo().getOrder());
                }
                if (data.horizontal) {
                    data.eachX += gap;
                    data.size.width += gap;
                } else {
                    data.eachY += gap;
                    data.size.height += gap;
                }
                sidesStarted = true;
            }
            if (processDrop && !data.dragTargetChoosen) {
                int distance;
                if (data.horizontal) {
                    distance = this.myDropRectangle.x - data.eachX;
                    if (distance < eachSize.width / 2 || this.myDropRectangle.x + this.myDropRectangle.width < eachSize.width / 2) {
                        Stripe.layoutButton(data, this.myDragButtonImage, false);
                        data.dragInsertPosition = insertOrder;
                        data.dragToSide = sidesStarted;
                        data.dragTargetChoosen = true;
                    }
                } else {
                    distance = this.myDropRectangle.y - data.eachY;
                    if (distance < eachSize.height / 2 || this.myDropRectangle.y + this.myDropRectangle.height < eachSize.height / 2) {
                        Stripe.layoutButton(data, this.myDragButtonImage, false);
                        data.dragInsertPosition = insertOrder;
                        data.dragToSide = sidesStarted;
                        data.dragTargetChoosen = true;
                    }
                }
            }
            Stripe.layoutButton(data, eachButton, setBounds);
        }
        if (!sidesStarted && processDrop) {
            this.tryDroppingOnGap(data, gap, -1);
        }
        if (this.isDroppingButton()) {
            Dimension dragSize = this.myDragButton.getPreferredSize();
            if (this.getAnchor().isHorizontal() == this.myDragButton.getWindowInfo().getAnchor().isHorizontal()) {
                data.size.width = Math.max(data.size.width, dragSize.width);
                data.size.height = Math.max(data.size.height, dragSize.height);
            } else {
                data.size.width = Math.max(data.size.width, dragSize.height);
                data.size.height = Math.max(data.size.height, dragSize.width);
            }
        }
        if (processDrop && !data.dragTargetChoosen) {
            data.dragInsertPosition = -1;
            data.dragToSide = true;
            data.dragTargetChoosen = true;
        }
        return data;
    }

    private void tryDroppingOnGap(LayoutData data, int gap, int insertOrder) {
        int sideDistance;
        int nonSideDistance;
        if (data.dragTargetChoosen) {
            return;
        }
        if (data.horizontal) {
            nonSideDistance = this.myDropRectangle.x - data.eachX;
            sideDistance = data.eachX + gap - this.myDropRectangle.x;
        } else {
            nonSideDistance = this.myDropRectangle.y - data.eachY;
            sideDistance = data.eachY + gap - this.myDropRectangle.y;
        }
        nonSideDistance = Math.max(0, nonSideDistance);
        if (sideDistance > 0) {
            if (nonSideDistance > sideDistance) {
                data.dragInsertPosition = insertOrder;
                data.dragToSide = true;
                data.dragTargetChoosen = true;
            } else {
                data.dragInsertPosition = -1;
                data.dragToSide = false;
                data.dragTargetChoosen = true;
            }
            Stripe.layoutButton(data, this.myDragButtonImage, false);
        }
    }

    private List<StripeButton> getButtonsToLayOut() {
        ArrayList<StripeButton> result2 = new ArrayList<StripeButton>();
        ArrayList<StripeButton> tools = new ArrayList<StripeButton>();
        ArrayList<StripeButton> sideTools = new ArrayList<StripeButton>();
        for (StripeButton b : this.myButtons) {
            if (!this.isConsideredInLayout(b)) continue;
            if (b.getWindowInfo().isSplit()) {
                sideTools.add(b);
                continue;
            }
            tools.add(b);
        }
        result2.addAll(tools);
        result2.addAll(sideTools);
        return result2;
    }

    public ToolWindowAnchor getAnchor() {
        return ToolWindowAnchor.get((int)this.myAnchor);
    }

    private static void layoutButton(LayoutData data, JComponent eachButton, boolean setBounds) {
        Dimension eachSize = eachButton.getPreferredSize();
        if (setBounds) {
            int width = data.horizontal ? eachSize.width : data.fitSize.width;
            int height = data.horizontal ? data.fitSize.height : eachSize.height;
            eachButton.setBounds(data.eachX, data.eachY, width, height);
        }
        if (data.horizontal) {
            int deltaX = eachSize.width + data.gap;
            data.eachX += deltaX;
            data.size.width += deltaX;
            data.size.height = eachSize.height;
        } else {
            int deltaY = eachSize.height + data.gap;
            data.eachY += deltaY;
            data.size.width = eachSize.width;
            data.size.height += deltaY;
        }
        ++data.processedComponents;
    }

    public void startDrag() {
        this.revalidate();
        this.repaint();
    }

    public void stopDrag() {
        this.revalidate();
        this.repaint();
    }

    public StripeButton getButtonFor(String toolWindowId) {
        for (StripeButton each : this.myButtons) {
            if (!each.getWindowInfo().getId().equals(toolWindowId)) continue;
            return each;
        }
        return null;
    }

    public void setOverlayed(boolean overlayed) {
        if (Registry.is((String)"disable.toolwindow.overlay")) {
            return;
        }
        Color bg = UIUtil.getPanelBackground();
        if (UIUtil.isUnderAquaLookAndFeel()) {
            float[] result2 = Color.RGBtoHSB(bg.getRed(), bg.getGreen(), bg.getBlue(), new float[3]);
            bg = new Color(Color.HSBtoRGB(result2[0], result2[1], result2[2] - 0.08f > 0.0f ? result2[2] - 0.08f : result2[2]));
        }
        if (overlayed) {
            this.setBackground(ColorUtil.toAlpha((Color)bg, (int)190));
        } else {
            this.setBackground(bg);
        }
    }

    private boolean isHorizontal() {
        return this.myAnchor == 1 || this.myAnchor == 3;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myPrefSize == null) {
            this.myPrefSize = this.recomputeBounds((boolean)false, null).size;
        }
        return this.myPrefSize;
    }

    void updatePresentation() {
        for (StripeButton button : this.myButtons) {
            button.updatePresentation();
        }
    }

    public boolean containsScreen(@NotNull Rectangle screenRec) {
        if (screenRec == null) {
            Stripe.$$$reportNull$$$0(2);
        }
        Point point = screenRec.getLocation();
        SwingUtilities.convertPointFromScreen(point, this);
        return new Rectangle(point, screenRec.getSize()).intersects(new Rectangle(-20, -20, this.getWidth() + 20, this.getHeight() + 20));
    }

    public void finishDrop() {
        if (this.myLastLayoutData == null || !this.isDroppingButton()) {
            return;
        }
        WindowInfoImpl info = this.myDragButton.getDecorator().getWindowInfo();
        this.myFinishingDrop = true;
        this.myManager.setSideToolAndAnchor(info.getId(), ToolWindowAnchor.get((int)this.myAnchor), this.myLastLayoutData.dragInsertPosition, this.myLastLayoutData.dragToSide);
        this.myManager.invokeLater(() -> this.resetDrop());
    }

    public void resetDrop() {
        this.myDragButton = null;
        this.myDragButtonImage = null;
        this.myFinishingDrop = false;
        this.myPrefSize = null;
        this.revalidate();
        this.repaint();
    }

    public void processDropButton(StripeButton button, JComponent buttonImage, Point screenPoint) {
        if (!this.isDroppingButton()) {
            BufferedImage image = UIUtil.createImage((Component)button, (int)button.getWidth(), (int)button.getHeight(), (int)1);
            buttonImage.paint(image.getGraphics());
            this.myDragButton = button;
            this.myDragButtonImage = buttonImage;
            this.myPrefSize = null;
        }
        Point point = new Point(screenPoint);
        SwingUtilities.convertPointFromScreen(point, this);
        this.myDropRectangle = new Rectangle(point, buttonImage.getSize());
        this.revalidate();
        this.repaint();
    }

    private boolean isDroppingButton() {
        return this.myDragButton != null;
    }

    private boolean isConsideredInLayout(StripeButton each) {
        return each.isVisible();
    }

    @Override
    public String toString() {
        String anchor2 = null;
        switch (this.myAnchor) {
            case 1: {
                anchor2 = "TOP";
                break;
            }
            case 3: {
                anchor2 = "BOTTOM";
                break;
            }
            case 2: {
                anchor2 = "LEFT";
                break;
            }
            case 4: {
                anchor2 = "RIGHT";
            }
        }
        return this.getClass().getName() + " " + anchor2;
    }

    private BufferedImage getCachedImage() {
        if (this.myCachedBg == null) {
            BufferedImage bg;
            ToolWindowAnchor anchor2 = this.getAnchor();
            Rectangle bounds2 = this.getBounds();
            if (anchor2 == ToolWindowAnchor.LEFT || anchor2 == ToolWindowAnchor.RIGHT) {
                bg = (BufferedImage)this.createImage(bounds2.width, 50);
                Graphics2D graphics = bg.createGraphics();
                graphics.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)new Color(0, 0, 0, 10), (float)bounds2.width, (float)0.0f, (Color)new Color(0, 0, 0, 0)));
                graphics.fillRect(0, 0, bounds2.width, 50);
                graphics.dispose();
            } else {
                bg = (BufferedImage)this.createImage(50, bounds2.height);
                Graphics2D graphics = bg.createGraphics();
                graphics.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)new Color(0, 0, 0, 0), (float)0.0f, (float)bounds2.height, (Color)new Color(0, 0, 0, 10)));
                graphics.fillRect(0, 0, 50, bounds2.height);
                graphics.dispose();
            }
            this.myCachedBg = bg;
        }
        return this.myCachedBg;
    }

    @Override
    protected Graphics getComponentGraphics(Graphics g) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(g));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.myFinishingDrop && this.isDroppingButton() && this.myDragButton.getParent() != this) {
            g.setColor(this.getBackground().brighter());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (UIUtil.isUnderDarcula()) {
            return;
        }
        ToolWindowAnchor anchor2 = this.getAnchor();
        g.setColor(new Color(255, 255, 255, 40));
        Rectangle r = this.getBounds();
        if (anchor2 == ToolWindowAnchor.LEFT || anchor2 == ToolWindowAnchor.RIGHT) {
            UIUtil.drawLine((Graphics)g, (int)0, (int)0, (int)0, (int)r.height);
            UIUtil.drawLine((Graphics)g, (int)(r.width - 2), (int)0, (int)(r.width - 2), (int)r.height);
        } else {
            UIUtil.drawLine((Graphics)g, (int)0, (int)1, (int)r.width, (int)1);
            UIUtil.drawLine((Graphics)g, (int)0, (int)(r.height - 1), (int)r.width, (int)(r.height - 1));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenRec";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/Stripe";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addButton";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeButton";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "containsScreen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyKeymapManagerListener
    implements KeymapManagerListener {
        private MyKeymapManagerListener() {
        }

        public void activeKeymapChanged(Keymap keymap) {
            Stripe.this.updatePresentation();
        }
    }

    private static class LayoutData {
        int eachX;
        int eachY;
        int gap;
        Dimension size;
        Dimension fitSize;
        boolean horizontal;
        int processedComponents;
        boolean dragTargetChoosen;
        boolean dragToSide;
        int dragInsertPosition;

        private LayoutData() {
        }
    }

    private static class AdaptiveBorder
    implements Border {
        private AdaptiveBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Insets insets = ((JComponent)c).getInsets();
            g.setColor(UIUtil.CONTRAST_BORDER_COLOR);
            AdaptiveBorder.drawBorder(g, x, y, width, height, insets);
        }

        private static void drawBorder(Graphics g, int x, int y, int width, int height, Insets insets) {
            if (insets.top == 1) {
                UIUtil.drawLine((Graphics)g, (int)x, (int)y, (int)(x + width), (int)y);
            }
            if (insets.right == 1) {
                UIUtil.drawLine((Graphics)g, (int)(x + width - 1), (int)y, (int)(x + width - 1), (int)(y + height));
            }
            if (insets.left == 1) {
                UIUtil.drawLine((Graphics)g, (int)x, (int)y, (int)x, (int)(y + height));
            }
            if (insets.bottom == 1) {
                UIUtil.drawLine((Graphics)g, (int)x, (int)(y + height - 1), (int)(x + width), (int)(y + height - 1));
            }
            if (UIUtil.isUnderDarcula()) {
                Color c = g.getColor();
                if (insets.top == 2) {
                    g.setColor(c);
                    UIUtil.drawLine((Graphics)g, (int)x, (int)y, (int)(x + width), (int)y);
                    g.setColor((Color)Gray._85);
                    UIUtil.drawLine((Graphics)g, (int)x, (int)(y + 1), (int)(x + width), (int)(y + 1));
                }
                if (insets.right == 2) {
                    g.setColor((Color)Gray._85);
                    UIUtil.drawLine((Graphics)g, (int)(x + width - 1), (int)y, (int)(x + width - 1), (int)(y + height));
                    g.setColor(c);
                    UIUtil.drawLine((Graphics)g, (int)(x + width - 2), (int)y, (int)(x + width - 2), (int)(y + height));
                }
                if (insets.left == 2) {
                    g.setColor((Color)Gray._85);
                    UIUtil.drawLine((Graphics)g, (int)(x + 1), (int)y, (int)(x + 1), (int)(y + height));
                    g.setColor(c);
                    UIUtil.drawLine((Graphics)g, (int)x, (int)y, (int)x, (int)(y + height));
                }
                if (insets.bottom == 2) {
                    // empty if block
                }
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Stripe stripe = (Stripe)c;
            ToolWindowAnchor anchor2 = stripe.getAnchor();
            if (anchor2 == ToolWindowAnchor.LEFT) {
                return new Insets(1, 0, 0, 1);
            }
            if (anchor2 == ToolWindowAnchor.RIGHT) {
                return new Insets(1, 1, 0, 0);
            }
            if (anchor2 == ToolWindowAnchor.TOP) {
                return new Insets(1, 0, 0, 0);
            }
            return new Insets(1, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

