/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.BinaryEncoder;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.patch.BlobIndexUtil;
import com.intellij.util.ArrayUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryPatchWriter {
    private static final Logger LOG = Logger.getInstance(BinaryFilePatch.class);
    private static final String GIT_DIFF_HEADER = "diff --git %s %s";
    private static final String FILE_MODE_HEADER = "%s file mode %d";
    private static final String INDEX_SHA1_HEADER = "index %s..%s";
    private static final String GIT_BINARY_HEADER = "GIT binary patch";
    private static final String LITERAL_HEADER = "literal %d";

    public static void writeBinaries(@Nullable String basePath, @NotNull List<? extends BinaryFilePatch> patches2, @NotNull Writer writer) throws IOException {
        if (patches2 == null) {
            BinaryPatchWriter.$$$reportNull$$$0(0);
        }
        if (writer == null) {
            BinaryPatchWriter.$$$reportNull$$$0(1);
        }
        String lineSeparator = "\n";
        for (FilePatch filePatch : patches2) {
            BinaryFilePatch filePatch2 = (BinaryFilePatch)filePatch;
            writer.write(String.format(GIT_DIFF_HEADER, filePatch2.getBeforeName(), filePatch2.getAfterName()));
            writer.write(lineSeparator);
            File afterFile = new File(basePath, filePatch2.getAfterName());
            if (filePatch2.isDeletedFile()) {
                writer.write(BinaryPatchWriter.getFileModeHeader(FileStatus.DELETED, 100644));
                writer.write(lineSeparator);
            } else if (filePatch2.isNewFile()) {
                writer.write(BinaryPatchWriter.getFileModeHeader(FileStatus.ADDED, !SystemInfo.isWindows && afterFile.canExecute() ? 100755 : 100644));
                writer.write(lineSeparator);
            }
            byte[] afterContent = filePatch2.getAfterContent();
            writer.write(BinaryPatchWriter.getIndexHeader(filePatch2.isNewFile() ? BlobIndexUtil.NOT_COMMITTED_HASH : BinaryPatchWriter.getSha1ForContent(filePatch2.getBeforeContent()), filePatch2.isDeletedFile() ? BlobIndexUtil.NOT_COMMITTED_HASH : BinaryPatchWriter.getSha1ForContent(afterContent)));
            writer.write(lineSeparator);
            writer.write(GIT_BINARY_HEADER);
            writer.write(lineSeparator);
            writer.write(String.format(LITERAL_HEADER, afterContent == null ? 0 : afterContent.length));
            writer.write(lineSeparator);
            try {
                BinaryEncoder.encode(new ByteArrayInputStream(afterContent != null ? afterContent : ArrayUtil.EMPTY_BYTE_ARRAY), writer);
            }
            catch (BinaryEncoder.BinaryPatchException e) {
                LOG.error("Can't write patch for binary file: " + afterFile.getPath(), (Throwable)e);
            }
            writer.write(lineSeparator);
        }
    }

    @NotNull
    private static String getFileModeHeader(@NotNull FileStatus fileStatus, int mode) {
        if (fileStatus == null) {
            BinaryPatchWriter.$$$reportNull$$$0(2);
        }
        String string = String.format(FILE_MODE_HEADER, fileStatus == FileStatus.DELETED ? "deleted" : "new", mode);
        if (string == null) {
            BinaryPatchWriter.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String getIndexHeader(@NotNull String beforeHash, @NotNull String afterHash) {
        if (beforeHash == null) {
            BinaryPatchWriter.$$$reportNull$$$0(4);
        }
        if (afterHash == null) {
            BinaryPatchWriter.$$$reportNull$$$0(5);
        }
        String string = String.format(INDEX_SHA1_HEADER, beforeHash, afterHash);
        if (string == null) {
            BinaryPatchWriter.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static String getSha1ForContent(@Nullable byte[] content) {
        String string = content != null ? BlobIndexUtil.getSha1(content) : BlobIndexUtil.NOT_COMMITTED_HASH;
        if (string == null) {
            BinaryPatchWriter.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patches";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStatus";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/BinaryPatchWriter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeHash";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/BinaryPatchWriter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileModeHeader";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexHeader";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSha1ForContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeBinaries";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileModeHeader";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIndexHeader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

