/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.SmartHashSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class TodoFilter
implements Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.todo.TodoFilter");
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ELEMENT_PATTERN = "pattern";
    private static final String ATTRIBUTE_INDEX = "index";
    private String myName;
    private Set<TodoPattern> myTodoPatterns;

    public TodoFilter() {
        this.setName("");
        this.myTodoPatterns = new SmartHashSet();
    }

    public TodoFilter(@NotNull Element element, @NotNull List<TodoPattern> patterns) {
        if (element == null) {
            TodoFilter.$$$reportNull$$$0(0);
        }
        if (patterns == null) {
            TodoFilter.$$$reportNull$$$0(1);
        }
        this.setName("");
        this.myTodoPatterns = new SmartHashSet();
        this.readExternal(element, patterns);
    }

    public boolean accept(PsiTodoSearchHelper searchHelper, PsiFile psiFile) {
        Iterator<TodoPattern> i = this.iterator();
        while (i.hasNext()) {
            TodoPattern todoPattern = i.next();
            if (searchHelper.getTodoItemsCount(psiFile, todoPattern) <= 0) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            TodoFilter.$$$reportNull$$$0(2);
        }
        this.myName = name;
    }

    public boolean contains(TodoPattern pattern) {
        return this.myTodoPatterns.contains(pattern);
    }

    public void addTodoPattern(TodoPattern pattern) {
        LOG.assertTrue(!this.myTodoPatterns.contains(pattern));
        this.myTodoPatterns.add(pattern);
    }

    public void removeTodoPattern(TodoPattern pattern) {
        LOG.assertTrue(this.myTodoPatterns.contains(pattern));
        this.myTodoPatterns.remove(pattern);
    }

    public Iterator<TodoPattern> iterator() {
        return this.myTodoPatterns.iterator();
    }

    public boolean isEmpty() {
        return this.myTodoPatterns.isEmpty();
    }

    private void readExternal(@NotNull Element element, @NotNull List<TodoPattern> patterns) {
        if (element == null) {
            TodoFilter.$$$reportNull$$$0(3);
        }
        if (patterns == null) {
            TodoFilter.$$$reportNull$$$0(4);
        }
        this.myName = element.getAttributeValue(ATTRIBUTE_NAME);
        if (this.myName == null) {
            throw new IllegalArgumentException();
        }
        this.myTodoPatterns.clear();
        for (Element child2 : element.getChildren(ELEMENT_PATTERN)) {
            try {
                TodoPattern pattern;
                int index = Integer.parseInt(child2.getAttributeValue(ATTRIBUTE_INDEX));
                if (index < 0 || index > patterns.size() - 1 || this.myTodoPatterns.contains(pattern = patterns.get(index))) continue;
                this.myTodoPatterns.add(pattern);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void writeExternal(Element element, TodoPattern[] patterns) {
        element.setAttribute(ATTRIBUTE_NAME, this.myName);
        for (TodoPattern pattern : this.myTodoPatterns) {
            int index = ArrayUtilRt.find((Object[])patterns, (Object)pattern);
            LOG.assertTrue(index != -1);
            Element child2 = new Element(ELEMENT_PATTERN);
            child2.setAttribute(ATTRIBUTE_INDEX, Integer.toString(index));
            element.addContent(child2);
        }
    }

    public int hashCode() {
        int hashCode = this.myName.hashCode();
        for (TodoPattern myTodoPattern : this.myTodoPatterns) {
            hashCode += myTodoPattern.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TodoFilter)) {
            return false;
        }
        TodoFilter filter = (TodoFilter)obj;
        if (!this.myName.equals(filter.myName)) {
            return false;
        }
        if (this.myTodoPatterns.size() != filter.myTodoPatterns.size()) {
            return false;
        }
        for (TodoPattern pattern : this.myTodoPatterns) {
            if (filter.contains(pattern)) continue;
            return false;
        }
        return true;
    }

    public TodoFilter clone() {
        try {
            TodoFilter filter = (TodoFilter)super.clone();
            filter.myTodoPatterns = new HashSet<TodoPattern>(this.myTodoPatterns);
            return filter;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_NAME;
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/todo/TodoFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

