/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowManager;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowContentAction
extends AnAction
implements DumbAware {
    private ToolWindow myWindow;

    public ShowContentAction() {
    }

    public ShowContentAction(ToolWindow window, JComponent c, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ShowContentAction.$$$reportNull$$$0(0);
        }
        this.myWindow = window;
        AnAction original = ActionManager.getInstance().getAction("ShowContent");
        new ShadowAction((AnAction)this, original, c, parentDisposable);
        this.copyFrom(original);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowContentAction.$$$reportNull$$$0(1);
        }
        ToolWindow window = this.getWindow(e);
        e.getPresentation().setEnabledAndVisible(window != null && window.getContentManager().getContentCount() > 1);
        e.getPresentation().setText(window == null || window.getContentUiType() == ToolWindowContentUiType.TABBED ? "Show List of Tabs" : "Show List of Views");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowContentAction.$$$reportNull$$$0(2);
        }
        this.getWindow(e).showContentPopup(e.getInputEvent());
    }

    @Nullable
    private ToolWindow getWindow(AnActionEvent event) {
        if (this.myWindow != null) {
            return this.myWindow;
        }
        Project project = event.getProject();
        if (project == null) {
            return null;
        }
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
        ToolWindow window = manager.getToolWindow(manager.getActiveToolWindowId());
        if (window == null) {
            return null;
        }
        Component context = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(event.getDataContext());
        if (context == null) {
            return null;
        }
        return SwingUtilities.isDescendingFrom(window.getComponent(), context) ? window : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/ShowContentAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

