/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import gnu.trove.TIntFunction;
import gnu.trove.TObjectIntHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeverityRegistrar
implements Comparator<HighlightSeverity> {
    static final int SHOWN_SEVERITIES_OFFSET = 1;
    private static final Logger LOG = Logger.getInstance(SeverityRegistrar.class);
    @NonNls
    private static final String INFO_TAG = "info";
    @NonNls
    private static final String COLOR_ATTRIBUTE = "color";
    private final Map<String, SeverityBasedTextAttributes> myMap;
    private final Map<String, Color> myRendererColors;
    static final Topic<Runnable> SEVERITIES_CHANGED_TOPIC = Topic.create((String)"SEVERITIES_CHANGED_TOPIC", Runnable.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_PARENT);
    @NotNull
    private final MessageBus myMessageBus;
    private volatile OrderMap myOrderMap;
    private JDOMExternalizableStringList myReadOrder;
    private static final Map<String, HighlightInfoType> STANDARD_SEVERITIES = ContainerUtil.newConcurrentMap();
    private static final AtomicFieldUpdater<SeverityRegistrar, OrderMap> ORDER_MAP_UPDATER;

    public SeverityRegistrar(@NotNull MessageBus messageBus) {
        if (messageBus == null) {
            SeverityRegistrar.$$$reportNull$$$0(0);
        }
        this.myMap = ContainerUtil.newConcurrentMap();
        this.myRendererColors = ContainerUtil.newConcurrentMap();
        this.myMessageBus = messageBus;
    }

    public static void registerStandard(@NotNull HighlightInfoType highlightInfoType, @NotNull HighlightSeverity highlightSeverity) {
        if (highlightInfoType == null) {
            SeverityRegistrar.$$$reportNull$$$0(1);
        }
        if (highlightSeverity == null) {
            SeverityRegistrar.$$$reportNull$$$0(2);
        }
        STANDARD_SEVERITIES.put(highlightSeverity.getName(), highlightInfoType);
    }

    @NotNull
    public static SeverityRegistrar getSeverityRegistrar(@Nullable Project project) {
        SeverityRegistrar severityRegistrar = project == null ? InspectionProfileManager.getInstance().getSeverityRegistrar() : InspectionProfileManager.getInstance(project).getCurrentProfile().getProfileManager().getSeverityRegistrar();
        if (severityRegistrar == null) {
            SeverityRegistrar.$$$reportNull$$$0(3);
        }
        return severityRegistrar;
    }

    public void registerSeverity(@NotNull SeverityBasedTextAttributes info, Color renderColor) {
        if (info == null) {
            SeverityRegistrar.$$$reportNull$$$0(4);
        }
        HighlightSeverity severity = info.getType().getSeverity(null);
        this.myMap.put(severity.getName(), info);
        if (renderColor != null) {
            this.myRendererColors.put(severity.getName(), renderColor);
        }
        this.myOrderMap = null;
        HighlightDisplayLevel.registerSeverity((HighlightSeverity)severity, (TextAttributesKey)this.getHighlightInfoTypeBySeverity(severity).getAttributesKey(), null);
        this.severitiesChanged();
    }

    private void severitiesChanged() {
        ((Runnable)this.myMessageBus.syncPublisher(SEVERITIES_CHANGED_TOPIC)).run();
    }

    public SeverityBasedTextAttributes unregisterSeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            SeverityRegistrar.$$$reportNull$$$0(5);
        }
        return this.myMap.remove(severity.getName());
    }

    @NotNull
    public HighlightInfoType.HighlightInfoTypeImpl getHighlightInfoTypeBySeverity(@NotNull HighlightSeverity severity) {
        HighlightInfoType infoType;
        if (severity == null) {
            SeverityRegistrar.$$$reportNull$$$0(6);
        }
        if ((infoType = STANDARD_SEVERITIES.get(severity.getName())) != null) {
            HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = (HighlightInfoType.HighlightInfoTypeImpl)infoType;
            if (highlightInfoTypeImpl == null) {
                SeverityRegistrar.$$$reportNull$$$0(7);
            }
            return highlightInfoTypeImpl;
        }
        if (severity == HighlightSeverity.INFORMATION) {
            HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = (HighlightInfoType.HighlightInfoTypeImpl)HighlightInfoType.INFORMATION;
            if (highlightInfoTypeImpl == null) {
                SeverityRegistrar.$$$reportNull$$$0(8);
            }
            return highlightInfoTypeImpl;
        }
        SeverityBasedTextAttributes type = this.getAttributesBySeverity(severity);
        HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = (HighlightInfoType.HighlightInfoTypeImpl)(type == null ? HighlightInfoType.WARNING : type.getType());
        if (highlightInfoTypeImpl == null) {
            SeverityRegistrar.$$$reportNull$$$0(9);
        }
        return highlightInfoTypeImpl;
    }

    private SeverityBasedTextAttributes getAttributesBySeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            SeverityRegistrar.$$$reportNull$$$0(10);
        }
        return this.myMap.get(severity.getName());
    }

    @Nullable
    public TextAttributes getTextAttributesBySeverity(@NotNull HighlightSeverity severity) {
        SeverityBasedTextAttributes infoType;
        if (severity == null) {
            SeverityRegistrar.$$$reportNull$$$0(11);
        }
        if ((infoType = this.getAttributesBySeverity(severity)) != null) {
            return infoType.getAttributes();
        }
        return null;
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            SeverityRegistrar.$$$reportNull$$$0(12);
        }
        this.myMap.clear();
        this.myRendererColors.clear();
        for (Element infoElement : element.getChildren(INFO_TAG)) {
            SeverityBasedTextAttributes highlightInfo = new SeverityBasedTextAttributes(infoElement);
            String colorStr = infoElement.getAttributeValue(COLOR_ATTRIBUTE);
            Color color = colorStr == null ? null : new Color(Integer.parseInt(colorStr, 16));
            this.registerSeverity(highlightInfo, color);
        }
        this.myReadOrder = new JDOMExternalizableStringList();
        this.myReadOrder.readExternal(element);
        ArrayList<HighlightSeverity> read2 = new ArrayList<HighlightSeverity>(this.myReadOrder.size());
        List<HighlightSeverity> knownSeverities = this.getDefaultOrder();
        for (String name : this.myReadOrder) {
            HighlightSeverity severity = this.getSeverity(name);
            if (severity == null || !knownSeverities.contains(severity)) continue;
            read2.add(severity);
        }
        this.myOrderMap = this.ensureAllStandardIncluded(read2, knownSeverities);
        this.severitiesChanged();
    }

    private OrderMap ensureAllStandardIncluded(List<? extends HighlightSeverity> read2, List<? extends HighlightSeverity> knownSeverities) {
        OrderMap orderMap = SeverityRegistrar.fromList(read2);
        if (orderMap.isEmpty()) {
            orderMap = SeverityRegistrar.fromList(knownSeverities);
        } else {
            List<HighlightSeverity> list2 = this.getSortedSeverities(orderMap);
            block0: for (HighlightSeverity highlightSeverity : knownSeverities) {
                if (list2.contains(highlightSeverity)) continue;
                for (int oIdx = 0; oIdx < list2.size(); ++oIdx) {
                    HighlightSeverity orderSeverity = list2.get(oIdx);
                    if (orderSeverity.myVal <= highlightSeverity.myVal) continue;
                    list2.add(oIdx, highlightSeverity);
                    this.myReadOrder = null;
                    continue block0;
                }
            }
            orderMap = SeverityRegistrar.fromList(list2);
        }
        return orderMap;
    }

    public void writeExternal(Element element) {
        List<HighlightSeverity> list2 = this.getAllSeverities();
        for (HighlightSeverity severity : list2) {
            Element info = new Element(INFO_TAG);
            String severityName = severity.getName();
            SeverityBasedTextAttributes infoType = this.getAttributesBySeverity(severity);
            if (infoType == null) continue;
            infoType.writeExternal(info);
            Color color = this.myRendererColors.get(severityName);
            if (color != null) {
                info.setAttribute(COLOR_ATTRIBUTE, Integer.toString(color.getRGB() & 0xFFFFFF, 16));
            }
            element.addContent(info);
        }
        if (this.myReadOrder != null && !this.myReadOrder.isEmpty()) {
            this.myReadOrder.writeExternal(element);
        } else if (!this.getDefaultOrder().equals(list2)) {
            JDOMExternalizableStringList ext = new JDOMExternalizableStringList(Collections.nCopies(this.getOrderMap().size(), ""));
            this.getOrderMap().forEachEntry((orderSeverity, oIdx) -> {
                ext.set(oIdx, (Object)orderSeverity.getName());
                return true;
            });
            ext.writeExternal(element);
        }
    }

    @NotNull
    public List<HighlightSeverity> getAllSeverities() {
        List<HighlightSeverity> list2 = this.getSortedSeverities(this.getOrderMap());
        if (list2 == null) {
            SeverityRegistrar.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @NotNull
    private List<HighlightSeverity> getSortedSeverities(OrderMap map) {
        List<HighlightSeverity> list2 = Arrays.stream(map.keys()).map(o -> (HighlightSeverity)o).sorted((o1, o2) -> this.compare((HighlightSeverity)o1, (HighlightSeverity)o2, map)).collect(Collectors.toList());
        if (list2 == null) {
            SeverityRegistrar.$$$reportNull$$$0(14);
        }
        return list2;
    }

    int getSeveritiesCount() {
        return STANDARD_SEVERITIES.size() + this.myMap.size();
    }

    public HighlightSeverity getSeverityByIndex(int i) {
        HighlightSeverity[] found = new HighlightSeverity[1];
        this.getOrderMap().forEachEntry((severity, order) -> {
            if (order == i) {
                found[0] = severity;
                return false;
            }
            return true;
        });
        return found[0];
    }

    int getSeverityMaxIndex() {
        int[] values = this.getOrderMap().getValues();
        int max = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i] <= max) continue;
            max = values[i];
        }
        return max;
    }

    @Nullable
    public HighlightSeverity getSeverity(@NotNull String name) {
        HighlightInfoType type;
        if (name == null) {
            SeverityRegistrar.$$$reportNull$$$0(15);
        }
        if ((type = STANDARD_SEVERITIES.get(name)) != null) {
            return type.getSeverity(null);
        }
        SeverityBasedTextAttributes attributes = this.myMap.get(name);
        if (attributes != null) {
            return attributes.getSeverity();
        }
        return null;
    }

    Icon getRendererIconByIndex(int i) {
        HighlightSeverity severity = this.getSeverityByIndex(i);
        HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
        if (level != null) {
            return level.getIcon();
        }
        return HighlightDisplayLevel.createIconByMask((Color)this.myRendererColors.get(severity.getName()));
    }

    public boolean isSeverityValid(@NotNull String severityName) {
        if (severityName == null) {
            SeverityRegistrar.$$$reportNull$$$0(16);
        }
        return STANDARD_SEVERITIES.containsKey(severityName) || this.myMap.containsKey(severityName);
    }

    @Override
    public int compare(@NotNull HighlightSeverity s1, @NotNull HighlightSeverity s2) {
        if (s1 == null) {
            SeverityRegistrar.$$$reportNull$$$0(17);
        }
        if (s2 == null) {
            SeverityRegistrar.$$$reportNull$$$0(18);
        }
        return this.compare(s1, s2, this.getOrderMap());
    }

    private int compare(@NotNull HighlightSeverity s1, @NotNull HighlightSeverity s2, @NotNull OrderMap orderMap) {
        if (s1 == null) {
            SeverityRegistrar.$$$reportNull$$$0(19);
        }
        if (s2 == null) {
            SeverityRegistrar.$$$reportNull$$$0(20);
        }
        if (orderMap == null) {
            SeverityRegistrar.$$$reportNull$$$0(21);
        }
        int o1 = orderMap.getOrder(s1);
        int o2 = orderMap.getOrder(s2);
        return o1 - o2;
    }

    @NotNull
    private OrderMap getOrderMap() {
        OrderMap orderMap;
        OrderMap defaultOrder = null;
        while ((orderMap = this.myOrderMap) == null) {
            boolean replaced;
            if (defaultOrder == null) {
                defaultOrder = SeverityRegistrar.fromList(this.getDefaultOrder());
            }
            if (!(replaced = ORDER_MAP_UPDATER.compareAndSet((Object)this, null, (Object)defaultOrder))) continue;
            orderMap = defaultOrder;
            break;
        }
        OrderMap orderMap2 = orderMap;
        if (orderMap2 == null) {
            SeverityRegistrar.$$$reportNull$$$0(22);
        }
        return orderMap2;
    }

    @NotNull
    private static OrderMap fromList(@NotNull List<? extends HighlightSeverity> orderList) {
        if (orderList == null) {
            SeverityRegistrar.$$$reportNull$$$0(23);
        }
        if (orderList.size() != new HashSet<HighlightSeverity>(orderList).size()) {
            LOG.error("Severities order list MUST contain only unique severities: " + orderList);
        }
        TObjectIntHashMap map = new TObjectIntHashMap();
        for (int i = 0; i < orderList.size(); ++i) {
            HighlightSeverity severity = orderList.get(i);
            map.put((Object)severity, i);
        }
        OrderMap orderMap = new OrderMap(map);
        if (orderMap == null) {
            SeverityRegistrar.$$$reportNull$$$0(24);
        }
        return orderMap;
    }

    @NotNull
    private List<HighlightSeverity> getDefaultOrder() {
        Collection<SeverityBasedTextAttributes> values = this.myMap.values();
        ArrayList<HighlightSeverity> order = new ArrayList<HighlightSeverity>(STANDARD_SEVERITIES.size() + values.size());
        for (HighlightInfoType type : STANDARD_SEVERITIES.values()) {
            order.add(type.getSeverity(null));
        }
        for (SeverityBasedTextAttributes attributes : values) {
            order.add(attributes.getSeverity());
        }
        ContainerUtil.sort(order);
        ArrayList<HighlightSeverity> arrayList = order;
        if (arrayList == null) {
            SeverityRegistrar.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    public void setOrder(@NotNull List<? extends HighlightSeverity> orderList) {
        if (orderList == null) {
            SeverityRegistrar.$$$reportNull$$$0(26);
        }
        this.myOrderMap = this.ensureAllStandardIncluded(orderList, this.getDefaultOrder());
        this.myReadOrder = null;
        this.severitiesChanged();
    }

    int getSeverityIdx(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            SeverityRegistrar.$$$reportNull$$$0(27);
        }
        return this.getOrderMap().getOrder(severity);
    }

    public static boolean isDefaultSeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            SeverityRegistrar.$$$reportNull$$$0(28);
        }
        return STANDARD_SEVERITIES.containsKey(severity.myName);
    }

    static boolean isGotoBySeverityEnabled(@NotNull HighlightSeverity minSeverity) {
        if (minSeverity == null) {
            SeverityRegistrar.$$$reportNull$$$0(29);
        }
        for (SeveritiesProvider provider : SeveritiesProvider.EP_NAME.getExtensionList()) {
            if (!provider.isGotoBySeverityEnabled(minSeverity)) continue;
            return true;
        }
        return minSeverity != HighlightSeverity.INFORMATION;
    }

    @NotNull
    Collection<SeverityBasedTextAttributes> allRegisteredAttributes() {
        Collection<SeverityBasedTextAttributes> collection = Collections.unmodifiableCollection(this.myMap.values());
        if (collection == null) {
            SeverityRegistrar.$$$reportNull$$$0(30);
        }
        return collection;
    }

    @NotNull
    Collection<HighlightInfoType> standardSeverities() {
        Collection<HighlightInfoType> collection = STANDARD_SEVERITIES.values();
        if (collection == null) {
            SeverityRegistrar.$$$reportNull$$$0(31);
        }
        return collection;
    }

    static {
        SeverityRegistrar.registerStandard(HighlightInfoType.ERROR, HighlightSeverity.ERROR);
        SeverityRegistrar.registerStandard(HighlightInfoType.WARNING, HighlightSeverity.WARNING);
        SeverityRegistrar.registerStandard(HighlightInfoType.INFO, HighlightSeverity.INFO);
        SeverityRegistrar.registerStandard(HighlightInfoType.WEAK_WARNING, HighlightSeverity.WEAK_WARNING);
        SeverityRegistrar.registerStandard(HighlightInfoType.GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER, HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING);
        STANDARD_SEVERITIES.put(HighlightDisplayLevel.DO_NOT_SHOW.getName(), HighlightInfoType.INFORMATION);
        ORDER_MAP_UPDATER = AtomicFieldUpdater.forFieldOfType(SeverityRegistrar.class, OrderMap.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 22: 
            case 24: 
            case 25: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 22: 
            case 24: 
            case 25: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightSeverity";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 22: 
            case 24: 
            case 25: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/SeverityRegistrar";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = INFO_TAG;
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityName";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderMap";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderList";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minSeverity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/SeverityRegistrar";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverityRegistrar";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightInfoTypeBySeverity";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSeverities";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedSeverities";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderMap";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "fromList";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultOrder";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "allRegisteredAttributes";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "standardSeverities";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerStandard";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 22: 
            case 24: 
            case 25: 
            case 30: 
            case 31: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerSeverity";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unregisterSeverity";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightInfoTypeBySeverity";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesBySeverity";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTextAttributesBySeverity";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSeverity";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isSeverityValid";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fromList";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setOrder";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSeverityIdx";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultSeverity";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isGotoBySeverityEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 22: 
            case 24: 
            case 25: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SeverityBasedTextAttributes {
        private final TextAttributes myAttributes;
        private final HighlightInfoType.HighlightInfoTypeImpl myType;

        SeverityBasedTextAttributes(@NotNull Element element) {
            if (element == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(0);
            }
            this(new TextAttributes(element), new HighlightInfoType.HighlightInfoTypeImpl(element));
        }

        public SeverityBasedTextAttributes(@NotNull TextAttributes attributes, @NotNull HighlightInfoType.HighlightInfoTypeImpl type) {
            if (attributes == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(1);
            }
            if (type == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(2);
            }
            this.myAttributes = attributes;
            this.myType = type;
        }

        @NotNull
        public TextAttributes getAttributes() {
            TextAttributes textAttributes = this.myAttributes;
            if (textAttributes == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(3);
            }
            return textAttributes;
        }

        @NotNull
        public HighlightInfoType.HighlightInfoTypeImpl getType() {
            HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = this.myType;
            if (highlightInfoTypeImpl == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(4);
            }
            return highlightInfoTypeImpl;
        }

        private void writeExternal(@NotNull Element element) {
            if (element == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(5);
            }
            this.myAttributes.writeExternal(element);
            this.myType.writeExternal(element);
        }

        @NotNull
        public HighlightSeverity getSeverity() {
            HighlightSeverity highlightSeverity = this.myType.getSeverity(null);
            if (highlightSeverity == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(6);
            }
            return highlightSeverity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SeverityBasedTextAttributes that = (SeverityBasedTextAttributes)o;
            if (!this.myAttributes.equals((Object)that.myAttributes)) {
                return false;
            }
            return this.myType.equals(that.myType);
        }

        public int hashCode() {
            int result2 = this.myAttributes.hashCode();
            result2 = 31 * result2 + this.myType.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/SeverityRegistrar$SeverityBasedTextAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/SeverityRegistrar$SeverityBasedTextAttributes";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeverity";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "writeExternal";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class OrderMap
    extends TObjectIntHashMap<HighlightSeverity> {
        private OrderMap(@NotNull TObjectIntHashMap<? extends HighlightSeverity> map) {
            if (map == null) {
                OrderMap.$$$reportNull$$$0(0);
            }
            super(map.size());
            map.forEachEntry((key, value) -> {
                super.put(key, value);
                return true;
            });
            this.trimToSize();
        }

        private int getOrder(@NotNull HighlightSeverity severity) {
            int index;
            if (severity == null) {
                OrderMap.$$$reportNull$$$0(1);
            }
            return (index = this.index(severity)) < 0 ? -1 : this._values[index];
        }

        public void clear() {
            throw new IncorrectOperationException("readonly");
        }

        protected void removeAt(int index) {
            throw new IncorrectOperationException("readonly");
        }

        public void transformValues(TIntFunction function) {
            throw new IncorrectOperationException("readonly");
        }

        public boolean adjustValue(HighlightSeverity key, int amount) {
            throw new IncorrectOperationException("readonly");
        }

        public int put(HighlightSeverity key, int value) {
            throw new IncorrectOperationException("readonly");
        }

        public int remove(HighlightSeverity key) {
            throw new IncorrectOperationException("readonly");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severity";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/SeverityRegistrar$OrderMap";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOrder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

