/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.openapi.options.Scheme;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemeNameGenerator {
    private static final String COPY_NAME_SUFFIX = "copy";

    private SchemeNameGenerator() {
    }

    public static String getUniqueName(@NotNull String preferredName, @NotNull Predicate<? super String> nameExistsPredicate) {
        if (preferredName == null) {
            SchemeNameGenerator.$$$reportNull$$$0(0);
        }
        if (nameExistsPredicate == null) {
            SchemeNameGenerator.$$$reportNull$$$0(1);
        }
        if (nameExistsPredicate.test(preferredName)) {
            String baseName;
            int numberPos;
            for (numberPos = preferredName.length() - 1; numberPos >= 0 && Character.isDigit(preferredName.charAt(numberPos)); --numberPos) {
            }
            String string = baseName = numberPos >= 0 ? preferredName.substring(0, numberPos + 1) : preferredName;
            if (!baseName.endsWith(COPY_NAME_SUFFIX)) {
                baseName = preferredName + " " + COPY_NAME_SUFFIX;
            }
            if (!nameExistsPredicate.test(baseName)) {
                return baseName;
            }
            int i = 1;
            while (true) {
                String newName;
                if (!nameExistsPredicate.test(newName = baseName + i)) {
                    return newName;
                }
                ++i;
            }
        }
        return preferredName;
    }

    public static String getUniqueName(@Nullable String preferredName, @Nullable Scheme parentScheme, @NotNull Predicate<? super String> nameExistsPredicate) {
        if (nameExistsPredicate == null) {
            SchemeNameGenerator.$$$reportNull$$$0(2);
        }
        assert (preferredName != null || parentScheme != null) : "Either preferredName or parentScheme must be non-null";
        String baseName = preferredName != null ? preferredName : parentScheme.getName();
        return SchemeNameGenerator.getUniqueName(baseName, nameExistsPredicate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "preferredName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "nameExistsPredicate";
                break;
            }
        }
        objectArray[1] = "com/intellij/application/options/schemes/SchemeNameGenerator";
        objectArray[2] = "getUniqueName";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

