/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionInGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultActionGroup
extends ActionGroup {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.DefaultActionGroup");
    private static final String CANT_ADD_ITSELF = "Cannot add a group to itself";
    private final List<AnAction> mySortedChildren;
    private final List<Pair<AnAction, Constraints>> myPairs;

    public DefaultActionGroup() {
        this(null, false);
    }

    public DefaultActionGroup(AnAction ... actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(0);
        }
        this(Arrays.asList(actions));
    }

    public DefaultActionGroup(@NotNull List<? extends AnAction> actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(1);
        }
        this(null, actions);
    }

    public DefaultActionGroup(@Nullable String name, @NotNull List<? extends AnAction> actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(2);
        }
        this(name, false);
        this.addActions(actions);
    }

    public DefaultActionGroup(@Nullable String shortName, boolean popup) {
        super(shortName, popup);
        this.mySortedChildren = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myPairs = ContainerUtil.createLockFreeCopyOnWriteList();
    }

    private void addActions(@NotNull List<? extends AnAction> actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(3);
        }
        HashSet<AnAction> actionSet = new HashSet<AnAction>();
        for (AnAction anAction : actions) {
            if (anAction == this) {
                throw new IllegalArgumentException(CANT_ADD_ITSELF);
            }
            if (anAction instanceof Separator || actionSet.add(anAction)) continue;
            throw new ActionDuplicationException(anAction);
        }
        this.mySortedChildren.addAll(actions);
    }

    public final void add(@NotNull AnAction action, @NotNull ActionManager actionManager) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(4);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(5);
        }
        this.add(action, Constraints.LAST, actionManager);
    }

    public final void add(@NotNull AnAction action) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(6);
        }
        this.addAction(action, Constraints.LAST);
    }

    @NotNull
    public final ActionInGroup addAction(@NotNull AnAction action) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(7);
        }
        ActionInGroup actionInGroup = this.addAction(action, Constraints.LAST);
        if (actionInGroup == null) {
            DefaultActionGroup.$$$reportNull$$$0(8);
        }
        return actionInGroup;
    }

    public final void addSeparator() {
        this.add(Separator.create());
    }

    public final void add(@NotNull AnAction action, @NotNull Constraints constraint) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(9);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(10);
        }
        this.add(action, constraint, ActionManager.getInstance());
    }

    @NotNull
    public final ActionInGroup addAction(@NotNull AnAction action, @NotNull Constraints constraint) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(11);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(12);
        }
        ActionInGroup actionInGroup = this.addAction(action, constraint, ActionManager.getInstance());
        if (actionInGroup == null) {
            DefaultActionGroup.$$$reportNull$$$0(13);
        }
        return actionInGroup;
    }

    public final void add(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(14);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(15);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(16);
        }
        this.addAction(action, constraint, actionManager);
    }

    @NotNull
    public final ActionInGroup addAction(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(17);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(18);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(19);
        }
        if (action == this) {
            throw new IllegalArgumentException(CANT_ADD_ITSELF);
        }
        if (!(action instanceof Separator)) {
            if (this.mySortedChildren.contains(action)) {
                throw new ActionDuplicationException(action);
            }
            for (Pair<AnAction, Constraints> pair : this.myPairs) {
                if (!action.equals(pair.first)) continue;
                throw new ActionDuplicationException(action);
            }
        }
        constraint = (Constraints)constraint.clone();
        if (constraint.myAnchor == Anchor.FIRST) {
            this.mySortedChildren.add(0, action);
        } else if (constraint.myAnchor == Anchor.LAST) {
            this.mySortedChildren.add(action);
        } else if (this.addToSortedList(action, constraint, actionManager)) {
            this.actionAdded(action, actionManager);
        } else {
            this.myPairs.add((Pair<AnAction, Constraints>)Pair.create((Object)action, (Object)constraint));
        }
        ActionInGroup actionInGroup = new ActionInGroup(this, action);
        if (actionInGroup == null) {
            DefaultActionGroup.$$$reportNull$$$0(20);
        }
        return actionInGroup;
    }

    private void actionAdded(@NotNull AnAction addedAction, @NotNull ActionManager actionManager) {
        String addedActionId;
        if (addedAction == null) {
            DefaultActionGroup.$$$reportNull$$$0(21);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(22);
        }
        String string = addedActionId = addedAction instanceof ActionStub ? ((ActionStub)addedAction).getId() : actionManager.getId(addedAction);
        if (addedActionId == null) {
            return;
        }
        block0: while (!this.myPairs.isEmpty()) {
            for (int i = 0; i < this.myPairs.size(); ++i) {
                Pair<AnAction, Constraints> pair = this.myPairs.get(i);
                if (!this.addToSortedList((AnAction)pair.first, (Constraints)pair.second, actionManager)) continue;
                this.myPairs.remove(i);
                continue block0;
            }
        }
    }

    private boolean addToSortedList(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        int index2;
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(23);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(24);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(25);
        }
        if ((index2 = DefaultActionGroup.findIndex(constraint.myRelativeToActionId, this.mySortedChildren, actionManager)) == -1) {
            return false;
        }
        if (constraint.myAnchor == Anchor.BEFORE) {
            this.mySortedChildren.add(index2, action);
        } else {
            this.mySortedChildren.add(index2 + 1, action);
        }
        return true;
    }

    private static int findIndex(String actionId, @NotNull List<? extends AnAction> actions, @NotNull ActionManager actionManager) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(26);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(27);
        }
        for (int i = 0; i < actions.size(); ++i) {
            String id;
            AnAction action = actions.get(i);
            if (!(action instanceof ActionStub ? ((ActionStub)action).getId().equals(actionId) : (id = actionManager.getId(action)) != null && id.equals(actionId))) continue;
            return i;
        }
        return -1;
    }

    public final void remove(@NotNull AnAction action) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(28);
        }
        String id = ActionManager.getInstance().getId(action);
        this.remove(action, id);
    }

    public final void remove(@NotNull AnAction action, @Nullable String id) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(29);
        }
        if (!this.mySortedChildren.remove(action) && !this.mySortedChildren.removeIf(oldAction -> oldAction instanceof ActionStub && ((ActionStub)oldAction).getId().equals(id))) {
            for (int i = 0; i < this.myPairs.size(); ++i) {
                Pair<AnAction, Constraints> pair = this.myPairs.get(i);
                if (!((AnAction)pair.first).equals(action) && (!(pair.first instanceof ActionStub) || !((ActionStub)pair.first).getId().equals(id))) continue;
                this.myPairs.remove(i);
                break;
            }
        }
    }

    public final void removeAll() {
        this.mySortedChildren.clear();
        this.myPairs.clear();
    }

    public boolean replaceAction(@NotNull AnAction oldAction, @NotNull AnAction newAction) {
        int index2;
        if (oldAction == null) {
            DefaultActionGroup.$$$reportNull$$$0(30);
        }
        if (newAction == null) {
            DefaultActionGroup.$$$reportNull$$$0(31);
        }
        if ((index2 = this.mySortedChildren.indexOf(oldAction)) >= 0) {
            this.mySortedChildren.set(index2, newAction);
            return true;
        }
        for (int i = 0; i < this.myPairs.size(); ++i) {
            Pair<AnAction, Constraints> pair = this.myPairs.get(i);
            if (!((AnAction)pair.first).equals(newAction)) continue;
            this.myPairs.set(i, (Pair<AnAction, Constraints>)Pair.create((Object)newAction, (Object)pair.second));
            return true;
        }
        return false;
    }

    public void copyFromGroup(@NotNull DefaultActionGroup other) {
        if (other == null) {
            DefaultActionGroup.$$$reportNull$$$0(32);
        }
        this.copyFrom(other);
        this.setPopup(other.isPopup());
        this.mySortedChildren.clear();
        this.mySortedChildren.addAll(other.mySortedChildren);
        this.myPairs.clear();
        this.myPairs.addAll(other.myPairs);
    }

    @Override
    @NotNull
    public final AnAction[] getChildren(@Nullable AnActionEvent e) {
        int i;
        boolean hasNulls = false;
        int sortedSize = this.mySortedChildren.size();
        Object[] children = new AnAction[sortedSize + this.myPairs.size()];
        for (i = 0; i < sortedSize; ++i) {
            AnAction action = this.mySortedChildren.get(i);
            if (action == null) {
                LOG.error("Empty sorted child: " + this + ", " + this.getClass() + "; index=" + i);
            }
            if (action instanceof ActionStub) {
                if ((action = this.unStub(e, (ActionStub)action)) == null) {
                    LOG.error("Can't unstub " + this.mySortedChildren.get(i));
                } else {
                    this.mySortedChildren.set(i, action);
                }
            }
            hasNulls |= action == null;
            children[i] = action;
        }
        for (i = 0; i < this.myPairs.size(); ++i) {
            Pair<AnAction, Constraints> pair = this.myPairs.get(i);
            AnAction action = (AnAction)pair.first;
            if (action == null) {
                LOG.error("Empty pair child: " + this + ", " + this.getClass() + "; index=" + i);
            } else if (action instanceof ActionStub) {
                if ((action = this.unStub(e, (ActionStub)action)) == null) {
                    LOG.error("Can't unstub " + pair);
                } else {
                    this.myPairs.set(i, (Pair<AnAction, Constraints>)Pair.create((Object)action, (Object)pair.second));
                }
            }
            hasNulls |= action == null;
            children[i + sortedSize] = action;
        }
        if (hasNulls) {
            AnAction[] anActionArray = (AnAction[])ContainerUtil.mapNotNull((Object[])children, (Function)FunctionUtil.id(), (Object[])AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                DefaultActionGroup.$$$reportNull$$$0(33);
            }
            return anActionArray;
        }
        if (children == null) {
            DefaultActionGroup.$$$reportNull$$$0(34);
        }
        return children;
    }

    @Nullable
    private AnAction unStub(@Nullable AnActionEvent e, @NotNull ActionStub stub) {
        if (stub == null) {
            DefaultActionGroup.$$$reportNull$$$0(35);
        }
        ActionManager actionManager = e != null ? e.getActionManager() : ActionManager.getInstance();
        try {
            AnAction action = actionManager.getAction(stub.getId());
            if (action == null) {
                LOG.error("Null child action in group " + this + " of class " + this.getClass() + ", id=" + stub.getId());
                return null;
            }
            this.replace(stub, action);
            return action;
        }
        catch (Throwable e1) {
            LOG.error(e1);
            return null;
        }
    }

    public final int getChildrenCount() {
        return this.mySortedChildren.size() + this.myPairs.size();
    }

    @NotNull
    public final AnAction[] getChildActionsOrStubs() {
        int i;
        int sortedSize = this.mySortedChildren.size();
        AnAction[] children = new AnAction[sortedSize + this.myPairs.size()];
        for (i = 0; i < sortedSize; ++i) {
            children[i] = this.mySortedChildren.get(i);
        }
        for (i = 0; i < this.myPairs.size(); ++i) {
            children[i + sortedSize] = (AnAction)this.myPairs.get((int)i).first;
        }
        if (children == null) {
            DefaultActionGroup.$$$reportNull$$$0(36);
        }
        return children;
    }

    public final void addAll(@NotNull ActionGroup group) {
        if (group == null) {
            DefaultActionGroup.$$$reportNull$$$0(37);
        }
        for (AnAction each : group.getChildren(null)) {
            this.add(each);
        }
    }

    public final void addAll(@NotNull Collection<? extends AnAction> actionList) {
        if (actionList == null) {
            DefaultActionGroup.$$$reportNull$$$0(38);
        }
        for (AnAction anAction : actionList) {
            this.add(anAction);
        }
    }

    public final void addAll(AnAction ... actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(39);
        }
        for (AnAction each : actions) {
            this.add(each);
        }
    }

    public void addSeparator(@Nullable String separatorText) {
        this.add(Separator.create(separatorText));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 13: 
            case 20: 
            case 33: 
            case 34: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 13: 
            case 20: 
            case 33: 
            case 34: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 23: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 8: 
            case 13: 
            case 20: 
            case 33: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/DefaultActionGroup";
                break;
            }
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedAction";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldAction";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAction";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/DefaultActionGroup";
                break;
            }
            case 8: 
            case 13: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "addAction";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildActionsOrStubs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
            case 8: 
            case 13: 
            case 20: 
            case 33: 
            case 34: 
            case 36: {
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "actionAdded";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addToSortedList";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findIndex";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "replaceAction";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "copyFromGroup";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "unStub";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 13: 
            case 20: 
            case 33: 
            case 34: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ActionDuplicationException
    extends IllegalArgumentException {
        ActionDuplicationException(@NotNull AnAction action) {
            if (action == null) {
                ActionDuplicationException.$$$reportNull$$$0(0);
            }
            super("cannot add an action twice: " + action);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/actionSystem/DefaultActionGroup$ActionDuplicationException", "<init>"));
        }
    }
}

