/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.JSDebuggerSupportUtils;
import com.intellij.javascript.debugger.ChromeEvaluator;
import com.intellij.javascript.debugger.ExpressionInfoFactory;
import com.intellij.javascript.debugger.GlobalEvaluator;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupportKt;
import com.intellij.javascript.debugger.JavaScriptNameMapper;
import com.intellij.javascript.debugger.JavaScriptNameMapperKt;
import com.intellij.javascript.debugger.NameMapper;
import com.intellij.javascript.debugger.NameMapperKt;
import com.intellij.javascript.debugger.SegmentList;
import com.intellij.javascript.debugger.scripts.ScriptsKt;
import com.intellij.javascript.debugger.sourcemap.SourceEntriesProcessor;
import com.intellij.javascript.debugger.sourcemap.SourceMapHelperKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Function;
import com.intellij.util.Url;
import com.intellij.util.containers.MultiMap;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.PromiseDebuggerEvaluator;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeType;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.MappingsProcessorInLine;
import org.jetbrains.debugger.sourcemap.SourceFileResolver;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceMapDecoderKt;
import org.jetbrains.debugger.values.ObjectValue;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J4\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J8\u0010\u0017\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J0\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J \u0010(\u001a\u0004\u0018\u00010\u001d2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006)"}, d2={"Lcom/intellij/javascript/debugger/ChromeEvaluator;", "Lorg/jetbrains/debugger/PromiseDebuggerEvaluator;", "Lcom/intellij/javascript/debugger/ExpressionInfoFactory;", "context", "Lorg/jetbrains/debugger/VariableContext;", "(Lorg/jetbrains/debugger/VariableContext;)V", "create", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/xdebugger/evaluation/ExpressionInfo;", "element", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "createNameMapper", "Lcom/intellij/javascript/debugger/NameMapper;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "evaluate", "Lorg/jetbrains/debugger/EvaluateResult;", "expression", "", "expressionPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "getEvaluationInfoBySourceMap", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "vm", "Lorg/jetbrains/debugger/Vm;", "script", "Lorg/jetbrains/debugger/Script;", "mappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "getExpressionInfoAtOffsetAsync", "project", "Lcom/intellij/openapi/project/Project;", "offset", "", "sideEffectsAllowed", "", "getPreferredScript", "intellij.javascript.debugger"})
public class ChromeEvaluator
extends PromiseDebuggerEvaluator
implements ExpressionInfoFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Promise<ExpressionInfo> getExpressionInfoAtOffsetAsync(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        JavaScriptDebugProcess<?> debugProcess = JavaScriptDebuggerViewSupportKt.getDebugProcess(this.getContext());
        if (!debugProcess.checkCanPerformCommands()) {
            return Promises.resolvedPromise();
        }
        GlobalEvaluator evaluator = debugProcess.getGlobalEvaluator();
        if (evaluator.isDocumentForEvaluation(document)) {
            SegmentList.SegmentListWithData<Pair<String, ObjectValue>> segmentListWithData = evaluator.getValues();
            synchronized (segmentListWithData) {
                int rangeIndex;
                block9: {
                    rangeIndex = evaluator.getValues().getRangeIndex(offset);
                    if (rangeIndex != -1) break block9;
                    Promise promise2 = Promises.resolvedPromise();
                    return promise2;
                }
                Promise promise3 = Promises.resolvedPromise((Object)new ExpressionInfo(evaluator.getValues().createRange(rangeIndex), (String)evaluator.getValues().getValueByIndex(rangeIndex).getFirst()));
                return promise3;
            }
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return Promises.resolvedPromise();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"PsiDocumentManager.getIn\u2026 return resolvedPromise()");
        PsiFile file = psiFile;
        for (JavaScriptDebugAware debugAware : (JavaScriptDebugAware[])JavaScriptDebugAware.Companion.getEP_NAME().getExtensions()) {
            Promise promise4;
            PsiElement element;
            if (!debugAware.canGetEvaluationInfo(file)) continue;
            if (file.findElementAt(offset) == null) {
                return Promises.resolvedPromise();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"file.findElementAt(offse\u2026 return resolvedPromise()");
            Promise promise5 = debugAware.getEvaluationInfo(element, document, (ExpressionInfoFactory)this);
            if (promise5 == null) continue;
            Promise it = promise4 = promise5;
            return it;
        }
        return Promises.resolvedPromise((Object)JSDebuggerSupportUtils.getExpressionAtOffset((Document)document, (PsiFile)file, (int)offset));
    }

    @NotNull
    public Promise<ExpressionInfo> create(@NotNull PsiElement element, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        JavaScriptDebugProcess<?> javaScriptDebugProcess = JavaScriptDebuggerViewSupportKt.getDebugProcess(this.getContext());
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"element.containingFile");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        Promise promise2 = this.getEvaluationInfoBySourceMap(element, document, javaScriptDebugProcess, virtualFile).then(new Function<T, SUB_RESULT>(element){
            final /* synthetic */ PsiElement $element;

            @NotNull
            public final ExpressionInfo fun(@Nullable ExpressionInfo it) {
                ExpressionInfo expressionInfo = it;
                if (expressionInfo == null) {
                    expressionInfo = new ExpressionInfo(this.$element.getTextRange());
                }
                return expressionInfo;
            }
            {
                this.$element = psiElement;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"getEvaluationInfoBySourc\u2026Info(element.textRange) }");
        return promise2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public NameMapper createNameMapper(@NotNull VirtualFile file, @NotNull Document document) {
        void result2;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        JavaScriptDebugProcess<?> debugProcess = JavaScriptDebuggerViewSupportKt.getDebugProcess(this.getContext());
        List<Url> urls = debugProcess.getFinder().getRemoteUrls(file);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        XDebugSession xDebugSession = debugProcess.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
        Project project = xDebugSession.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
        Lazy<SourceFileResolver> resolver = SourceMapHelperKt.createResolver(project, file);
        Function1 processor2 = (Function1)new Function1<Script, Boolean>(urls, file, resolver, (Ref.ObjectRef)result2, debugProcess, document){
            final /* synthetic */ List $urls;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Lazy $resolver;
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ JavaScriptDebugProcess $debugProcess;
            final /* synthetic */ Document $document;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull Script script) {
                JavaScriptNameMapper javaScriptNameMapper;
                SourceMap sourceMap;
                SourceMap map;
                Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
                SourceMap sourceMap2 = map = script.getSourceMap();
                SourceMap sourceMap3 = sourceMap2;
                if (sourceMap2 == null) return true;
                Mappings mappings = sourceMap3.findSourceMappings(this.$urls, this.$file, this.$resolver, false);
                sourceMap3 = mappings;
                if (mappings == null) return true;
                SourceMap mappingList = sourceMap = sourceMap3;
                Ref.ObjectRef objectRef = this.$result;
                VirtualFile virtualFile = JavaScriptDebugProcess.findFile$default(this.$debugProcess, script.getUrl(), false, null, 6, null);
                if (virtualFile != null) {
                    JavaScriptNameMapper javaScriptNameMapper2;
                    VirtualFile virtualFile2 = virtualFile;
                    Ref.ObjectRef objectRef2 = objectRef;
                    VirtualFile file = virtualFile2;
                    Document document = FileDocumentManager.getInstance().getDocument(file);
                    if (document != null) {
                        Document document2;
                        Document it;
                        Document document3 = it = (document2 = document);
                        Intrinsics.checkExpressionValueIsNotNull((Object)document3, (String)"it");
                        javaScriptNameMapper2 = new JavaScriptNameMapper(this.$document, document3, (Mappings)mappingList, map, file);
                    } else {
                        javaScriptNameMapper2 = null;
                    }
                    JavaScriptNameMapper javaScriptNameMapper3 = javaScriptNameMapper2;
                    objectRef = objectRef2;
                    javaScriptNameMapper = javaScriptNameMapper3;
                } else {
                    javaScriptNameMapper = null;
                }
                objectRef.element = javaScriptNameMapper;
                if (!false) return false;
                return true;
            }
            {
                this.$urls = list;
                this.$file = virtualFile;
                this.$resolver = lazy;
                this.$result = objectRef;
                this.$debugProcess = javaScriptDebugProcess;
                this.$document = document;
                super(1);
            }
        };
        Script preferredScript = this.getPreferredScript(debugProcess, file);
        if (preferredScript == null) {
            Vm vm = debugProcess.getActiveOrMainVm();
            if (vm != null && (vm = vm.getScriptManager()) != null) {
                vm.forEachScript(processor2);
            }
        } else {
            processor2.invoke((Object)preferredScript);
        }
        return (NameMapper)result2.element;
    }

    private final Promise<ExpressionInfo> getEvaluationInfoBySourceMap(PsiElement element, Document document, JavaScriptDebugProcess<?> debugProcess, VirtualFile file) {
        Iterator iterator;
        int elementOffset = element.getTextOffset();
        int line = document.getLineNumber(elementOffset);
        int elementColumn = elementOffset - document.getLineStartOffset(line);
        int elementEndColumn = elementColumn + element.getTextLength() - 1;
        MultiMap multiMap = MultiMap.createLinked();
        Intrinsics.checkExpressionValueIsNotNull((Object)multiMap, (String)"MultiMap.createLinked<Any, MappingEntry>()");
        MultiMap scriptToMappings = multiMap;
        Script preferredScript = this.getPreferredScript(debugProcess, file);
        SourceEntriesProcessor processor2 = new SourceEntriesProcessor(elementColumn, elementEndColumn, scriptToMappings){
            final /* synthetic */ int $elementColumn;
            final /* synthetic */ int $elementEndColumn;
            final /* synthetic */ MultiMap $scriptToMappings;

            public boolean process(@NotNull MappingEntry entry, @Nullable MappingEntry nextEntry) {
                int n;
                boolean isSuitable;
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                int entryColumn = entry.getSourceColumn();
                boolean bl = nextEntry == null || entryColumn == 0 && nextEntry.getSourceColumn() == 0 ? entryColumn <= this.$elementColumn : (isSuitable = this.$elementColumn <= (n = entryColumn) && this.$elementEndColumn >= n);
                if (isSuitable) {
                    Script script = this.getScript();
                    if (script == null) {
                        script = this.getScriptUrl();
                    }
                    this.$scriptToMappings.putValue((Object)script, (Object)entry);
                }
                return true;
            }
            {
                this.$elementColumn = $captured_local_variable$0;
                this.$elementEndColumn = $captured_local_variable$1;
                this.$scriptToMappings = $captured_local_variable$2;
            }
        };
        List<Url> sourceUrls = debugProcess.getFinder().getRemoteUrls(file);
        Script script = preferredScript;
        if ((script != null ? script.getSourceMap() : null) == null) {
            SourceMapHelperKt.processMappingsInLine(debugProcess, debugProcess.getActiveOrMainVm(), sourceUrls, file, line, processor2);
        } else {
            processor2.setScriptUrl(preferredScript.getUrl());
            SourceMap sourceMap = preferredScript.getSourceMap();
            if (sourceMap == null) {
                Intrinsics.throwNpe();
            }
            MappingsProcessorInLine mappingsProcessorInLine = processor2;
            XDebugSession xDebugSession = debugProcess.getSession();
            Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
            Project project = xDebugSession.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
            sourceMap.processSourceMappingsInLine(sourceUrls, line, mappingsProcessorInLine, file, SourceMapHelperKt.createResolver(project, file), false);
            processor2.setScriptUrl(null);
        }
        if (scriptToMappings.isEmpty()) {
            return Promises.resolvedPromise();
        }
        Iterator iterator2 = iterator = scriptToMappings.entrySet().iterator();
        while (iterator2.hasNext()) {
            Vm vm;
            Script script2;
            Object k;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator2.next();
            Object key = entry2.getKey();
            entry2 = entry;
            Collection value = (Collection)entry2.getValue();
            if (debugProcess.getActiveOrMainVm() == null) {
                Intrinsics.throwNpe();
            }
            if (!((k = key) instanceof Script)) {
                k = null;
            }
            if ((script2 = (Script)k) == null) {
                Object k2 = key;
                if (k2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.Url");
                }
                script2 = vm.getScriptManager().findScriptByUrl((Url)k2);
            }
            if (script2 == null) {
                continue;
            }
            Script script3 = script2;
            Collection collection = value;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<org.jetbrains.debugger.sourcemap.MappingEntry>");
            }
            Promise<ExpressionInfo> expressionInfo = this.getEvaluationInfoBySourceMap(vm, element, script3, TypeIntrinsics.asMutableList((Object)collection));
            if (expressionInfo == null) continue;
            return expressionInfo;
        }
        return Promises.resolvedPromise();
    }

    private final Script getPreferredScript(JavaScriptDebugProcess<?> debugProcess, VirtualFile file) {
        XDebugSession xDebugSession = debugProcess.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
        CallFrameView topFrameView = (CallFrameView)xDebugSession.getCurrentStackFrame();
        if (topFrameView != null) {
            SourceInfo topFrameSourceInfo;
            SourceInfo sourceInfo = topFrameSourceInfo = topFrameView.getSourcePosition();
            if (Intrinsics.areEqual((Object)(sourceInfo != null ? sourceInfo.getFile() : null), (Object)file)) {
                return topFrameView.getScript();
            }
        }
        return null;
    }

    private final Promise<ExpressionInfo> getEvaluationInfoBySourceMap(Vm vm, PsiElement element, Script script, List<MappingEntry> mappings) {
        boolean isNamedElement = element.getParent() instanceof PsiNamedElement;
        if (mappings.size() > 1 && isNamedElement) {
            NameMapperKt.warnSeveralMapping((PsiElement)element);
            return null;
        }
        CollectionsKt.sortWith(mappings, (Comparator)SourceMapDecoderKt.getMAPPING_COMPARATOR_BY_GENERATED_POSITION());
        Function1<Document, ExpressionInfo> getEvaluationInfo$ = new Function1<Document, ExpressionInfo>(script, mappings, isNamedElement, element){
            final /* synthetic */ Script $script;
            final /* synthetic */ List $mappings;
            final /* synthetic */ boolean $isNamedElement;
            final /* synthetic */ PsiElement $element;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ExpressionInfo invoke(@NotNull Document rawDocument) {
                Intrinsics.checkParameterIsNotNull((Object)rawDocument, (String)"rawDocument");
                SourceMap sourceMap = this.$script.getSourceMap();
                if (sourceMap == null) {
                    Intrinsics.throwNpe();
                }
                SourceMap sourceMap2 = sourceMap;
                CharSequence charSequence = rawDocument.getImmutableCharSequence();
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"rawDocument.immutableCharSequence");
                CharSequence charSequence2 = charSequence;
                StringBuilder expressionBuilder = null;
                CharSequence result2 = null;
                int n = 0;
                int n2 = this.$mappings.size();
                while (n < n2) {
                    void i;
                    MappingEntry mapping = (MappingEntry)this.$mappings.get((int)i);
                    MappingEntry mappingEntry = (MappingEntry)CollectionsKt.getOrNull((List)this.$mappings, (int)(i + true));
                    if (mappingEntry == null) {
                        mappingEntry = sourceMap2.getGeneratedMappings().getNextOnTheSameLine(mapping);
                    }
                    MappingEntry nextMapping = mappingEntry;
                    int generatedLineStartOffset = rawDocument.getLineStartOffset(mapping.getGeneratedLine());
                    int start = generatedLineStartOffset + mapping.getGeneratedColumn();
                    Function1<MappingEntry, Integer> computeEnd$ = new Function1<MappingEntry, Integer>(mapping, rawDocument, generatedLineStartOffset){
                        final /* synthetic */ MappingEntry $mapping;
                        final /* synthetic */ Document $rawDocument;
                        final /* synthetic */ int $generatedLineStartOffset;

                        public final int invoke(@Nullable MappingEntry nextMapping) {
                            return nextMapping == null || nextMapping.getGeneratedLine() != this.$mapping.getGeneratedLine() ? this.$rawDocument.getLineEndOffset(this.$mapping.getGeneratedLine()) : this.$generatedLineStartOffset + nextMapping.getGeneratedColumn();
                        }
                        {
                            this.$mapping = mappingEntry;
                            this.$rawDocument = document;
                            this.$generatedLineStartOffset = n;
                            super(1);
                        }
                    };
                    int end = computeEnd$.invoke(nextMapping);
                    if (nextMapping != null) {
                        if (start > end) {
                            JavaScriptDebugProcessKt.getLOG().assertTrue(nextMapping.getGeneratedColumn() >= mapping.getGeneratedColumn());
                        } else if (this.$isNamedElement && start == end) {
                            MappingEntry m = nextMapping;
                            while (start == (end = computeEnd$.invoke(m = sourceMap2.getGeneratedMappings().getNext(m))) && m != null) {
                            }
                        }
                    }
                    CharSequence name = charSequence2.subSequence(start, end);
                    if (this.$isNamedElement) {
                        result2 = JavaScriptNameMapperKt.doExtractName(name, this.$element);
                        break;
                    }
                    if (expressionBuilder == null) {
                        expressionBuilder = new StringBuilder();
                        result2 = expressionBuilder;
                    }
                    if (name.length() == 1 && name.charAt(0) == '.') {
                        expressionBuilder.append('.');
                    } else {
                        expressionBuilder.append(NameMapper.Companion.trimName(name, i + true == this.$mappings.size()));
                    }
                    ++i;
                }
                CharSequence charSequence3 = result2;
                return new ExpressionInfo(this.$element.getTextRange(), charSequence3 != null ? ((Object)charSequence3).toString() : null, null);
            }
            {
                this.$script = script;
                this.$mappings = list;
                this.$isNamedElement = bl;
                this.$element = psiElement;
                super(1);
            }
        };
        return ScriptsKt.getResolvedFile(script, vm).then(new Function<T, SUB_RESULT>(getEvaluationInfo$){
            final /* synthetic */ getEvaluationInfoBySourceMap.1 $getEvaluationInfo$1;

            @NotNull
            public final ExpressionInfo fun(VirtualFile it) {
                VirtualFile virtualFile = it;
                if (virtualFile == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.testFramework.LightVirtualFile");
                }
                return this.$getEvaluationInfo$1.invoke((Document)new DocumentImpl(((LightVirtualFile)virtualFile).getContent(), true));
            }
            {
                this.$getEvaluationInfo$1 = var1_1;
            }
        });
    }

    @NotNull
    protected Promise<EvaluateResult> evaluate(@NotNull String expression, @Nullable XSourcePosition expressionPosition) {
        Promise promise2;
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        Promise promise3 = null;
        if (this.getContext() instanceof CallFrameView) {
            for (Scope scope : ((CallFrameView)this.getContext()).getCallFrame().getVariableScopes()) {
                if (scope.getType() != ScopeType.LOCAL) continue;
                promise3 = ((CallFrameView)this.getContext()).getMemberFilter(scope).thenAsync(new Function<T, Promise<SUB_RESULT>>(this, expression){
                    final /* synthetic */ ChromeEvaluator this$0;
                    final /* synthetic */ String $expression;

                    @NotNull
                    public final Promise<EvaluateResult> fun(MemberFilter it) {
                        EvaluateContext evaluateContext = ChromeEvaluator.access$getContext$p(this.this$0).getEvaluateContext();
                        String string = it.sourceNameToRaw(this.$expression);
                        if (string == null) {
                            string = this.$expression;
                        }
                        XDebugSession xDebugSession = JavaScriptDebuggerViewSupportKt.getDebugProcess(ChromeEvaluator.access$getContext$p(this.this$0)).getSession();
                        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"getDebugProcess(context).session");
                        return EvaluateContext.DefaultImpls.evaluate$default((EvaluateContext)evaluateContext, (String)string, null, (boolean)false, (Project)xDebugSession.getProject(), (int)6, null);
                    }
                    {
                        this.this$0 = chromeEvaluator;
                        this.$expression = string;
                    }
                });
                break;
            }
            if (((CallFrameView)this.getContext()).getCallFrame().isFromAsyncStack()) {
                return Promises.rejectedPromise((String)"Can't be evaluated in async context");
            }
        }
        if ((promise2 = promise3) == null) {
            EvaluateContext evaluateContext = this.getContext().getEvaluateContext();
            XDebugSession xDebugSession = JavaScriptDebuggerViewSupportKt.getDebugProcess(this.getContext()).getSession();
            Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"getDebugProcess(context).session");
            promise2 = EvaluateContext.DefaultImpls.evaluate$default((EvaluateContext)evaluateContext, (String)expression, null, (boolean)false, (Project)xDebugSession.getProject(), (int)6, null);
        }
        Promise promise4 = promise2.thenAsync((Function)evaluate.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)promise4, (String)"(promise ?:  context.eva\u2026solvedPromise(it)\n      }");
        return promise4;
    }

    public ChromeEvaluator(@NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
    }

    @NotNull
    public static final /* synthetic */ VariableContext access$getContext$p(ChromeEvaluator $this) {
        return $this.getContext();
    }
}

