/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpspec;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.phpspec.PhpSpecBundle;
import com.jetbrains.php.phpspec.PhpSpecSettingsManager;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.ui.PhpTestAdditionalInfoComponent;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkBaseConfigurableForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

public class PhpSpecInfoComponent
implements PhpTestAdditionalInfoComponent {
    private static final String DEFAULT_PREFIX = "spec";
    private static final List<String> DEFAULT_PREFIXES = ContainerUtil.immutableList((Object[])new String[]{"spec"});
    private final JPanel myComponent;
    private final JBLabel myPrefixList;
    private final Project myProject;
    private List<String> myPrefixes;

    public PhpSpecInfoComponent(final @NotNull Project project, @NotNull PhpTestFrameworkBaseConfigurableForm form) {
        if (project == null) {
            PhpSpecInfoComponent.$$$reportNull$$$0(0);
        }
        if (form == null) {
            PhpSpecInfoComponent.$$$reportNull$$$0(1);
        }
        this.myPrefixes = DEFAULT_PREFIXES;
        this.myProject = project;
        this.myComponent = new JPanel(new BorderLayout());
        JBLabel prefixLabel = new JBLabel(PhpSpecBundle.message("php.phpspec.config.prefix.label", new Object[0]));
        prefixLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)0, (int)0));
        this.myPrefixList = new JBLabel(DEFAULT_PREFIX);
        this.myPrefixList.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)0, (int)0));
        this.myComponent.add((Component)prefixLabel, "West");
        this.myComponent.add((Component)this.myPrefixList, "Center");
        form.addConfigurationPathListener(new PhpTestFrameworkBaseConfigurableForm.PhpFilePathUpdateListener(){

            public void onFileUpdated(@NotNull String path) {
                if (path == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpSpecInfoComponent.this.updatePrefixes(project, path);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/php/phpspec/PhpSpecInfoComponent$1", "onFileUpdated"));
            }
        });
    }

    private void updatePrefixes(@NotNull Project project, @NotNull String newPath) {
        if (project == null) {
            PhpSpecInfoComponent.$$$reportNull$$$0(2);
        }
        if (newPath == null) {
            PhpSpecInfoComponent.$$$reportNull$$$0(3);
        }
        if (StringUtil.isNotEmpty((String)newPath)) {
            List<String> newPrefixes = PhpSpecInfoComponent.getSpecPrefix(project, newPath);
            if (!this.myPrefixes.equals(newPrefixes)) {
                this.updatePrefixes(newPrefixes);
            }
        } else {
            this.updatePrefixes(DEFAULT_PREFIXES);
        }
    }

    private void updatePrefixes(@NotNull List<String> newPrefixes) {
        if (newPrefixes == null) {
            PhpSpecInfoComponent.$$$reportNull$$$0(4);
        }
        this.myPrefixes = newPrefixes;
        this.myPrefixList.setText(StringUtil.join(newPrefixes, (String)", "));
    }

    @NotNull
    private static List<String> getSpecPrefix(@NotNull Project project, @Nullable String path) {
        PsiFile file;
        if (project == null) {
            PhpSpecInfoComponent.$$$reportNull$$$0(5);
        }
        if ((file = PhpRunUtil.findPsiFile((Project)project, (String)path)) != null && file.getFileType() == YAMLFileType.YML) {
            HashSet<String> prefixes = new HashSet<String>();
            for (YAMLKeyValue keyValue : YAMLUtil.getTopLevelKeys((YAMLFile)((YAMLFile)file))) {
                YAMLValue suites;
                if (!"suites".equals(keyValue.getKeyText()) || !((suites = keyValue.getValue()) instanceof YAMLMapping)) continue;
                for (YAMLKeyValue suite : ((YAMLMapping)suites).getKeyValues()) {
                    YAMLValue value = suite.getValue();
                    if (!(value instanceof YAMLMapping)) continue;
                    YAMLKeyValue prefix = ((YAMLMapping)value).getKeyValueByKey("spec_prefix");
                    prefixes.add(prefix == null || StringUtil.isEmpty((String)prefix.getValueText()) ? DEFAULT_PREFIX : prefix.getValueText());
                }
            }
            if (!prefixes.isEmpty()) {
                ArrayList result = ContainerUtil.newArrayList(prefixes);
                ContainerUtil.sort((List)result);
                ArrayList arrayList = result;
                if (arrayList == null) {
                    PhpSpecInfoComponent.$$$reportNull$$$0(6);
                }
                return arrayList;
            }
        }
        List<String> list = DEFAULT_PREFIXES;
        if (list == null) {
            PhpSpecInfoComponent.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            PhpSpecInfoComponent.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    public void apply(@NotNull PhpTestFrameworkConfiguration state) {
        if (state == null) {
            PhpSpecInfoComponent.$$$reportNull$$$0(9);
        }
        PhpSpecSettingsManager.getInstance(this.myProject).setPrefixes(this.myPrefixes);
    }

    public void reset(@NotNull PhpTestFrameworkConfiguration state) {
        if (state == null) {
            PhpSpecInfoComponent.$$$reportNull$$$0(10);
        }
        this.updatePrefixes(PhpSpecSettingsManager.getInstance(this.myProject).getPrefixes());
    }

    public boolean isModified(@NotNull PhpTestFrameworkConfiguration state) {
        if (state == null) {
            PhpSpecInfoComponent.$$$reportNull$$$0(11);
        }
        return !this.myPrefixes.equals(PhpSpecSettingsManager.getInstance(this.myProject).getPrefixes());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "form";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPrefixes";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpspec/PhpSpecInfoComponent";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpspec/PhpSpecInfoComponent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecPrefix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updatePrefixes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSpecPrefix";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

