/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.smarty.lang;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.smarty.SmartyFileReferenceSet;
import com.jetbrains.smarty.lang.SmartyTokenTypes;
import com.jetbrains.smarty.lang.psi.SmartyAttribute;
import com.jetbrains.smarty.lang.psi.SmartyTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartyIncludeTag
extends SmartyTag {
    private static final String ourTagName = "include";

    public SmartyIncludeTag(@NotNull ASTNode node) {
        if (node == null) {
            SmartyIncludeTag.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        if (ourTagName == null) {
            SmartyIncludeTag.$$$reportNull$$$0(1);
        }
        return ourTagName;
    }

    private static boolean checkType(PsiElement element, IElementType type) {
        if (element == null) {
            return false;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        return node.getElementType() == type;
    }

    @Nullable
    private static PsiElement getStringLiteral(PsiElement element) {
        PsiElement firstChild = element.getFirstChild();
        if (!SmartyIncludeTag.checkType(firstChild, SmartyTokenTypes.DOUBLE_QUOTE) && !SmartyIncludeTag.checkType(firstChild, SmartyTokenTypes.SINGLE_QUOTE)) {
            return null;
        }
        PsiElement nextSibling = firstChild.getNextSibling();
        if (!SmartyIncludeTag.checkType(nextSibling, SmartyTokenTypes.STRING_LITERAL)) {
            return null;
        }
        PsiElement nextSibling1 = nextSibling.getNextSibling();
        if (!SmartyIncludeTag.checkType(nextSibling1, SmartyTokenTypes.DOUBLE_QUOTE) && !SmartyIncludeTag.checkType(nextSibling1, SmartyTokenTypes.SINGLE_QUOTE)) {
            return null;
        }
        if (nextSibling1.getNextSibling() == null) {
            return nextSibling;
        }
        return null;
    }

    @Nullable
    private PsiElement getNameElement() {
        PsiElement fileName = this.getAttributeValue("file");
        if (fileName == null) {
            for (PsiElement child : this.getChildren()) {
                if (child instanceof PsiWhiteSpace) continue;
                if (!(child instanceof SmartyAttribute) || !StringUtil.isEmpty((String)((SmartyAttribute)child).getName())) break;
                return SmartyIncludeTag.getStringLiteral(child);
            }
            return null;
        }
        return SmartyIncludeTag.getStringLiteral(fileName);
    }

    @NotNull
    public String getFileName() {
        PsiElement nameElement = this.getNameElement();
        if (nameElement != null) {
            String string = nameElement.getText();
            if (string == null) {
                SmartyIncludeTag.$$$reportNull$$$0(2);
            }
            return string;
        }
        if ("" == null) {
            SmartyIncludeTag.$$$reportNull$$$0(3);
        }
        return "";
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement nameElement = this.getNameElement();
        Object object = nameElement != null ? nameElement : this;
        if (object == null) {
            SmartyIncludeTag.$$$reportNull$$$0(4);
        }
        return object;
    }

    @NotNull
    public PsiReference[] getReferences() {
        if (!StringUtil.isEmpty((String)this.getFileName())) {
            FileReference[] fileReferenceArray = new SmartyFileReferenceSet(this, null).getAllReferences();
            if (fileReferenceArray == null) {
                SmartyIncludeTag.$$$reportNull$$$0(5);
            }
            return fileReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            SmartyIncludeTag.$$$reportNull$$$0(6);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public int getTextOffset() {
        PsiElement element = this.getNavigationElement();
        return element.getTextRange().getStartOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/smarty/lang/SmartyIncludeTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/smarty/lang/SmartyIncludeTag";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

