/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractMethod;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.PhpParameterTemplate;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExtractMethodParameterInfo
implements PhpParameterTemplate {
    private final ParameterType myParameterType;
    private final CharSequence myName;
    private CharSequence myTypeText;
    protected CharSequence myNewName;
    protected CharSequence myInitializer;
    private String myParameterText;
    private boolean myPassByRef;
    private boolean myIsReturnByRefMode;

    PhpExtractMethodParameterInfo(@NotNull ParameterType parameterType, @NotNull CharSequence type, @NotNull CharSequence name, boolean isPassByRef) {
        if (parameterType == null) {
            PhpExtractMethodParameterInfo.$$$reportNull$$$0(0);
        }
        if (type == null) {
            PhpExtractMethodParameterInfo.$$$reportNull$$$0(1);
        }
        if (name == null) {
            PhpExtractMethodParameterInfo.$$$reportNull$$$0(2);
        }
        this.myIsReturnByRefMode = false;
        this.myParameterType = parameterType;
        this.myTypeText = type;
        this.myName = name;
        this.myNewName = name;
        this.myPassByRef = isPassByRef;
        this.myInitializer = "";
        this.myParameterText = this.buildParameterText();
    }

    public PhpExtractMethodParameterInfo(@NotNull ParameterType parameterType, @NotNull CharSequence type, @NotNull CharSequence name, @NotNull CharSequence newName, @NotNull CharSequence initializer, boolean passByRef) {
        if (parameterType == null) {
            PhpExtractMethodParameterInfo.$$$reportNull$$$0(3);
        }
        if (type == null) {
            PhpExtractMethodParameterInfo.$$$reportNull$$$0(4);
        }
        if (name == null) {
            PhpExtractMethodParameterInfo.$$$reportNull$$$0(5);
        }
        if (newName == null) {
            PhpExtractMethodParameterInfo.$$$reportNull$$$0(6);
        }
        if (initializer == null) {
            PhpExtractMethodParameterInfo.$$$reportNull$$$0(7);
        }
        this.myIsReturnByRefMode = false;
        this.myParameterType = parameterType;
        this.myName = name;
        this.myTypeText = type;
        this.myNewName = newName;
        this.myInitializer = initializer;
        this.myPassByRef = passByRef;
        this.myParameterText = this.buildParameterText();
    }

    private String buildParameterText() {
        return PhpFunctionCodeGenerator.generateParameter(this, this.myNewName);
    }

    public CharSequence getNewName() {
        return this.myNewName;
    }

    @Override
    @NotNull
    public CharSequence getTypeText() {
        CharSequence charSequence = this.myTypeText;
        if (charSequence == null) {
            PhpExtractMethodParameterInfo.$$$reportNull$$$0(8);
        }
        return charSequence;
    }

    @Override
    @Nullable
    public CharSequence getInitializer() {
        return this.myInitializer;
    }

    @Override
    @NotNull
    public CharSequence getName() {
        CharSequence charSequence = this.myName;
        if (charSequence == null) {
            PhpExtractMethodParameterInfo.$$$reportNull$$$0(9);
        }
        return charSequence;
    }

    public boolean isEnabled(boolean isReturnByRef) {
        return isReturnByRef || this.myParameterType != ParameterType.RETURN_BY_REF;
    }

    @Override
    public boolean isPassByRef() {
        return this.myParameterType == ParameterType.NOT_FOR_RETURN ? this.myPassByRef : this.myParameterType != ParameterType.RETURN_BY_REF_OR_VALUE || this.myIsReturnByRefMode || this.myPassByRef;
    }

    @Override
    public boolean isVariadic() {
        return false;
    }

    public void setParameterText(@NotNull String parameterText) {
        if (parameterText == null) {
            PhpExtractMethodParameterInfo.$$$reportNull$$$0(10);
        }
        this.myParameterText = parameterText.trim();
    }

    public boolean nameWasChanged() {
        return !StringUtil.equals((CharSequence)this.myNewName, (CharSequence)this.myName);
    }

    @Override
    public void updateParameter(@NotNull Parameter parameter) {
        if (parameter == null) {
            PhpExtractMethodParameterInfo.$$$reportNull$$$0(11);
        }
        this.updateParameter(parameter, true);
    }

    public void updateParameter(@NotNull Parameter parameter, boolean updatePassByRef) {
        PsiElement initializer;
        if (parameter == null) {
            PhpExtractMethodParameterInfo.$$$reportNull$$$0(12);
        }
        this.myNewName = parameter.getName();
        this.myTypeText = PhpRefactoringUtil.getParameterTypeDeclarationString(parameter);
        if (updatePassByRef) {
            this.myPassByRef = parameter.isPassByRef();
        }
        this.myInitializer = (initializer = parameter.getDefaultValue()) == null ? "" : initializer.getText();
        this.myParameterText = this.buildParameterText();
    }

    @Override
    @NotNull
    public String getParameterPreviewText() {
        String string = this.myParameterText;
        if (string == null) {
            PhpExtractMethodParameterInfo.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @Nullable
    public String getDefaultValue() {
        return null;
    }

    @Override
    public boolean shouldBeInitialized() {
        return false;
    }

    public void setIsReturnByRefMode(@NotNull Project project, boolean isReturnByRefMode) {
        if (project == null) {
            PhpExtractMethodParameterInfo.$$$reportNull$$$0(14);
        }
        Parameter parameter = PhpExtractMethodParameterInfo.constructParameter(project, this.myParameterText);
        boolean updatePassByRef = this.myParameterType != ParameterType.RETURN_BY_REF_OR_VALUE || !this.myIsReturnByRefMode;
        this.myIsReturnByRefMode = isReturnByRefMode;
        if (parameter != null) {
            this.updateParameter(parameter, updatePassByRef);
        }
    }

    @Nullable
    private static Parameter constructParameter(@NotNull Project project, @NotNull String parameter) {
        if (project == null) {
            PhpExtractMethodParameterInfo.$$$reportNull$$$0(15);
        }
        if (parameter == null) {
            PhpExtractMethodParameterInfo.$$$reportNull$$$0(16);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("function foo(");
        builder.append(parameter);
        builder.append("){}");
        return PhpPsiElementFactory.createFromText(project, Parameter.class, builder.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodParameterInfo";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterText";
                break;
            }
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodParameterInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterPreviewText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setParameterText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateParameter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setIsReturnByRefMode";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "constructParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum ParameterType {
        RETURN_BY_REF_OR_VALUE,
        RETURN_BY_REF,
        NOT_FOR_RETURN;

    }
}

