/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phar;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.jetbrains.php.phar.PharFileSystem;
import com.jetbrains.php.phar.PharFileType;
import org.jetbrains.annotations.NotNull;

public class PharSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public PharSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters parameters, @NotNull Processor<? super PsiReference> consumer) {
        if (parameters == null) {
            PharSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PharSearcher.$$$reportNull$$$0(1);
        }
        PsiElement search = parameters.getElementToSearch();
        PharSearcher.patchRealPharUsagesText(parameters, search);
        PharSearcher.patchLocalPharUsages(parameters, search);
    }

    private static void patchLocalPharUsages(ReferencesSearch.SearchParameters parameters, PsiElement search) {
        PsiDirectory realPharPsi;
        VirtualFile realPhar;
        VirtualFile file;
        if (search instanceof PsiFile && (file = ((PsiFile)search).getVirtualFile()) != null && file.getFileSystem() == LocalFileSystem.getInstance() && PharFileType.isPhar(file) && (realPhar = PharFileSystem.getInstance().findFileByPath(file.getPath())) != null && (realPharPsi = search.getManager().findDirectory(realPhar)) != null) {
            parameters.getOptimizer().searchWord(file.getName(), parameters.getEffectiveSearchScope(), (short)255, false, (PsiElement)realPharPsi);
        }
    }

    private static void patchRealPharUsagesText(ReferencesSearch.SearchParameters parameters, PsiElement search) {
        VirtualFile file;
        if (search instanceof PsiDirectory && "phar".equals((file = ((PsiDirectory)search).getVirtualFile()).getFileSystem().getProtocol())) {
            String text = FileUtil.toSystemIndependentName((String)file.getName());
            int slashIndex = text.lastIndexOf("/");
            if (slashIndex != -1) {
                text = text.substring(slashIndex + 1);
            }
            parameters.getOptimizer().searchWord(text, parameters.getEffectiveSearchScope(), (short)255, false, search);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/phar/PharSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

