/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.codeInsight.PhpScope;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.PhpScopeImpl;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.stubs.PhpNamespaceStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.roots.PhpNamespaceByPsrProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNamespaceImpl
extends PhpNamedElementImpl<PhpNamespaceStub>
implements PhpNamespace {
    private volatile CachedValue<Collection<PsiDirectory>> myDirectories;
    private PhpScope myScope;

    public PhpNamespaceImpl(ASTNode node) {
        super(node);
    }

    public PhpNamespaceImpl(PhpNamespaceStub stub) {
        super(stub, PhpStubElementTypes.NAMESPACE);
    }

    @Nullable
    public GroupStatement getStatements() {
        return (GroupStatement)PsiTreeUtil.getChildOfType((PsiElement)this, GroupStatement.class);
    }

    @NotNull
    public String getParentNamespaceName() {
        PhpNamespaceStub stub = (PhpNamespaceStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getParentNamespaceName().toString();
            if (string == null) {
                PhpNamespaceImpl.$$$reportNull$$$0(0);
            }
            return string;
        }
        PhpNamespaceReference element = (PhpNamespaceReference)this.findChildByClass(PhpNamespaceReference.class);
        if (element != null) {
            String fullName = element.getFullName();
            String string = fullName != null ? PhpLangUtil.toFQN(fullName) : "\\";
            if (string == null) {
                PhpNamespaceImpl.$$$reportNull$$$0(1);
            }
            return string;
        }
        if ("\\" == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(2);
        }
        return "\\";
    }

    public boolean isBraced() {
        return this.findChildByType(PhpTokenTypes.opSEMICOLON) == null;
    }

    @Override
    @NotNull
    public String getFQN() {
        String string = this.getParentNamespaceName() + this.getName();
        if (string == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getNamespaceName() {
        if ("\\" == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(4);
        }
        return "\\";
    }

    @Override
    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getNamespacePresentation(this);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(5);
        }
        if ((nameNode = this.getNameNode()) != null && !this.getName().equals(name)) {
            ConstantReference constantReference = PhpPsiElementFactory.createConstantReference(this.getProject(), name);
            nameNode.getTreeParent().replaceChild(nameNode, constantReference.getNameNode());
        }
        return this;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor psiElementVisitor) {
        if (psiElementVisitor == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(6);
        }
        if (psiElementVisitor instanceof PhpElementVisitor) {
            ((PhpElementVisitor)psiElementVisitor).visitPhpNamespace((PhpNamespace)this);
        } else {
            super.accept(psiElementVisitor);
        }
    }

    @Override
    public Icon getIcon() {
        return PhpIcons.NAMESPACE;
    }

    @NotNull
    public PhpControlFlow getControlFlow() {
        PhpControlFlow phpControlFlow = this.getScope().getControlFlow();
        if (phpControlFlow == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(7);
        }
        return phpControlFlow;
    }

    @NotNull
    public PhpScope getScope() {
        if (this.myScope == null) {
            this.myScope = new PhpScopeImpl((PhpScopeHolder)this);
        }
        PhpScope phpScope = this.myScope;
        if (phpScope == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(8);
        }
        return phpScope;
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        if (this.myScope != null) {
            this.myScope.clear();
        }
    }

    @NotNull
    public Set<CharSequence> getPredefinedVariables() {
        Set<CharSequence> set = PhpLangUtil.FILE_PREDEFINED_VARIABLES_SET;
        if (set == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    public PsiDirectory[] getDirectories() {
        Collection<PsiDirectory> collection = this.getAllDirectories();
        PsiDirectory[] psiDirectoryArray = collection.toArray(PsiDirectory.EMPTY_ARRAY);
        if (psiDirectoryArray == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(10);
        }
        return psiDirectoryArray;
    }

    @NotNull
    public PsiDirectory[] getDirectories(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(11);
        }
        ArrayList<PsiDirectory> result = null;
        boolean includeLibrarySources = scope.isForceSearchingInLibrarySources();
        Collection<PsiDirectory> directories = this.getAllDirectories(includeLibrarySources);
        for (PsiDirectory directory : directories) {
            if (!scope.contains(directory.getVirtualFile())) continue;
            if (result == null) {
                result = new ArrayList<PsiDirectory>();
            }
            result.add(directory);
        }
        PsiDirectory[] psiDirectoryArray = result == null ? PsiDirectory.EMPTY_ARRAY : result.toArray(PsiDirectory.EMPTY_ARRAY);
        if (psiDirectoryArray == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(12);
        }
        return psiDirectoryArray;
    }

    protected Collection<PsiDirectory> getAllDirectories() {
        return this.getAllDirectories(false);
    }

    private Collection<PsiDirectory> getAllDirectories(boolean b) {
        if (this.myDirectories == null) {
            CachedValueProvider provider = () -> {
                String namespaceName;
                ArrayList<PsiDirectory> directories = new ArrayList<PsiDirectory>();
                PsiDirectory psiDirectory = this.getContainingFile().getParent();
                List<String> namespaces = PhpNamespaceByPsrProvider.INSTANCE.suggestNamespaces(psiDirectory);
                String string = namespaceName = namespaces.size() > 0 ? namespaces.iterator().next() : null;
                if (namespaceName != null && ("\\" + namespaceName).equals(this.getFQN())) {
                    directories.add(psiDirectory);
                }
                return CachedValueProvider.Result.create(directories, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)this.getProject())});
            };
            this.myDirectories = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(provider, false);
        }
        return (Collection)this.myDirectories.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpNamespaceImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementVisitor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentNamespaceName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceName";
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpNamespaceImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlow";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedVariables";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDirectories";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

