/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.MultiassignmentExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FieldReferenceImpl
extends MemberReferenceImpl
implements FieldReference {
    private static final TokenSet NN = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.VARIABLE, PhpTokenTypes.IDENTIFIER});

    public FieldReferenceImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            FieldReferenceImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof PhpElementVisitor) {
            ((PhpElementVisitor)visitor).visitPhpFieldReference((FieldReference)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public ASTNode getNameNode() {
        PsiElement lastChild = this.getLastChild();
        if (lastChild instanceof Variable && (!this.isStatic() || lastChild.getPrevSibling().getNode().getElementType().equals(PhpTokenTypes.DOLLAR))) {
            return null;
        }
        if (lastChild instanceof LeafPsiElement) {
            return NN.contains(lastChild.getNode().getElementType()) ? lastChild.getNode() : null;
        }
        ASTNode node = lastChild.getNode();
        ASTNode out = node.findChildByType(NN);
        if (out != null) {
            return out;
        }
        return TreeUtil.findChildBackward((ASTNode)node, PhpStubElementTypes.VARIABLE);
    }

    @Override
    public String getName() {
        String name = super.getName();
        return name != null && name.length() > 0 && name.charAt(0) == '$' ? name.substring(1) : name;
    }

    @Override
    public CharSequence getNameCS() {
        CharSequence name = super.getNameCS();
        return name != null && name.length() > 0 && name.charAt(0) == '$' ? name.subSequence(1, name.length()) : name;
    }

    public boolean isConstant() {
        CharSequence name = super.getNameCS();
        return name != null && (name.length() == 0 || name.charAt(0) != '$');
    }

    public Set<PhpNamedElement> resolveMember(@NotNull PhpClass klass, boolean localOnly) {
        if (klass == null) {
            FieldReferenceImpl.$$$reportNull$$$0(1);
        }
        return FieldReferenceImpl.resolveMemberImpl(this, klass, localOnly);
    }

    public static Set<PhpNamedElement> resolveMemberImpl(MemberReference reference, @NotNull PhpClass klass, boolean localOnly) {
        if (klass == null) {
            FieldReferenceImpl.$$$reportNull$$$0(2);
        }
        boolean isStatic = !reference.getReferenceType().isDynamic();
        boolean lookForConstant = (reference instanceof ClassConstantReference || reference instanceof FieldReference && ((FieldReference)reference).isConstant()) && isStatic;
        Field field = !localOnly ? klass.findFieldByName(reference.getNameCS(), lookForConstant) : klass.findOwnFieldByName(reference.getNameCS(), lookForConstant);
        if (field != null) {
            if (field.isConstant() != lookForConstant) {
                return Collections.emptySet();
            }
            if (field.getModifier().isStatic() != isStatic) {
                return Collections.emptySet();
            }
            return Collections.singleton(field);
        }
        return Collections.emptySet();
    }

    @Override
    public PsiElement handleElementRename(@NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            FieldReferenceImpl.$$$reportNull$$$0(3);
        }
        if ((nameNode = this.getNameNode()) != null && !name.equals(this.getName())) {
            ASTNode node;
            ASTNode aSTNode = node = nameNode.getElementType() == PhpTokenTypes.IDENTIFIER ? PhpPsiElementFactory.createFieldReferenceUsingThis(this.getProject(), name).getNameNode() : PhpPsiElementFactory.createVariable(this.getProject(), name, true).getNameNode();
            assert (node != null);
            nameNode.getTreeParent().replaceChild(nameNode, node);
        }
        return this;
    }

    public boolean isWriteAccess() {
        FieldReferenceImpl that = this;
        PsiElement parent = this.getParent();
        while (parent instanceof ArrayAccessExpression) {
            that = parent;
            parent = parent.getParent();
        }
        if (parent instanceof MultiassignmentExpressionImpl) {
            return true;
        }
        if (parent instanceof AssignmentExpression) {
            return ((AssignmentExpression)parent).getVariable() == that;
        }
        if (parent instanceof UnaryExpression && (PhpPsiUtil.isOfType(parent, PhpElementTypes.INFIX_WRITE_EXPRESSION) || PhpPsiUtil.isOfType(parent, PhpElementTypes.POSTFIX_EXPRESSION))) {
            return true;
        }
        return PhpCodeInsightUtil.isPassByRefParameter((PsiElement)that, true);
    }

    @Override
    protected PhpTypeSignatureKey getTypeSignatureKey() {
        return PhpTypeSignatureKey.FIELD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/FieldReferenceImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveMember";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveMemberImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "handleElementRename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

