/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.naming;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.ConventionOptionsPanel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.JavaScriptInspection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ConventionInspection
extends JavaScriptInspection {
    public String m_regex = this.getDefaultRegex();
    public int m_minLength = this.getDefaultMinLength();
    public int m_maxLength = this.getDefaultMaxLength();
    protected Pattern m_regexPattern = Pattern.compile(this.m_regex);

    protected abstract String getDefaultRegex();

    protected abstract int getDefaultMinLength();

    protected abstract int getDefaultMaxLength();

    String getRegex() {
        return this.m_regex;
    }

    int getMinLength() {
        return this.m_minLength;
    }

    int getMaxLength() {
        return this.m_maxLength;
    }

    boolean isValid(@NonNls String name) {
        int length = name.length();
        if (length < this.m_minLength) {
            return false;
        }
        if (length > this.m_maxLength) {
            return false;
        }
        Matcher matcher = this.m_regexPattern.matcher(name);
        return matcher.matches();
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            ConventionInspection.$$$reportNull$$$0(0);
        }
        super.readSettings(element);
        this.m_regexPattern = Pattern.compile(this.m_regex);
    }

    public JComponent createOptionsPanel() {
        return new ConventionOptionsPanel((InspectionProfileEntry)this, "m_minLength", "m_maxLength", "m_regex", "m_regexPattern", new JComponent[0]);
    }

    protected boolean isInvalidName(@NotNull PsiNameIdentifierOwner element) {
        PsiElement identifier;
        if (element == null) {
            ConventionInspection.$$$reportNull$$$0(1);
        }
        if ((identifier = element.getNameIdentifier()) == null || !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)identifier, (boolean)true)) {
            return false;
        }
        String name = element.getName();
        if (name == null) {
            return false;
        }
        return !this.isValid(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/sixrr/inspectjs/naming/ConventionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInvalidName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

