/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.systemjs;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.modules.JSBaseModuleReferenceContributor;
import com.intellij.lang.javascript.frameworks.modules.JSMappingReferenceSet;
import com.intellij.lang.javascript.frameworks.modules.JSModuleFileReferenceSet;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.frameworks.systemjs.SystemJSConfig;
import com.intellij.lang.javascript.frameworks.systemjs.SystemJSConfigFinder;
import com.intellij.lang.javascript.frameworks.systemjs.SystemJSPathSubstitution;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemJSReferenceContributor
extends JSBaseModuleReferenceContributor {
    private static final char PLUGIN_SEPARATOR = '!';
    private final SystemJSConfigFinder myFinder = new SystemJSConfigFinder();

    @Override
    @NotNull
    protected PsiReference[] getReferences(@NotNull String unquotedEscapedText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider2, boolean isCommonJS) {
        Collection<SystemJSConfig> configs;
        if (unquotedEscapedText == null) {
            SystemJSReferenceContributor.$$$reportNull$$$0(0);
        }
        if (host == null) {
            SystemJSReferenceContributor.$$$reportNull$$$0(1);
        }
        if ((configs = this.myFinder.getConfigs(host)).isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SystemJSReferenceContributor.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList refs = ContainerUtil.newArrayList();
        for (SystemJSConfig config2 : configs) {
            Collection<PsiReference> references = SystemJSReferenceContributor.createAliasedReferences(config2, unquotedEscapedText, host, offset, provider2);
            if (references.isEmpty()) continue;
            refs.addAll(references);
        }
        if (refs.isEmpty() && unquotedEscapedText.indexOf(33) > 0) {
            String textForProcessing = unquotedEscapedText.substring(0, unquotedEscapedText.indexOf(33));
            ContainerUtil.addAll((Collection)refs, (Object[])new JSModuleFileReferenceSet(textForProcessing, host, offset, provider2, null).getAllReferences());
        }
        PsiReference[] psiReferenceArray = refs.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            SystemJSReferenceContributor.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    private static Collection<PsiReference> createAliasedReferences(@NotNull SystemJSConfig config2, @NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider2) {
        Collection<SystemJSPathSubstitution> mappings;
        Pair<SystemJSPathSubstitution, String> matchedElement;
        if (config2 == null) {
            SystemJSReferenceContributor.$$$reportNull$$$0(4);
        }
        if (unquotedRefText == null) {
            SystemJSReferenceContributor.$$$reportNull$$$0(5);
        }
        if (host == null) {
            SystemJSReferenceContributor.$$$reportNull$$$0(6);
        }
        if ((matchedElement = JSPathMappingsUtil.findMaxElementByPaths(unquotedRefText, mappings = config2.getMappings())) == null) {
            return ContainerUtil.emptyList();
        }
        JSModulePathSubstitution matchedPattern = (JSModulePathSubstitution)matchedElement.getFirst();
        String matchedStar = StringUtil.nullize((String)((String)matchedElement.getSecond()));
        Collection<String> forFileReference = JSPathMappingsUtil.getMappings(matchedPattern, matchedStar, true);
        Collection<String> forExactReference = JSPathMappingsUtil.getMappings(matchedPattern, matchedStar, false);
        if (forExactReference.isEmpty() && forFileReference.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        JSMappingReferenceSet mappingReferenceSet = new JSMappingReferenceSet(unquotedRefText, host, offset, provider2){

            @Override
            @NotNull
            protected JSMappingReferenceSet.MappingFileReferenceSet createMappingFileReferenceSet(@NotNull Collection<? extends PsiPolyVariantReference> parentReferences, @NotNull String fileReferencesText, int offsetForFileReferences) {
                int separator;
                if (parentReferences == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (fileReferencesText == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((separator = fileReferencesText.indexOf(33)) > 0) {
                    fileReferencesText = fileReferencesText.substring(0, separator);
                }
                JSMappingReferenceSet.MappingFileReferenceSet mappingFileReferenceSet = super.createMappingFileReferenceSet(parentReferences, fileReferencesText, offsetForFileReferences);
                if (mappingFileReferenceSet == null) {
                    1.$$$reportNull$$$0(2);
                }
                return mappingFileReferenceSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parentReferences";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileReferencesText";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createMappingFileReferenceSet";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createMappingFileReferenceSet";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        Collection<String> exactPaths = SystemJSReferenceContributor.convertPaths(config2, SystemJSReferenceContributor.replaceStarsByMatchedString(matchedStar, forExactReference));
        Collection<String> aliasedPaths = SystemJSReferenceContributor.convertPaths(config2, forFileReference);
        return mappingReferenceSet.getAliasedAndExactReferences(matchedPattern, aliasedPaths, exactPaths);
    }

    @NotNull
    private static ArrayList<String> replaceStarsByMatchedString(String matchedStar, Collection<String> forExactReference) {
        ArrayList elementsWithReplacedStar = ContainerUtil.newArrayList();
        for (String mapping : forExactReference) {
            String currentEl = matchedStar != null ? mapping.replace("*", matchedStar) : mapping;
            elementsWithReplacedStar.add(currentEl);
        }
        ArrayList arrayList = elementsWithReplacedStar;
        if (arrayList == null) {
            SystemJSReferenceContributor.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static Collection<String> convertPaths(@NotNull SystemJSConfig config2, @NotNull Collection<String> forFileReference) {
        if (config2 == null) {
            SystemJSReferenceContributor.$$$reportNull$$$0(8);
        }
        if (forFileReference == null) {
            SystemJSReferenceContributor.$$$reportNull$$$0(9);
        }
        if (forFileReference.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        VirtualFile baseURL = config2.getBaseURL();
        VirtualFile root = config2.rootDirectory();
        for (String path : forFileReference) {
            String toProcess = JSPathMappingsUtil.getPatternOrMappingWithoutStar(path);
            result2.add(JSPathMappingsUtil.getStringPathRelativeBaseUrlOrSelfIfAbsolute(toProcess.startsWith(".") ? root : baseURL, toProcess));
        }
        return result2;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement host) {
        if (host == null) {
            SystemJSReferenceContributor.$$$reportNull$$$0(10);
        }
        return !DialectDetector.isTypeScript(host);
    }

    @Override
    public int getDefaultWeight() {
        return JSModuleBaseReference.ModuleTypes.PATH_MAPPING.weight();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedEscapedText";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedRefText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forFileReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceStarsByMatchedString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAliasedReferences";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertPaths";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

