/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ecmascript6.psi.impl.JSSymlinkLinkedProject;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptInES6ImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptSymlinkLinkedProject;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePattern;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptImportPathBuilder
extends TypeScriptInES6ImportPathBuilder {
    @Nullable
    private final TypeScriptConfig myConfigFile;

    public TypeScriptImportPathBuilder(@NotNull PsiElement place, @Nullable PsiElement elementToImport, @NotNull VirtualFile importedFile, @Nullable TypeScriptConfig configFile, boolean useExistingImports) {
        if (place == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(0);
        }
        if (importedFile == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(1);
        }
        super(place, elementToImport, importedFile, useExistingImports);
        this.myConfigFile = configFile;
    }

    @Override
    protected boolean useNodeResolution() {
        if (!super.useNodeResolution()) {
            return false;
        }
        if (this.myConfigFile == null) {
            return true;
        }
        TypeScriptConfig.ModuleResolution resolution = this.myConfigFile.getResolution();
        if (resolution == TypeScriptConfig.ModuleResolution.NODE) {
            return true;
        }
        return TypeScriptConfig.ModuleTarget.COMMON_JS == this.myConfigFile.getModule();
    }

    @Override
    public void processModuleNamesWithoutExistingImports(@NotNull Processor<JSModuleNameInfo> processor) {
        JSModuleNameInfo mapping;
        if (processor == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(2);
        }
        if (this.myConfigFile != null && (mapping = this.getModuleNameUsingPathMappings()) != null && !processor.process((Object)mapping)) {
            return;
        }
        super.processModuleNamesWithoutExistingImports(processor);
    }

    @Nullable
    private JSModuleNameInfo getModuleNameUsingPathMappings() {
        if (this.myConfigFile == null) {
            return null;
        }
        VirtualFile baseUrl = this.myConfigFile.getBaseUrl();
        if (baseUrl == null) {
            return null;
        }
        JSModuleNameInfo currentMapping = null;
        for (JSModulePathSubstitution substitution : this.myConfigFile.getPaths()) {
            String pattern = substitution.getPattern();
            if (StringUtil.isEmpty((String)pattern)) continue;
            for (String mapping : substitution.getMappings()) {
                JSModuleNameInfo possibleMapping;
                if (StringUtil.isEmpty((String)mapping) || (possibleMapping = this.getModuleNameForMapping(baseUrl, pattern, mapping)) == null || !TypeScriptImportPathBuilder.shouldUseNewMapping(currentMapping, possibleMapping)) continue;
                currentMapping = possibleMapping;
            }
        }
        return currentMapping;
    }

    @Nullable
    private JSModuleNameInfo getModuleNameForMapping(@NotNull VirtualFile baseUrl, @NotNull String pattern, @NotNull String mapping) {
        boolean hasSeparatorInFirstPart;
        if (baseUrl == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(4);
        }
        if (mapping == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(5);
        }
        mapping = FileUtil.toSystemIndependentName((String)mapping);
        int starIndex = mapping.indexOf("*");
        if (pattern.length() < 2) {
            return null;
        }
        if (starIndex < 0) {
            VirtualFile pathFile = TypeScriptImportPathBuilder.getPossibleFileWithExtension(baseUrl, mapping);
            if (pathFile == null) {
                return null;
            }
            VirtualFile file2 = TypeScriptImportPathBuilder.isFromNestedDirectory(pathFile, this.myFileToImport) ? this.checkSymbolAndGetFile(pathFile) : null;
            return file2 == null ? null : new JSModuleNameInfo(pattern, pathFile, file2, this.myPlace);
        }
        String firstPart = mapping.substring(0, starIndex);
        int separatorIndex = firstPart.lastIndexOf(47);
        VirtualFile startDirectory = baseUrl;
        boolean bl = hasSeparatorInFirstPart = separatorIndex >= 0;
        if (hasSeparatorInFirstPart) {
            startDirectory = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, firstPart.substring(0, separatorIndex));
        }
        if (startDirectory == null) {
            return null;
        }
        List<VirtualFile> parents = TypeScriptImportPathBuilder.collectParents(this.myFileToImport, startDirectory);
        if (parents.isEmpty()) {
            return null;
        }
        VirtualFile placeDirectory = this.myPlaceFile.getParent();
        String partOfString = mapping.substring(hasSeparatorInFirstPart ? separatorIndex : 0);
        for (VirtualFile pathFile : ContainerUtil.reverse(parents)) {
            VirtualFile file3;
            String stringToCheckPattern;
            if (pathFile.equals(placeDirectory) || StringUtil.isEmpty((String)(stringToCheckPattern = VfsUtilCore.findRelativePath((VirtualFile)startDirectory, (VirtualFile)pathFile, (char)'/')))) continue;
            JSModulePattern pathSubstitution = JSPathMappingsUtil.createPatternForString(partOfString);
            Pair matchedStar = JSPathMappingsUtil.findMaxElementByPaths((hasSeparatorInFirstPart ? "/" : "") + stringToCheckPattern, ContainerUtil.createMaybeSingletonList((Object)pathSubstitution));
            if (matchedStar == null || (file3 = this.checkSymbolAndGetFile(pathFile)) == null) continue;
            return new JSModuleNameInfo(pattern.replace("*", (CharSequence)matchedStar.second), file3, pathFile, this.myPlaceModule);
        }
        return null;
    }

    private static boolean shouldUseNewMapping(@Nullable JSModuleNameInfo oldMapping, @NotNull JSModuleNameInfo newMapping) {
        if (newMapping == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(6);
        }
        if (oldMapping == null) {
            return true;
        }
        return oldMapping.getPath().length() > newMapping.getPath().length();
    }

    private static VirtualFile getPossibleFileWithExtension(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(7);
        }
        if (mapping == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(8);
        }
        if (JSFileReference.findExtension(mapping, TypeScriptUtil.TYPESCRIPT_EXTENSIONS) != null) {
            return JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, mapping);
        }
        for (String extension : TypeScriptUtil.TYPESCRIPT_EXTENSIONS) {
            VirtualFile possibleFile = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, mapping + extension);
            if (possibleFile == null) continue;
            return possibleFile;
        }
        return JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, mapping);
    }

    private static boolean isFromNestedDirectory(VirtualFile parentFile, VirtualFile dstFile) {
        if (parentFile.equals(dstFile)) {
            return true;
        }
        if (!parentFile.isDirectory()) {
            parentFile = parentFile.getParent();
        }
        return VfsUtilCore.isAncestor((VirtualFile)parentFile, (VirtualFile)dstFile, (boolean)false);
    }

    @Nullable
    private VirtualFile getRootFromConfig() {
        if (this.myConfigFile == null) {
            return null;
        }
        VirtualFile baseUrl = this.myConfigFile.getBaseUrl();
        return baseUrl != null ? baseUrl : this.myConfigFile.getConfigDirectory();
    }

    @Override
    @Nullable
    protected JSModuleNameInfo processRootPaths(@NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile) {
        VirtualFile rootFile;
        if (moduleFileOrDirectory == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(9);
        }
        if (resolvedModuleFile == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(10);
        }
        if ((rootFile = this.getRootFromConfig()) != null) {
            return this.getPathForRoot(moduleFileOrDirectory, resolvedModuleFile, rootFile);
        }
        return super.processRootPaths(moduleFileOrDirectory, resolvedModuleFile);
    }

    @Override
    @Nullable
    protected JSSymlinkLinkedProject getLinkedProject(@NotNull VirtualFile importRoot, @Nullable VirtualFile nodeModules, @Nullable String packageName) {
        if (importRoot == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(11);
        }
        if (TypeScriptUtil.isDefinitionFile(this.myFileToImport)) {
            return super.getLinkedProject(importRoot, nodeModules, packageName);
        }
        VirtualFile linkedPackage = TypeScriptImportPathBuilder.getLinkedPackage(importRoot, nodeModules, packageName);
        if (linkedPackage == null) {
            return null;
        }
        TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForFile(this.myProject, this.myFileToImport);
        if (config2 == null) {
            return null;
        }
        VirtualFile configDirectory = config2.getConfigDirectory();
        if (!VfsUtilCore.isAncestor((VirtualFile)configDirectory, (VirtualFile)this.myFileToImport, (boolean)true)) {
            return null;
        }
        VirtualFile sourceRoot = TypeScriptImportPathBuilder.getSourceRoot(config2, this.myFileToImport);
        if (sourceRoot == null) {
            return null;
        }
        String outDirPath = config2.getOutDirectory();
        VirtualFile outDirectory = (VirtualFile)ObjectUtils.coalesce((Object)(outDirPath == null ? null : LocalFileSystem.getInstance().findFileByPath(outDirPath)), (Object)configDirectory);
        if (outDirectory.equals(sourceRoot)) {
            return new TypeScriptSymlinkLinkedProject(importRoot, linkedPackage, importRoot, importRoot, packageName);
        }
        if (!VfsUtilCore.isAncestor((VirtualFile)importRoot, (VirtualFile)outDirectory, (boolean)false)) {
            return null;
        }
        return new TypeScriptSymlinkLinkedProject(importRoot, linkedPackage, sourceRoot, outDirectory, packageName);
    }

    @Nullable
    private static VirtualFile getSourceRoot(@NotNull TypeScriptConfig importFileConfig, @NotNull VirtualFile fileToImport) {
        VirtualFile rootDir;
        if (importFileConfig == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(12);
        }
        if (fileToImport == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(13);
        }
        if ((rootDir = importFileConfig.getRootDirFile()) == null) {
            return importFileConfig.getConfigDirectory();
        }
        return VfsUtilCore.isAncestor((VirtualFile)rootDir, (VirtualFile)fileToImport, (boolean)true) ? rootDir : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMapping";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFileOrDirectory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedModuleFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importRoot";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importFileConfig";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToImport";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/TypeScriptImportPathBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processModuleNamesWithoutExistingImports";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleNameForMapping";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldUseNewMapping";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getPossibleFileWithExtension";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "processRootPaths";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getLinkedProject";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourceRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

