/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.init;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.CustomFileTemplate;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.joomla.JoomlaBundle;
import com.jetbrains.php.joomla.JoomlaUtil;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JoomlaFileTemplatesManager {
    private final List<FileTemplate> myJoomlaCustomCodeTemplates;
    private final Project myProject;

    public JoomlaFileTemplatesManager(Project project) {
        CustomFileTemplate customFileTemplate = new CustomFileTemplate("PHP File Header", "php");
        customFileTemplate.setText("/**\n * @package     ${NAMESPACE}\n * @subpackage  \n *\n * @copyright   A copyright\n * @license     A \"Slug\" license name e.g. GPL2\n */");
        CustomFileTemplate customClassDocTemplate = new CustomFileTemplate("PHP Class Doc Comment", "php");
        String version = "version";
        customClassDocTemplate.setText("/**\n * @package     ${NAMESPACE}\n *\n * @since " + version + "\n */");
        CustomFileTemplate customFieldDocComment = new CustomFileTemplate("PHP Field Doc Comment", "php");
        customFieldDocComment.setText("/**\n * @var ${TYPE_HINT}\n * @since " + version + "\n */\n");
        CustomFileTemplate customMethodDocBlock = new CustomFileTemplate("PHP Function Doc Comment", "php");
        customMethodDocBlock.setText("/**\n${PARAM_DOC}\n*\n#if (${TYPE_HINT} != \"void\") * @return ${TYPE_HINT}\n#end\n*\n* @since " + version + "\n${THROWS_DOC}\n*/\n");
        this.myJoomlaCustomCodeTemplates = ContainerUtil.newArrayList((Object[])new FileTemplate[]{customFileTemplate, customClassDocTemplate, customFieldDocComment, customMethodDocBlock});
        this.myProject = project;
    }

    public void offerJoomlaFileTemplates(JoomlaDataService.State newState, JoomlaDataService.State oldState) {
        if (!newState.isEnabled() || oldState.isEnabled()) {
            return;
        }
        FileTemplateManager manager = FileTemplateManager.getInstance((Project)this.myProject);
        if (manager.getCurrentScheme().equals(manager.getProjectScheme())) {
            return;
        }
        Function<Notification, AnAction> setAction = notification -> new AnAction("Set", (Notification)notification){
            final /* synthetic */ Notification val$notification;
            {
                this.val$notification = notification;
                super(arg0);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                JoomlaFileTemplatesManager.this.setFileTemplates(JoomlaFileTemplatesManager.this.myProject);
                this.val$notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/joomla/init/JoomlaFileTemplatesManager$1", "actionPerformed"));
            }
        };
        JoomlaUtil.notifyGlobally(this.myProject, JoomlaBundle.message("joomla.plugin.title", new Object[0]), JoomlaBundle.message("joomla.offer.docblock.fileTemplate", new Object[0]), NotificationType.INFORMATION, setAction);
    }

    public void setFileTemplates(Project project) {
        FileTemplateManager manager = FileTemplateManager.getInstance((Project)project);
        manager.setCurrentScheme(manager.getProjectScheme());
        List<FileTemplate> templates = Arrays.asList(FileTemplateManager.getInstance((Project)project).getTemplates("Includes"));
        List allTemplates = templates.stream().filter(o -> !this.isNew((FileTemplate)o)).collect(Collectors.toList());
        allTemplates.addAll(this.myJoomlaCustomCodeTemplates);
        FileTemplateManager.getInstance((Project)project).setTemplates("Includes", allTemplates);
    }

    public boolean isNew(FileTemplate template) {
        for (FileTemplate it : this.myJoomlaCustomCodeTemplates) {
            if (!template.getName().equals(it.getName())) continue;
            return true;
        }
        return false;
    }
}

