//===========================================================================
//  CVS Information:                                                         
//                                                                           
//     $RCSfile: qmr.cc,v $  $Revision: 1.2 $  $State: Exp $ 
//     $Author: jsiek $  $Date: 2000/08/28 15:23:00 $ 
//     $Locker:  $ 
//---------------------------------------------------------------------------
//                                                                           
// DESCRIPTION                                                               
//                                                                           
//---------------------------------------------------------------------------
//                                                                           
// LICENSE AGREEMENT                                                         
// Copyright 1997, University of Notre Dame.
// Authors: Andrew Lumsdaine, Jeremy G. Siek
//
// This file is part of the Matrix Template Library
//
// You should have received a copy of the License Agreement for the
// Matrix Template Library along with the software;  see the
// file LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN  46556.
//
// Permission to modify the code and to distribute modified code is
// granted, provided the text of this NOTICE is retained, a notice that
// the code was modified is included with the above COPYRIGHT NOTICE and
// with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
// file is distributed with the modified code.
//
// LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
// By way of example, but not limitation, Licensor MAKES NO
// REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
// PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
// OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
// OR OTHER RIGHTS.
//---------------------------------------------------------------------------
//                                                                           
// REVISION HISTORY:                                                         
//                                                                           
// $Log: qmr.cc,v $
// Revision 1.2  2000/08/28 15:23:00  jsiek
// got rid of iostream.h and replaced with iostream
//
// Revision 1.1.1.1  2000/07/12 21:51:43  jsiek
// stable mtl version
//
// Revision 1.8  1999/09/09 06:50:40  jsiek
// took out argc, argv
//
// Revision 1.7  1999/04/19 17:40:34  jsiek
// blah
//
// Revision 1.6  1999/03/10 17:07:58  jsiek
// sparse -> compressed<> and compressed -> compressed<> name changes
//
// Revision 1.5  1999/03/04 17:37:24  llee1
// *** empty log message ***
//
// Revision 1.4  1999/02/02 22:07:24  arodrig6
// added and updated BLAS level I and II examples to reflect new style vectors and Matrix definitions
//
// Revision 1.2  1998/08/16 22:18:01  jsiek
// compressed name change
//
// Revision 1.1  1998/08/12 20:58:34  llee1
// example for qmr
//
//                                                                           
//===========================================================================

#include "mtl/matrix.h"
#include "mtl/mtl.h"
#include "mtl/utils.h"

#include "itl/itl.h"
#include "itl/ssor.h"
#include "itl/qmr.h"
/*
  In thsi example, we show how to use QMR algorithm, the output should be:

iteration 0: resid 1
iteration 1: resid 2.52919
iteration 2: resid 0.468754
iteration 3: resid 0.0612519
finished! error code = 0
4 iterations
6.05118e-14 final residual
     1      2      0      0      3   x          0.205847  =       1
     4      5      0      6      0   x         0.0419363  =       1
     0      7      8      0      9   x         -0.178049  =       1
     0      0     10     11     12   x       -0.00551162  =       1
     0      0     13      0     14   x           0.23676  =       1
*/
using namespace mtl;
using namespace itl;

typedef  double Type;

typedef matrix< Type, rectangle<>, 
	        array< compressed<> >, 
                row_major >::type Matrix;

int main()
{
  int max_iter = 50;
  //begin
  Matrix A(5, 5);
  // Fill matrix...
  //end
  A(0, 0) = 1.0;
  A(0, 1) = 2.0;
  A(0, 4) = 3.0;
  A(1, 0) = 4.0;
  A(1, 1) = 5.0;
  A(1, 3) = 6.0;
  A(2, 1) = 7.0;
  A(2, 2) = 8.0;
  A(2, 4) = 9.0;
  A(3, 2) = 10.;
  A(3, 3) = 11.;
  A(3, 4) = 12.;
  A(4, 2) = 13.; 
  A(4, 4) = 14.;
  //begin
  dense1D<Type> x(A.nrows(), Type(0));
  dense1D<Type> b(A.ncols());
  for (dense1D<Type>::iterator i=b.begin(); i!=b.end(); i++)
    *i = 1.;

  //SSOR preconditioner
  SSOR<Matrix> precond(A);
  //iteration
  noisy_iteration<double> iter(b, max_iter, 1e-6);
  //qmr algorithm
  qmr(A, x, b, precond.left(), precond.right(), iter);
  //end

  //verify the result
  dense1D<Type> b1(A.ncols());
  mult(A, x, b1);
  add(b1, scaled(b, -1.), b1);

  if ( two_norm(b1) < 1.e-6) { //output
    for (int i=0; i<5; i++) {
      for (int j=0; j<5; j++) {
	std::cout.width(6);
	std::cout << A(i, j) << " ";
      }
      std::cout << "  x  ";
      std::cout.width(16);
      std::cout << x[i] << "  =  ";
      std::cout.width(6);
      std::cout << b[i] << std::endl;
    }
  } else {
    std::cout << "Residual " << iter.resid() << std::endl;
  }

  return 0;
  }


