// -*- c++ -*-
//
// Software License for MTL
// 
// Copyright (c) 2001-2005 The Trustees of Indiana University. All rights reserved.
// Copyright (c) 1998-2001 University of Notre Dame. All rights reserved.
// Authors: Andrew Lumsdaine, Jeremy G. Siek, Lie-Quan Lee
// 
// This file is part of the Matrix Template Library
// 
// See also license.mtl.txt in the distribution.
// $Id: geev.cc,v 1.2 2000/08/28 15:22:59 jsiek Exp $
//


#include <complex>
#include "mtl/mtl2lapack.h"
#include "mtl/dense1D.h"
#include "mtl/utils.h"


/*
  Sample Output

  2x2
  [
  [0,1],
  [-6,5]
  ]
  eigenvalues
  [(2,0),(3,0),]
  eigenvectors
  4x2
  [
  [0.447214,0.316228],
  [0.894427,0.948683],
  [0,0],
  [0,0]
  ]

  */

int
main()
{
  using namespace mtl2lapack;

  const int N = 2;
  //begin
  double da [] = { 0, -6, 1, 5 };
  lapack_matrix<double,external>::type A(da, N,N), vl((double*)0,N,N);
  lapack_matrix<double>::type vr(2*N,N);
  mtl::dense1D< std::complex<double> > wr(N);
  int info;
  //end
  mtl::print_all_matrix(A);

  // Compute the eigenvalues and right eigenvectors of A.
  //begin
  info = geev(GEEV_CALC_RIGHT, A, wr, vl, vr);
  //end
  if (info > 0) {
    std::cout << "QR failed to converge, INFO = " << info << std::endl;
    return 0;
  }

  // Print the eigenvalues and eigenvectors.

  std::cout << "eigenvalues" << std::endl;
  mtl::print_vector(wr);

  std::cout << "eigenvectors" << std::endl;

  mtl::print_all_matrix(vr);

  return 0;
}

