/*
 * Decompiled with CFR 0.152.
 */
package free.chessclub;

import free.chessclub.level2.Datagram;
import free.chessclub.level2.DatagramEvent;
import free.chessclub.level2.DatagramListener;
import free.util.Connection;
import free.util.EventListenerList;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.util.BitSet;
import java.util.EventListener;
import java.util.Hashtable;

public class ChessclubConnection
extends Connection {
    private final Hashtable ratingCategoryNames = new Hashtable();
    private final Hashtable variantNames = new Hashtable();
    private final PrintStream logStream;
    private BitSet requestedLevel2Settings = new BitSet();
    private int style = 1;
    private String interfaceVar = "Java chessclub.com library (http://www.jinchess.com/)";
    private BitSet level2Settings = new BitSet();
    private boolean level2SettingsSent = false;
    private final EventListenerList[] datagramListeners = new EventListenerList[133];

    public ChessclubConnection(String string, String string2, PrintStream printStream) {
        super(string, string2);
        this.logStream = printStream;
        this.setDGState(0, true);
        this.setDGState(69, true);
        this.setDGState(76, true);
        this.setDGState(116, true);
        this.setDGState(124, true);
    }

    public void addDatagramListener(DatagramListener datagramListener, int n) {
        if (this.datagramListeners[n] == null) {
            this.datagramListeners[n] = new EventListenerList();
            this.setDGState(n, true);
        }
        this.datagramListeners[n].add(DatagramListener.class, (EventListener)datagramListener);
    }

    public void removeDatagramListener(DatagramListener datagramListener, int n) {
        if (this.datagramListeners[n] == null) {
            return;
        }
        this.datagramListeners[n].remove(DatagramListener.class, (EventListener)datagramListener);
        if (this.datagramListeners[n].getListenerCount() == 0) {
            this.datagramListeners[n] = null;
            this.setDGState(n, false);
        }
    }

    protected void fireDatagramEvent(Datagram datagram) {
        DatagramEvent datagramEvent = new DatagramEvent(this, datagram);
        EventListenerList eventListenerList = this.datagramListeners[datagram.getId()];
        if (eventListenerList != null) {
            Object[] objectArray = eventListenerList.getListenerList();
            for (int i = 1; i < objectArray.length; i += 2) {
                ((DatagramListener)objectArray[i]).datagramReceived(datagramEvent);
            }
        }
    }

    protected final synchronized boolean setDGState(int n, boolean bl) {
        if (!bl && this.isEssentialDG(n)) {
            return false;
        }
        if (bl) {
            this.requestedLevel2Settings.set(n);
        } else {
            this.requestedLevel2Settings.clear(n);
        }
        if (this.level2SettingsSent) {
            if (this.isLoggedIn()) {
                this.sendCommand("set-2 " + n + " " + (bl ? "1" : "0"));
            }
        } else if (bl) {
            this.level2Settings.set(n);
        } else {
            this.level2Settings.clear(n);
        }
        return true;
    }

    protected synchronized void setDGOnAgain(int n) {
        if (!this.isDGOn(n)) {
            throw new IllegalStateException("Cannot set on again a datagram which is not on");
        }
        if (!this.isLoggedIn()) {
            throw new IllegalStateException("Cannot set on again a datagram when not yet logged in");
        }
        this.sendCommand("set-2 " + n + " 1");
    }

    public final synchronized void setInterface(String string) {
        if (this.isLoggedIn()) {
            throw new IllegalStateException();
        }
        this.interfaceVar = string;
    }

    public final synchronized boolean setStyle(int n) {
        int n2 = this.getEssentialStyle();
        if (n2 != -1 && n2 != n) {
            return false;
        }
        this.style = n;
        if (this.isLoggedIn()) {
            this.sendCommand("set-quietly style " + n);
        }
        return true;
    }

    protected boolean isEssentialDG(int n) {
        switch (n) {
            case 0: 
            case 69: 
            case 76: 
            case 124: {
                return true;
            }
        }
        return false;
    }

    protected int getEssentialStyle() {
        return -1;
    }

    public synchronized boolean isDGOn(int n) {
        return this.level2Settings.get(n);
    }

    protected void sendLoginSequence() {
        if (this.getPassword() == null || this.getPassword().length() == 0) {
            this.sendCommand(this.getRequestedUsername());
        } else {
            this.sendCommand(this.getRequestedUsername() + " " + this.getPassword(), false);
        }
    }

    protected void handleConnected() {
        int n;
        for (n = this.level2Settings.size(); n >= 0 && !this.level2Settings.get(n); --n) {
        }
        if (n >= 0) {
            StringBuffer stringBuffer = new StringBuffer("level2settings=");
            for (int i = 0; i <= n; ++i) {
                stringBuffer.append(this.level2Settings.get(i) ? "1" : "0");
            }
            this.sendCommand(stringBuffer.toString());
            this.level2SettingsSent = true;
        }
        super.handleConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLoginSucceeded() {
        ChessclubConnection chessclubConnection = this;
        synchronized (chessclubConnection) {
            for (int i = 0; i < this.requestedLevel2Settings.size(); ++i) {
                boolean bl = this.requestedLevel2Settings.get(i);
                if (bl == this.level2Settings.get(i)) continue;
                this.sendCommand("set-2 " + i + " " + (bl ? "1" : "0"));
            }
            this.sendCommand("set-quietly prompt 0");
            this.sendCommand("set-quietly highlight 0");
            this.sendCommand("set-quietly style " + this.style);
            this.sendCommand("set-quietly interface " + this.interfaceVar);
        }
        super.handleLoginSucceeded();
    }

    protected void handleMessage(Object object) {
        if (object instanceof String) {
            this.handleLine((String)object);
        } else if (object instanceof Datagram) {
            this.handleDatagram((Datagram)object);
        } else {
            throw new IllegalArgumentException("Unrecognized message type: " + object.getClass().getName());
        }
    }

    protected InputStream createInputStream(InputStream inputStream) {
        return new PushbackInputStream(new BufferedInputStream(inputStream));
    }

    protected Object readMessage(InputStream inputStream) throws IOException {
        String string;
        PushbackInputStream pushbackInputStream = (PushbackInputStream)inputStream;
        do {
            int n;
            if ((n = pushbackInputStream.read()) < 0) {
                return null;
            }
            pushbackInputStream.unread(n);
            if (n == 25) {
                return Datagram.readDatagram(pushbackInputStream);
            }
            string = this.readLine(pushbackInputStream);
        } while ((string = this.filterLine(string)) == null);
        return string;
    }

    private String readLine(PushbackInputStream pushbackInputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = pushbackInputStream.read()) >= 0 && n != 10) {
            if (n == 13) {
                n = pushbackInputStream.read();
                if (n <= 0 || n == 10) break;
                pushbackInputStream.unread(n);
                break;
            }
            if (n == 25) {
                pushbackInputStream.unread(n);
                break;
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    private String filterLine(String string) {
        int n = string.length();
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (string.startsWith("aics% ", n2)) {
            n2 += "aics% ".length();
        }
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c != '\u0007') {
                stringBuffer.append(c);
            }
            ++n2;
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public void quit() {
        if (this.isLoggedIn()) {
            this.sendCommand("exit");
        }
    }

    public void sendCommand(String string) {
        this.sendCommand(string, true);
    }

    public synchronized void sendCommand(String string, boolean bl) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
        if (bl && this.logStream != null) {
            this.logStream.println("SENDING COMMAND: " + string);
        }
        try {
            OutputStream outputStream = this.getOutputStream();
            outputStream.write(string.getBytes("ISO8859_1"));
            outputStream.write(10);
            outputStream.flush();
        }
        catch (IOException iOException) {
            this.connectionInterrupted(iOException);
        }
    }

    public String getRatingCategoryName(int n) {
        return (String)this.ratingCategoryNames.get(new Integer(n));
    }

    public String getVariantName(int n) {
        return (String)this.variantNames.get(new Integer(n));
    }

    public final void handleDatagram(Datagram datagram) {
        int n;
        if (this.logStream != null) {
            this.logStream.println(datagram);
        }
        if ((n = datagram.getId()) == 0 && !this.isLoggedIn()) {
            this.loginSucceeded(datagram.getString(0));
        } else if (n == 69 && !this.isLoggedIn()) {
            this.loginFailed(datagram.getString(1));
        } else if (n == 76) {
            int n2 = datagram.getInteger(0);
            String string = datagram.getString(1);
            this.ratingCategoryNames.put(new Integer(n2), string);
        } else if (n == 116) {
            int n3 = datagram.getInteger(0);
            String string = datagram.getString(1);
            this.variantNames.put(new Integer(n3), string);
        } else if (n == 124) {
            int n4 = datagram.getInteger(0);
            boolean bl = datagram.getBoolean(1);
            if (bl) {
                this.level2Settings.set(n4);
            } else {
                this.level2Settings.clear(n4);
            }
        }
        this.fireDatagramEvent(datagram);
    }

    public final void handleLine(String string) {
        if (this.logStream != null) {
            this.logStream.println(string);
        }
        this.processLine(string);
    }

    protected void processLine(String string) {
    }
}

