/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.SslConnection;
import org.eclipse.jetty.npn.NextProtoNego;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.spdy.AsyncConnectionFactory;
import org.eclipse.jetty.spdy.ByteBufferPool;
import org.eclipse.jetty.spdy.EmptyAsyncConnection;
import org.eclipse.jetty.spdy.FlowControlStrategy;
import org.eclipse.jetty.spdy.FlowControlStrategyFactory;
import org.eclipse.jetty.spdy.ServerSPDYAsyncConnectionFactory;
import org.eclipse.jetty.spdy.StandardByteBufferPool;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.api.server.ServerSessionFrameListener;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ThreadPool;

public class SPDYServerConnector
extends SelectChannelConnector {
    private static final Logger logger = Log.getLogger(SPDYServerConnector.class);
    private final Map<String, AsyncConnectionFactory> factories = new LinkedHashMap<String, AsyncConnectionFactory>();
    private final Queue<Session> sessions = new ConcurrentLinkedQueue<Session>();
    private final ByteBufferPool bufferPool = new StandardByteBufferPool();
    private final Executor executor = new LazyExecutor();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final ServerSessionFrameListener listener;
    private final SslContextFactory sslContextFactory;
    private volatile AsyncConnectionFactory defaultConnectionFactory;
    private volatile int initialWindowSize = 65536;

    public SPDYServerConnector(ServerSessionFrameListener listener) {
        this(listener, null);
    }

    public SPDYServerConnector(ServerSessionFrameListener listener, SslContextFactory sslContextFactory) {
        this.listener = listener;
        this.sslContextFactory = sslContextFactory;
        if (sslContextFactory != null) {
            this.addBean(sslContextFactory);
        }
        this.putAsyncConnectionFactory("spdy/3", new ServerSPDYAsyncConnectionFactory(3, this.bufferPool, this.executor, this.scheduler, listener));
        this.putAsyncConnectionFactory("spdy/2", new ServerSPDYAsyncConnectionFactory(2, this.bufferPool, this.executor, this.scheduler, listener));
        this.setDefaultAsyncConnectionFactory(this.getAsyncConnectionFactory("spdy/2"));
    }

    public ByteBufferPool getByteBufferPool() {
        return this.bufferPool;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public ServerSessionFrameListener getServerSessionFrameListener() {
        return this.listener;
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    protected void doStart() throws Exception {
        super.doStart();
        logger.info("SPDY support is experimental. Please report feedback at jetty-dev@eclipse.org", new Object[0]);
    }

    protected void doStop() throws Exception {
        this.closeSessions();
        this.scheduler.shutdown();
        super.doStop();
    }

    public void join() throws InterruptedException {
        this.scheduler.awaitTermination(0L, TimeUnit.MILLISECONDS);
        super.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncConnectionFactory getAsyncConnectionFactory(String protocol) {
        Map<String, AsyncConnectionFactory> map = this.factories;
        synchronized (map) {
            return this.factories.get(protocol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncConnectionFactory putAsyncConnectionFactory(String protocol, AsyncConnectionFactory factory) {
        Map<String, AsyncConnectionFactory> map = this.factories;
        synchronized (map) {
            return this.factories.put(protocol, factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncConnectionFactory removeAsyncConnectionFactory(String protocol) {
        Map<String, AsyncConnectionFactory> map = this.factories;
        synchronized (map) {
            return this.factories.remove(protocol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, AsyncConnectionFactory> getAsyncConnectionFactories() {
        Map<String, AsyncConnectionFactory> map = this.factories;
        synchronized (map) {
            return new LinkedHashMap<String, AsyncConnectionFactory>(this.factories);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAsyncConnectionFactories() {
        Map<String, AsyncConnectionFactory> map = this.factories;
        synchronized (map) {
            this.factories.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> provideProtocols() {
        Map<String, AsyncConnectionFactory> map = this.factories;
        synchronized (map) {
            return new ArrayList<String>(this.factories.keySet());
        }
    }

    public AsyncConnectionFactory getDefaultAsyncConnectionFactory() {
        return this.defaultConnectionFactory;
    }

    public void setDefaultAsyncConnectionFactory(AsyncConnectionFactory defaultConnectionFactory) {
        this.defaultConnectionFactory = defaultConnectionFactory;
    }

    protected AsyncConnection newConnection(final SocketChannel channel, AsyncEndPoint endPoint) {
        if (this.sslContextFactory != null) {
            final SSLEngine engine = this.newSSLEngine(this.sslContextFactory, channel);
            SslConnection sslConnection = new SslConnection(engine, (EndPoint)endPoint){

                public void onClose() {
                    NextProtoNego.remove((SSLEngine)engine);
                    super.onClose();
                }
            };
            endPoint.setConnection((Connection)sslConnection);
            final AsyncEndPoint sslEndPoint = sslConnection.getSslEndPoint();
            NextProtoNego.put((SSLEngine)engine, (NextProtoNego.Provider)new NextProtoNego.ServerProvider(){

                public void unsupported() {
                    AsyncConnectionFactory connectionFactory = SPDYServerConnector.this.getDefaultAsyncConnectionFactory();
                    AsyncConnection connection = connectionFactory.newAsyncConnection(channel, sslEndPoint, (Object)SPDYServerConnector.this);
                    sslEndPoint.setConnection((Connection)connection);
                }

                public List<String> protocols() {
                    return SPDYServerConnector.this.provideProtocols();
                }

                public void protocolSelected(String protocol) {
                    AsyncConnectionFactory connectionFactory = SPDYServerConnector.this.getAsyncConnectionFactory(protocol);
                    AsyncConnection connection = connectionFactory.newAsyncConnection(channel, sslEndPoint, (Object)SPDYServerConnector.this);
                    sslEndPoint.setConnection((Connection)connection);
                }
            });
            EmptyAsyncConnection connection = new EmptyAsyncConnection(sslEndPoint);
            sslEndPoint.setConnection((Connection)connection);
            this.startHandshake(engine);
            return sslConnection;
        }
        AsyncConnectionFactory connectionFactory = this.getDefaultAsyncConnectionFactory();
        AsyncConnection connection = connectionFactory.newAsyncConnection(channel, endPoint, (Object)this);
        endPoint.setConnection((Connection)connection);
        return connection;
    }

    protected FlowControlStrategy newFlowControlStrategy(short version) {
        return FlowControlStrategyFactory.newFlowControlStrategy(version);
    }

    protected SSLEngine newSSLEngine(SslContextFactory sslContextFactory, SocketChannel channel) {
        String peerHost = channel.socket().getInetAddress().getHostAddress();
        int peerPort = channel.socket().getPort();
        SSLEngine engine = sslContextFactory.newSslEngine(peerHost, peerPort);
        engine.setUseClientMode(false);
        return engine;
    }

    private void startHandshake(SSLEngine engine) {
        try {
            engine.beginHandshake();
        }
        catch (SSLException x) {
            throw new RuntimeException(x);
        }
    }

    protected boolean sessionOpened(Session session) {
        return this.isRunning() && this.sessions.offer(session);
    }

    protected boolean sessionClosed(Session session) {
        return this.isRunning() && this.sessions.remove(session);
    }

    private void closeSessions() {
        for (Session session : this.sessions) {
            session.goAway();
        }
        this.sessions.clear();
    }

    protected Collection<Session> getSessions() {
        return Collections.unmodifiableCollection(this.sessions);
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public void setInitialWindowSize(int initialWindowSize) {
        this.initialWindowSize = initialWindowSize;
    }

    public void dump(Appendable out, String indent) throws IOException {
        super.dump(out, indent);
        AggregateLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{new ArrayList<Session>(this.sessions)});
    }

    private class LazyExecutor
    implements Executor {
        private LazyExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            ThreadPool threadPool = SPDYServerConnector.this.getThreadPool();
            if (threadPool == null) {
                throw new RejectedExecutionException();
            }
            threadPool.dispatch(command);
        }
    }
}

