/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.problems.internal.AdditionalData;
import org.gradle.api.problems.internal.AdditionalDataBuilder;
import org.gradle.api.problems.internal.AdditionalDataSpec;
import org.gradle.api.problems.internal.DefaultDeprecationData;
import org.gradle.api.problems.internal.DefaultGeneralData;
import org.gradle.api.problems.internal.DefaultPropertyTraceData;
import org.gradle.api.problems.internal.DefaultTypeValidationData;
import org.gradle.api.problems.internal.DeprecationData;
import org.gradle.api.problems.internal.DeprecationDataSpec;
import org.gradle.api.problems.internal.GeneralData;
import org.gradle.api.problems.internal.GeneralDataSpec;
import org.gradle.api.problems.internal.PropertyTraceData;
import org.gradle.api.problems.internal.PropertyTraceDataSpec;
import org.gradle.api.problems.internal.TypeValidationData;
import org.gradle.api.problems.internal.TypeValidationDataSpec;

public class AdditionalDataBuilderFactory {
    static final Map<Class<?>, DataTypeAndProvider> ADDITIONAL_DATA_BUILDER_PROVIDERS = ImmutableMap.builder().put(GeneralDataSpec.class, (Object)new DataTypeAndProvider(GeneralData.class, new Function<AdditionalData, AdditionalDataBuilder<? extends AdditionalData>>(){

        public AdditionalDataBuilder<? extends AdditionalData> apply(@Nullable AdditionalData instance) {
            return DefaultGeneralData.builder((GeneralData)instance);
        }
    })).put(DeprecationDataSpec.class, (Object)new DataTypeAndProvider(DeprecationData.class, new Function<AdditionalData, AdditionalDataBuilder<? extends AdditionalData>>(){

        public AdditionalDataBuilder<? extends AdditionalData> apply(@Nullable AdditionalData instance) {
            return DefaultDeprecationData.builder((DeprecationData)instance);
        }
    })).put(TypeValidationDataSpec.class, (Object)new DataTypeAndProvider(TypeValidationData.class, new Function<AdditionalData, AdditionalDataBuilder<? extends AdditionalData>>(){

        public AdditionalDataBuilder<? extends AdditionalData> apply(@Nullable AdditionalData instance) {
            return DefaultTypeValidationData.builder((TypeValidationData)instance);
        }
    })).put(PropertyTraceDataSpec.class, (Object)new DataTypeAndProvider(PropertyTraceData.class, new Function<AdditionalData, AdditionalDataBuilder<? extends AdditionalData>>(){

        public AdditionalDataBuilder<? extends AdditionalData> apply(@Nullable AdditionalData instance) {
            return DefaultPropertyTraceData.builder((PropertyTraceData)instance);
        }
    })).build();

    public static String getSupportedTypes() {
        StringBuilder result = new StringBuilder();
        for (Class<?> key : ADDITIONAL_DATA_BUILDER_PROVIDERS.keySet()) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(key.getName());
        }
        return result.toString();
    }

    private static <S extends AdditionalData, U extends AdditionalDataSpec> AdditionalDataBuilder<S> builderFor(Class<? extends U> specType, @Nullable S instance, String illegalArgumentMessage) {
        Preconditions.checkNotNull(specType);
        DataTypeAndProvider dataTypeAndProvider = ADDITIONAL_DATA_BUILDER_PROVIDERS.get(specType);
        if (dataTypeAndProvider != null) {
            return (AdditionalDataBuilder)dataTypeAndProvider.builderProvider.apply(instance);
        }
        throw new IllegalArgumentException(illegalArgumentMessage);
    }

    static <U extends AdditionalDataSpec> AdditionalDataBuilder<? extends AdditionalData> createAdditionalDataBuilder(Class<? extends U> specType, @Nullable AdditionalData additionalData) {
        if (additionalData == null) {
            return AdditionalDataBuilderFactory.builderFor(specType, null, "Unsupported type: " + specType);
        }
        if (AdditionalDataBuilderFactory.isCompatible(specType, additionalData)) {
            return AdditionalDataBuilderFactory.builderFor(specType, additionalData, "Unsupported instance: " + additionalData);
        }
        throw new IllegalArgumentException("Additional data of type " + additionalData.getClass() + " is already set");
    }

    private static <U extends AdditionalDataSpec> boolean isCompatible(Class<? extends U> specType, @Nonnull AdditionalData additionalData) {
        DataTypeAndProvider dataTypeAndProvider = ADDITIONAL_DATA_BUILDER_PROVIDERS.get(specType);
        return dataTypeAndProvider != null && dataTypeAndProvider.dataType.isInstance(additionalData);
    }

    private static class DataTypeAndProvider {
        final Class<?> dataType;
        final Function<AdditionalData, AdditionalDataBuilder<? extends AdditionalData>> builderProvider;

        DataTypeAndProvider(Class<?> dataType, Function<AdditionalData, AdditionalDataBuilder<? extends AdditionalData>> builderProvider) {
            this.dataType = dataType;
            this.builderProvider = builderProvider;
        }
    }
}

