/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactsCache;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceRepository;

@Component(role=ProjectArtifactsCache.class)
public class DefaultProjectArtifactsCache
implements ProjectArtifactsCache {
    protected final Map<ProjectArtifactsCache.Key, ProjectArtifactsCache.CacheRecord> cache = new ConcurrentHashMap<ProjectArtifactsCache.Key, ProjectArtifactsCache.CacheRecord>();

    @Override
    public ProjectArtifactsCache.Key createKey(MavenProject project2, Collection<String> scopesToCollect, Collection<String> scopesToResolve, boolean aggregating, RepositorySystemSession session2) {
        return new CacheKey(project2, project2.getRemoteProjectRepositories(), scopesToCollect, scopesToResolve, aggregating, session2);
    }

    @Override
    public ProjectArtifactsCache.CacheRecord get(ProjectArtifactsCache.Key key2) throws LifecycleExecutionException {
        ProjectArtifactsCache.CacheRecord cacheRecord = this.cache.get(key2);
        if (cacheRecord != null && cacheRecord.getException() != null) {
            throw cacheRecord.getException();
        }
        return cacheRecord;
    }

    @Override
    public ProjectArtifactsCache.CacheRecord put(ProjectArtifactsCache.Key key2, Set<Artifact> projectArtifacts) {
        Objects.requireNonNull(projectArtifacts, "projectArtifacts cannot be null");
        this.assertUniqueKey(key2);
        ProjectArtifactsCache.CacheRecord record = new ProjectArtifactsCache.CacheRecord(Collections.unmodifiableSet(new LinkedHashSet<Artifact>(projectArtifacts)));
        this.cache.put(key2, record);
        return record;
    }

    protected void assertUniqueKey(ProjectArtifactsCache.Key key2) {
        if (this.cache.containsKey(key2)) {
            throw new IllegalStateException("Duplicate artifact resolution result for project " + key2);
        }
    }

    @Override
    public ProjectArtifactsCache.CacheRecord put(ProjectArtifactsCache.Key key2, LifecycleExecutionException exception) {
        Objects.requireNonNull(exception, "exception cannot be null");
        this.assertUniqueKey(key2);
        ProjectArtifactsCache.CacheRecord record = new ProjectArtifactsCache.CacheRecord(exception);
        this.cache.put(key2, record);
        return record;
    }

    @Override
    public void flush() {
        this.cache.clear();
    }

    @Override
    public void register(MavenProject project2, ProjectArtifactsCache.Key cacheKey, ProjectArtifactsCache.CacheRecord record) {
    }

    protected static class CacheKey
    implements ProjectArtifactsCache.Key {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final Set<String> dependencyArtifacts;
        private final WorkspaceRepository workspace;
        private final LocalRepository localRepo;
        private final List<RemoteRepository> repositories;
        private final Set<String> collect;
        private final Set<String> resolve;
        private boolean aggregating;
        private final int hashCode;

        public CacheKey(MavenProject project2, List<RemoteRepository> repositories, Collection<String> scopesToCollect, Collection<String> scopesToResolve, boolean aggregating, RepositorySystemSession session2) {
            this.groupId = project2.getGroupId();
            this.artifactId = project2.getArtifactId();
            this.version = project2.getVersion();
            LinkedHashSet<String> deps2 = new LinkedHashSet<String>();
            if (project2.getDependencyArtifacts() != null) {
                for (Artifact dep : project2.getDependencyArtifacts()) {
                    deps2.add(dep.toString());
                }
            }
            this.dependencyArtifacts = Collections.unmodifiableSet(deps2);
            this.workspace = RepositoryUtils.getWorkspace(session2);
            this.localRepo = session2.getLocalRepository();
            this.repositories = new ArrayList<RemoteRepository>(repositories.size());
            for (RemoteRepository repository : repositories) {
                if (repository.isRepositoryManager()) {
                    this.repositories.addAll(repository.getMirroredRepositories());
                    continue;
                }
                this.repositories.add(repository);
            }
            this.collect = scopesToCollect == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(scopesToCollect));
            this.resolve = scopesToResolve == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(scopesToResolve));
            this.aggregating = aggregating;
            int hash2 = 17;
            hash2 = hash2 * 31 + Objects.hashCode(this.groupId);
            hash2 = hash2 * 31 + Objects.hashCode(this.artifactId);
            hash2 = hash2 * 31 + Objects.hashCode(this.version);
            hash2 = hash2 * 31 + Objects.hashCode(this.dependencyArtifacts);
            hash2 = hash2 * 31 + Objects.hashCode(this.workspace);
            hash2 = hash2 * 31 + Objects.hashCode(this.localRepo);
            hash2 = hash2 * 31 + RepositoryUtils.repositoriesHashCode(repositories);
            hash2 = hash2 * 31 + Objects.hashCode(this.collect);
            hash2 = hash2 * 31 + Objects.hashCode(this.resolve);
            this.hashCode = hash2 = hash2 * 31 + Objects.hashCode(aggregating);
        }

        public String toString() {
            return this.groupId + ":" + this.artifactId + ":" + this.version;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version) && Objects.equals(this.dependencyArtifacts, that.dependencyArtifacts) && Objects.equals(this.workspace, that.workspace) && Objects.equals(this.localRepo, that.localRepo) && RepositoryUtils.repositoriesEquals(this.repositories, that.repositories) && Objects.equals(this.collect, that.collect) && Objects.equals(this.resolve, that.resolve) && this.aggregating == that.aggregating;
        }
    }
}

