/*
 * Decompiled with CFR 0.152.
 */
package com.gokgs.client.swing;

import com.gokgs.client.KCChallenge;
import com.gokgs.client.KCProposal;
import com.gokgs.client.swing.KChallengePlayer;
import com.gokgs.client.swing.LitRulesWidget;
import com.gokgs.shared.KGameType;
import com.gokgs.shared.KProposal;
import com.gokgs.shared.KRole;
import java.awt.Component;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import org.igoweb.go.Rules;
import org.igoweb.igoweb.client.CChallenge;
import org.igoweb.igoweb.client.CRoom;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.swing.ChallengePlayer;
import org.igoweb.igoweb.client.swing.ChallengeWindow;
import org.igoweb.igoweb.shared.GameAction;
import org.igoweb.igoweb.shared.GameType;
import org.igoweb.igoweb.shared.Proposal;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.EventListener;

public class KChallengeWindow
extends ChallengeWindow<KProposal.KUserRole<User>, KCProposal> {
    private static final Proposal<?, ?, ?> dummy = null;
    private LitRulesWidget rulesWidget;
    private KCProposal submittedProposal;
    private boolean autoSubmit = true;

    public KChallengeWindow(Client client, CRoom room, Component parent) {
        super(client, room, parent);
    }

    public KChallengeWindow(Client client, KCChallenge chal, Component parent) {
        super(client, chal, parent);
        ((KProposal.KUserRole)((KCProposal)this.getProposal()).getUserRole(true)).setUser(client.getMe());
        if (((KCProposal)chal.getProposal()).getGameType() != KGameType.RENGO) {
            ((KCProposal)this.getProposal()).computeHandicapAndKomi(client.getMe());
        }
        this.updateGui();
    }

    @Override
    protected KCProposal decodeInitialProposal(byte[] propData) throws IOException {
        KCProposal prop;
        try {
            prop = propData == null ? new KCProposal(KGameType.RANKED) : new KCProposal(propData, null);
        }
        catch (Proposal.NoSuchUserException excep) {
            throw new RuntimeException(excep);
        }
        Rules rules = prop.getRules();
        rules.setHandicap(0);
        rules.setKomi(rules.getDefaultKomi());
        prop.setPrivate(false);
        if (prop.getGameType().isRanked() && !this.isUserRankable(this.client.getMe())) {
            prop.setGameType(KGameType.FREE);
        }
        if (prop.getGameType() != KGameType.TEACHING) {
            prop.setUseNigiri(true);
        }
        ((KProposal.KUserRole)prop.getUserRoles().get(0)).setUser(this.client.getMe());
        for (int i = 1; i < prop.getUserRoles().size(); ++i) {
            ((KProposal.KUserRole)prop.getUserRoles().get(i)).setUser(null);
        }
        prop.validate(null, this.client.getMe());
        return prop;
    }

    @Override
    protected JComponent getGameOptionsWidget() {
        if (this.rulesWidget == null) {
            GameType gameType = ((KCProposal)this.getProposal()).getGameType();
            this.rulesWidget = new LitRulesWidget(((KCProposal)this.getProposal()).getRules(), this.isCreator || gameType != KGameType.RENGO && gameType != KGameType.SIMUL);
        }
        return this.rulesWidget;
    }

    private boolean isUserRankable(User u) {
        return u == null || u.canPlayRanked() && u.getRank() <= 39;
    }

    @Override
    protected boolean isExtraWidgetsValid() {
        return this.rulesWidget.verifyInput();
    }

    @Override
    protected void readExtraWidgets() {
        Rules rules = this.rulesWidget.getRules();
        KCProposal prop = (KCProposal)this.getProposal();
        if (prop.isUseNigiri()) {
            rules.setHandicap(0);
            rules.setKomi(rules.getDefaultKomi());
        }
        prop.setRules(rules);
    }

    @Override
    protected KCProposal copyProposal(KCProposal src) {
        return new KCProposal(src);
    }

    @Override
    protected boolean handlePlayerChange(ChallengePlayer<KProposal.KUserRole<User>, KCProposal> cp) {
        KCProposal submission;
        boolean change = super.handlePlayerChange(cp);
        if (cp.getUser() == null) {
            return change;
        }
        KCProposal prop = (KCProposal)this.getProposal();
        if (!cp.getUser().canPlayRanked() && prop.getGameType().isRanked()) {
            prop.setGameType(KGameType.FREE);
            change = true;
        }
        if ((submission = (KCProposal)this.getChallenge().getSubmission(cp.getUser().name)) != null) {
            if (prop.getGameType() == KGameType.SIMUL) {
                KProposal.KUserRole subUr = (KProposal.KUserRole)submission.getUserRole(true);
                if (subUr.getUser() == cp.getUser()) {
                    KProposal.KUserRole propUr = (KProposal.KUserRole)prop.getUserRole(cp.playerNum);
                    propUr.setHandicap(subUr.getHandicap());
                    propUr.setKomi(subUr.getKomi());
                }
                KCProposal expected = new KCProposal(prop);
                expected.computeHandicapAndKomi(cp.getUser());
            } else if (prop.getGameType() != KGameType.RENGO) {
                prop.getRules().setHandicap(submission.getRules().getHandicap());
                prop.getRules().setKomi(submission.getRules().getKomi());
                ((KProposal.KUserRole)prop.getUserRole(false)).setRole(((KProposal.KUserRole)submission.getUserRole(false)).getRole());
                ((KProposal.KUserRole)prop.getUserRole(true)).setRole(((KProposal.KUserRole)submission.getUserRole(true)).getRole());
                prop.setUseNigiri(submission.isUseNigiri());
                KCProposal expected = new KCProposal(prop);
                expected.computeHandicapAndKomi(null);
                if ((float)expected.getRules().getHandicap() == 0.0f && expected.getRules().getKomi() != 0.5f) {
                    expected.setUseNigiri(prop.isUseNigiri());
                }
                change = true;
            }
        }
        return change;
    }

    @Override
    protected void handleRoleChange(ChallengePlayer<KProposal.KUserRole<User>, KCProposal> cp) {
        KCProposal proposal = (KCProposal)this.getProposal();
        List userRoles = proposal.getUserRoles();
        if (((KProposal.KUserRole)userRoles.get(0)).getRole() == KRole.WHITE) {
            if (proposal.isUseNigiri()) {
                proposal.setUseNigiri(false);
                this.updateGui();
                return;
            }
        } else {
            proposal.setUseNigiri(true);
        }
        for (int i = 0; i < userRoles.size(); ++i) {
            KRole newRole;
            KProposal.KUserRole ur = (KProposal.KUserRole)userRoles.get(i);
            switch (ur.getRole().id) {
                case 2: {
                    newRole = KRole.BLACK;
                    break;
                }
                case 3: {
                    newRole = KRole.BLACK_2;
                    break;
                }
                case 4: {
                    newRole = KRole.WHITE;
                    break;
                }
                case 5: {
                    newRole = KRole.WHITE_2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad role: " + ur.getRole());
                }
            }
            ((KProposal.KUserRole)userRoles.get(i)).setRole(newRole);
        }
        this.updateGui();
    }

    @Override
    protected void updateGameTypeList() {
        int i;
        KCProposal proposal = (KCProposal)this.getProposal();
        KCProposal initProp = (KCProposal)this.getInitialProposal();
        boolean unrankableUser = false;
        for (i = proposal.getUserRoles().size() - 1; i >= 0; --i) {
            if (this.isUserRankable((User)((KProposal.KUserRole)proposal.getUserRole(i)).getUser())) continue;
            unrankableUser = true;
            break;
        }
        for (i = 0; i < 11; ++i) {
            GameType gt = GameType.get(i);
            boolean isOk = false;
            switch (i) {
                case 1: {
                    isOk = this.getAction() == GameAction.CHALLENGE_CREATE;
                    break;
                }
                case 5: 
                case 6: {
                    if (this.getAction() != GameAction.CHALLENGE_CREATE && initProp.getGameType() != gt) break;
                    isOk = true;
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    if (this.getAction() != GameAction.CHALLENGE_CREATE && initProp.getGameType() != KGameType.TEACHING && initProp.getGameType() != KGameType.FREE && initProp.getGameType() != KGameType.RANKED || gt == KGameType.RANKED && this.room != null && (unrankableUser || this.room.isPrivate() || this.isPrivateSelected())) break;
                    isOk = true;
                    break;
                }
            }
            this.setGameTypeVisibility(gt, isOk);
        }
    }

    @Override
    protected CChallenge<KCProposal> castChallenge(CChallenge<?> chal) {
        return (KCChallenge)chal;
    }

    @Override
    protected void doUpdateGui() {
        super.doUpdateGui();
        GameAction action = this.getAction();
        boolean rulesEnabled = false;
        boolean hcapEnabled = false;
        boolean blitzBlink = false;
        KCProposal prop = (KCProposal)this.getProposal();
        this.rulesWidget.setRules(prop.getRules());
        this.rulesWidget.setUseNigiri(prop.isUseNigiri());
        GameType gameType = prop.getGameType();
        switch (action == null ? -1 : action.id) {
            case 3: {
                rulesEnabled = true;
                hcapEnabled = gameType == KGameType.DEMONSTRATION;
                break;
            }
            case 4: {
                if (!this.isChangeableSetup()) break;
                rulesEnabled = true;
                hcapEnabled = gameType != KGameType.SIMUL && prop.isComplete();
                break;
            }
            case 6: {
                hcapEnabled = rulesEnabled = this.isCreator;
                if (!prop.equals(this.submittedProposal) || !this.autoSubmit) break;
                this.autoSubmit = false;
                this.getChallenge().sendProposal(CChallenge.ACCEPT, prop);
                this.sync();
                break;
            }
            case -1: {
                blitzBlink = true;
                hcapEnabled = !this.isCreator && ((KCProposal)this.getProposal()).getGameType() != KGameType.RENGO && ((KCProposal)this.getProposal()).getGameType() != KGameType.SIMUL;
                break;
            }
        }
        this.rulesWidget.setRulesEditable(rulesEnabled);
        this.rulesWidget.setHcapEditable(hcapEnabled);
        this.rulesWidget.setBlinkBlitz(blitzBlink);
    }

    protected KChallengePlayer buildChallengePlayer(EventListener listener, KCProposal proposal, int playerNum) {
        return new KChallengePlayer(this.client, listener, this.isCreator, proposal, playerNum, this.getChallenge());
    }

    @Override
    protected boolean isChallengePlayerRebuildNeeded() {
        return ((KCProposal)this.getProposal()).getGameType() == KGameType.SIMUL != (this.getNumChallengePlayers() > 1 && ((KChallengePlayer)this.getChallengePlayer(1)).isSimul());
    }

    @Override
    protected void handleNewProposal(KCProposal rawNewProposal) {
        KCProposal newProposal = rawNewProposal;
        this.rulesWidget.setRules(newProposal.getRules());
        super.handleNewProposal(newProposal);
    }

    @Override
    protected void handleDeclineFromServer() {
        if (((KCProposal)this.getChallenge().getProposal()).getGameType() != KGameType.RENGO) {
            ((KProposal.KUserRole)((KCProposal)this.getProposal()).getUserRole(true)).setUser(this.client.getMe());
            ((KCProposal)this.getProposal()).computeHandicapAndKomi(this.client.getMe());
        }
        super.handleDeclineFromServer();
    }

    @Override
    protected void highlightChanges(KCProposal rawExpected, int cpNum) {
        KCProposal expected = rawExpected;
        super.highlightChanges(expected, cpNum);
        this.rulesWidget.highlightChanges(expected == null ? null : expected.getRules());
    }
}

