<?php
//------------------------------------------------------------------------
// m_headlines.php - display RSS headlines
//
// 
//------------------------------------------------------------------------
$GLOBALS['rss_title'] = false;
$GLOBALS['rss_link']  = false;
$GLOBALS['rss_description'] = false;
$GLOBALS['rss_titletext'] = null;
$GLOBALS['rss_linktext'] = null;
$GLOBALS['rss_desctext'] = null;



$currentTag = "";



//-----------------------------------------------------
//rss_start_element
//
// handle processing the start element <element>
//-----------------------------------------------------
function rss_start_element($parser, $name, $attrs)
{

	switch( $name )
	{
		case 'TITLE':
			$GLOBALS['rss_title'] = true;
			break;
		case 'LINK':
			$GLOBALS['rss_link'] = true;
			break;
	
	}   
}



//-----------------------------------------------------
//rss_end_element
//
// handle the processing when the end element is 
// reached </element>
//-----------------------------------------------------
function rss_end_element($parser, $name)
{
	
	switch( $name )
	{
		case 'LINK':
			print('<font class=\'fine\'><a href="' . $GLOBALS['rss_linktext'] . '">' . $GLOBALS['rss_titletext'] . '</a><br></font>');
			$GLOBALS['rss_title'] = false;
			$GLOBALS['rss_titletext'] = '';
			$GLOBALS['rss_link'] = false;
			$GLOBALS['rss_linktext'] = '';
			break;
	
	}
}
			

//-----------------------------------------------------
//rss_char_data
//
// handle the data between elements 
// <element>some character data here</element>
//-----------------------------------------------------
function rss_char_data($parser, $data)
{
	
	if( $GLOBALS['rss_title'] == true && $GLOBALS['rss_titletext'] == '' )
	{
		$GLOBALS['rss_titletext'] = $data;
	}
	else if( $GLOBALS['rss_link'] == true )
	{
		$GLOBALS['rss_linktext'] = $data;
	}

  
}

//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------


$rss_feeds = array( 'slashdot' => 'http://www.slashdot.org/slashdot.rss',
					'technology review' => 'http://www.techreview.com/newsfeed/rss/trrd_newsfeed.xml' );

$feed_names = array_keys( $rss_feeds );



drawMenuTop('RSS Feeds');

foreach( $feed_names as $feed )
{
	$cached_xml = 'engine/shards/xmlcache/' . $feed . '.xml';
	$filestats = @stat( $cached_xml );
	//
	// 1800 seconds is 30 minutes.  If the file doesn't exist or
	// if it older than 30 minutes we are allowed to seek slashdot.org
	// for a refresh.  Otherwise use the local copy of slashdot.xml.
	//	
	if( ($filestats == FALSE) || ($filestats[9] < time() - 1800) )
	{
		$feedhandle = fopen( $rss_feeds[$feed] , "r" );
		$localfeed = fopen( $cached_xml , "w" );
			if( $feedhandle != FALSE )
			{
				while( $data = fread($feedhandle, 4096 ) )
				{
					fwrite( $localfeed, $data );
				}
				fclose( $feedhandle );
			}
			fclose( $localfeed );
		}
		
		$feedhandle = fopen( $cached_xml , "r" );
		
		if( $feedhandle != FALSE )
		{	
			$xparser = xml_parser_create();
			xml_set_element_handler($xparser, "rss_start_element","rss_end_element");
			xml_set_character_data_handler($xparser, "rss_char_data" );
			while( $data = fread( $feedhandle, 4096 ) )
			{
					if( !xml_parse( $xparser, $data, feof($feedhandle)))
					{
							die( "some crazy xml parsing error" );
					}
			}
			xml_parser_free( $xparser );
 		}
		else
		{
				print("<font class='fine'>failed to open feed</font>");
		}
          
		print('<br>');

	
}//foreach



drawMenuBottom();


?>
