/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionSimple;

public class SettingsPort
implements Serializable {
    public final int nativePort;
    public final int thriftPort;
    public final int jmxPort;

    public SettingsPort(PortOptions options) {
        this.nativePort = Integer.parseInt(options.nativePort.value());
        this.thriftPort = Integer.parseInt(options.thriftPort.value());
        this.jmxPort = Integer.parseInt(options.jmxPort.value());
    }

    public static SettingsPort get(Map<String, String[]> clArgs) {
        String[] params = clArgs.remove("-port");
        if (params == null) {
            return new SettingsPort(new PortOptions());
        }
        PortOptions options = (PortOptions)GroupedOptions.select((String[])params, (GroupedOptions[])new PortOptions[]{new PortOptions()});
        if (options == null) {
            SettingsPort.printHelp();
            System.out.println("Invalid -port options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsPort(options);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-port", new PortOptions());
    }

    public static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsPort.printHelp();
            }
        };
    }

    private static final class PortOptions
    extends GroupedOptions {
        final OptionSimple nativePort = new OptionSimple("native=", "[0-9]+", "9042", "Use this port for the Cassandra native protocol", false);
        final OptionSimple thriftPort = new OptionSimple("thrift=", "[0-9]+", "9160", "Use this port for the thrift protocol", false);
        final OptionSimple jmxPort = new OptionSimple("jmx=", "[0-9]+", "7199", "Use this port for retrieving statistics over jmx", false);

        private PortOptions() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.nativePort, this.thriftPort, this.jmxPort);
        }
    }
}

