/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import com.google.common.base.Function;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionMulti;
import org.apache.cassandra.stress.settings.OptionSimple;

class OptionCompaction
extends OptionMulti {
    private final OptionSimple strategy = new OptionSimple("strategy=", new StrategyAdapter(), null, "The compaction strategy to use", false);

    public OptionCompaction() {
        super("compaction", "Define the compaction strategy and any parameters", true);
    }

    public String getStrategy() {
        return this.strategy.value();
    }

    public Map<String, String> getOptions() {
        return this.extraOptions();
    }

    @Override
    protected List<? extends Option> options() {
        return Arrays.asList(this.strategy);
    }

    @Override
    public boolean happy() {
        return true;
    }

    private static final class StrategyAdapter
    implements Function<String, String> {
        private StrategyAdapter() {
        }

        public String apply(String name) {
            try {
                CFMetaData.createCompactionStrategy((String)name);
            }
            catch (ConfigurationException e) {
                throw new IllegalArgumentException("Invalid compaction strategy: " + name);
            }
            return name;
        }
    }
}

