/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.InetAddress;
import java.util.Map;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HintedHandoffMetrics {
    private static final Logger logger = LoggerFactory.getLogger(HintedHandoffMetrics.class);
    private static final MetricNameFactory factory = new DefaultNameFactory("HintedHandOffManager");
    private final LoadingCache<InetAddress, DifferencingCounter> notStored = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<InetAddress, DifferencingCounter>(){

        public DifferencingCounter load(InetAddress address) {
            return new DifferencingCounter(address);
        }
    });
    private final LoadingCache<InetAddress, Counter> createdHintCounts = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<InetAddress, Counter>(){

        public Counter load(InetAddress address) {
            return CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("Hints_created-" + address.getHostAddress().replace(':', '.')));
        }
    });

    public void incrCreatedHints(InetAddress address) {
        ((Counter)this.createdHintCounts.getUnchecked((Object)address)).inc();
    }

    public void incrPastWindow(InetAddress address) {
        ((DifferencingCounter)this.notStored.getUnchecked((Object)address)).mark();
    }

    public void log() {
        for (Map.Entry entry : this.notStored.asMap().entrySet()) {
            long difference = ((DifferencingCounter)entry.getValue()).difference();
            if (difference == 0L) continue;
            logger.warn("{} has {} dropped hints, because node is down past configured hint window.", entry.getKey(), (Object)difference);
            SystemKeyspace.updateHintsDropped((InetAddress)entry.getKey(), UUIDGen.getTimeUUID(), (int)difference);
        }
    }

    public static class DifferencingCounter {
        private final Counter meter;
        private long reported = 0L;

        public DifferencingCounter(InetAddress address) {
            this.meter = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("Hints_not_stored-" + address.getHostAddress().replace(':', '.')));
        }

        public long difference() {
            long current = this.meter.getCount();
            long difference = current - this.reported;
            this.reported = current;
            return difference;
        }

        public long count() {
            return this.meter.getCount();
        }

        public void mark() {
            this.meter.inc();
        }
    }
}

