/*
* MyGoGrinder - a program to practice Go problems
* Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
* Copyright (C) Ruediger Klehn (2015)
*   RuediRf@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder.sgf;

import java.io.*;
import java.util.*;
import javax.swing.*;
import java.awt.Toolkit;

import GoGrinder.ui.*;
import GoGrinder.*;

/**
 *
 * @author  tkington
 * @author  Ruediger Klehn
 */
 
/*
//    static void parseTags(String s, TagListener node) throws SGFParseException {
//    static StringPair grabToken(String s) throws SGFParseException {
//    public static SGFNode parseNode(String sgf, SGFNode parent) throws SGFParseException {
//    private static String trimComments(String sgf) throws SGFParseException {
//->    public static ArrayList parse(String sgf) throws SGFParseException {
//    public static void split(File dir, String sgf) throws SGFParseException {
//...    static class StringPair {
//         StringPair(String a, String b) {
*/

public class SGFParser {
    // public static int validCountBad = 0; // ? a better name ? e.g. sgfCountBad + sgfCountGood
    //public static int validCountTotal = 0;
    // private static boolean sgfEdited = false;
    private static boolean validSGFBegin = false;
    private static boolean validSGFEnd = false;
    private static String parserMsg = "";
//    private static String thisFileMsg = ""; // this for dbg messages
    public static String thisFileName = ""; // this for just the PATH/FILE
    public static boolean VALIDATING = false;

    public static boolean checkingSGF = false;
    static final String NL = Main.NEW_LINE;
    private static String actSGF = "";
    public static String currCodePartA = ""; // this is just for the error message  SGFParser.currCodePartA
    public static String currCodePartB = ""; // this is just for the error message  SGFParser.currCodePartB NOT YET
    public static int sgfValiSZ = 0; // we need to have the right board size for the current parse string
    public static int sgfSZ = 0;     // I don't know, how to do it better
    public static int wgfSZ = 0;
// public static int branchDeepth = 0;
// public static int nodeCount = 0;
    //public static String theCurrCode = ""; // we want to give the user a hint where to look for wrong code
    //public static int theCurrPosition = 0; // but I fear, the code becomes slower
    // "The error is seemingly connected to this code example; ..."
    
    // when the sgf-controller sends us here, then VALIDATING = false (default)
    
    // gets a node and works through the identifiers and values // is used by Node and Reason (and Reason is a wgf-thing)
// ############ PARSE_TAGS #########################################################
    static void parseTags(String s, TagListener node) throws SGFParseException { // TagListener should be PropertyListener
     // gets a node "s" (as defined in the sgf standard) without ";" or "(" / ")"  
     //   and gives back a list of propIDs and values
     // e.g. AB - cd ce cf; AW - ee ef eg; C - This is good; B - cd; W - bd; and so on
                                         // parseTags() is also used for the wgf parsing
        
        boolean inBrackets = false; // [...]
 //d.b.g(thisFileName + "\n" + s);
        while(true) { // we have here a node "s" without ";" or "(" / ")" 
            s = s.trim();
            if(s.length() == 0)
                return;
            int i = 0;
            // while(i < s.length() && !s.charAt(i)=='['){}//isWhiteSpace
            // read in, including whitespace between ID-letters
            while(i < s.length() && ( Character.isLetter(s.charAt(i)) || Character.isWhitespace(s.charAt(i)) ) ){
                          // could be: add all chars until "[" - work with this is done separately
                          // upper/lowercase is equal, as working on the parameter-ID does Node or so
                i++; 
            } // now there should be a "["
            if(i == 0 && s.charAt(i)==']'){ // error 
              // There are several places, where text or simpletext is allowed and unescaped special
              // characters ( "]", "\" ) can occure. Reasons are most times bugs in sgf-editors.
              parserMsg = "A \"]\" too much (is it inside a label, comment or similar and not escaped?" + NL
                        + "Escaped means: \"\\]\" ) - possibly easy to repair." + NL 
                        + Messages.getString("illegal_token") + " > " + s.charAt(i) + " <";
              throw new SGFParseException(parserMsg, s);
            } // end error
            else if(i == 0 && !Character.isLetter(s.charAt(i) )){
              parserMsg = "Invalid character outside \"[...]\" - reason is possibly a not escaped \"]\" in a "
                        + "label, comment or similar." + NL
                        + "Another possible cause: White Space (new line, tab or space), where they are" + NL
                        + "not expected.";
              if (SGFLog.logLevel > 1)s = "At or before character position: " + new Integer(i).toString() + " of code:" + NL 
                                         + s;
              throw new SGFParseException(parserMsg, s);
            }
            String propID = s.substring(0, i); // here still including whitespace
            propID = purgeWhiteSpaceReplaceFF3(propID); // if e.g. propID is "AddBlack" or "A B" (or a line break instead of space)
// d.b.g(propID);
            ArrayList propVals = new ArrayList(); // ArrayList<String> // propVals takes the value/values for propID (e.g. AB[ce][cf][cg]
            while(i < s.length() && s.charAt(i) == '[') { // here we read out the property values ()
                inBrackets = true; // [ inside! ]
                i++; 
                String val = ""; //$NON-NLS-1$
                int bdepth = 1;
                while(true) { // all following, including "\]" be added to val until "]"
                              //### if removing "\" - what if later writing file? - we remove it before filling the text area
                    char c = s.charAt(i);
                    if(!inBrackets && c == '['){ // we will come here when a property has more than 1 value, e.g. AW[de][df]...
                        bdepth++;                // LB[cd:!][ce:?]...
                        inBrackets = true;
                    }
                    else if(c == '\\'){
                      val += s.charAt(i);
                      i++;
                      //  val+=/i++ - this not 2 times?? - and then "continue"?
                      c = s.charAt(i);
                    } // we need to look for escaped closing brackets "\]"
                      // if property is "C", "LB", ..., we have some rules for "\x"
                      // we must not throw these "\" out
                      // it is not the job of the parser to filter these escape characters out; 
                      //   the text displayer ( C[:-\] ] ) or sgf/board controller ( lb[ef:g\\b] ) should do this
                     
                    else if(c == ']') { // need to i++? NO!!
                        inBrackets = false;
                        bdepth--;
                        if(bdepth == 0)
                            break;
                    }
                    val += c;
                    i++;
                } // [ inside! ]

                val = handleWhitespace(propID, val);
                propVals.add(val); //ArrayList<String>
                if(i >= s.length() || s.charAt(i) != ']'){ // i >= s.length() - how can that happen?
                  parserMsg = "parseTags() - I don't know: " + s + " how could that happen?";
                  // possibly, when the closing "]" is missing
                  throw new SGFParseException(parserMsg, s); 
                }
                i++;

                while(i < s.length() && Character.isWhitespace(s.charAt(i)))
                	i++;
            } // read out the property values

            // at this place we need to check, if SZ is known - or find it out first
 //d.b.g(Node.szIsSet + " = szIsSet in sgfparser - 1");
            if (!Node.szIsSet) {
              String sNoWS = removeWhiteSpace(s); // StringNoWhiteSpace
              int posSZ = sNoWS.indexOf("SZ[");
              if (posSZ == -1) {
                Node.currMainBranchSZ = 19;
              }
              else {
                int stop = sNoWS.indexOf("]",posSZ);
                String numStr = sNoWS.substring(posSZ + 3, stop);
                if (numStr.indexOf(":") != -1){ // SZ[3:9] = 3x9-board; MultiGo allows this - and some other programs also
                  parserMsg = "Still only quadratic boards possible! (found \":\" in the size value: > " + numStr + " < )";
                  SGFLog.errorType = 3;
                  throw new SGFParseException(parserMsg, s);
                }
                try {
                  Node.currMainBranchSZ = Integer.valueOf(numStr);
                }
                catch (NumberFormatException e){
                  parserMsg = "Not enough number for me: " + numStr;
                   throw new SGFParseException(parserMsg, s);
                }
                if (Node.currMainBranchSZ > 19){ // we don't expect the boarsize to be 1
                  parserMsg = "Board size too big: " + Node.currMainBranchSZ 
                            + " - at the moment not bigger than 19x19 (and quadratic)!";
                  SGFLog.errorType = 3;
                  throw new SGFParseException(parserMsg, s);
                }
              }
              Node.szIsSet = true;

// d.b.g(Node.currMainBranchSZ, " in sgfparser - 2");
// d.b.g(Node.szIsSet + " = szIsSet in sgfparser - 3");
  //d.b.g(Node.currMainBranchSZ);
            }
            node.addTag(propID, propVals); // at this place we needn't care about the validity of the values!
        		//} 
        		//catch(Exception ex){
        		//  throw new SGFParseException("I don't know...: " + NL + thisFileName 
        		//                             + NL + " unknown problem: node.addTag(tag, propVals), ArrayList, unknown source", s);
              //GoGrinder.ExceptionHandler.logCommonProblem(ex, thisFileName + NL + " node.addTag(tag, propVals)");
        		//}

            s = s.substring(i);
        }
    } // end parseTags

 // ############ REMOVE_WHITE_SPACE #######################################################
    static String removeWhiteSpace (String strWithWhiteSpace){
 //d.b.g(" 6 " + strWithWhiteSpace);
      String returnString = "";
      for (int i=0;i<strWithWhiteSpace.length();i++){
        if (Character.isWhitespace(strWithWhiteSpace.charAt(i)))continue;
        else returnString += "" + strWithWhiteSpace.charAt(i);
      }
 //d.b.g(" 7 " + returnString);
      return returnString;
    }

 // ############ PURGE_WHITE_SPACE_REPLACE_FF3 #######################################################
    // throw out WhiteSpace and lower case letters of FF3
    static String purgeWhiteSpaceReplaceFF3(String propID){ //propID = tag // AddBlack, SiZe etc. are SGF FF[3]
 //d.b.g(" 8 " + propID);
      propID = propID.trim();
      String returnID = "";
      for (int i=0; i<propID.length(); i++){
        if (Character.isUpperCase(propID.charAt(i)) ){
          returnID += propID.charAt(i);
        }
      }  // this doesn't allow to give a warning about difficulties with the file in another program;
         // on export best would be to rebuild the sgf (or only the known property/values?)
     return returnID; //d.b.g(returnID);
    }

 // ############ HANDLE_WHITESPACE #######################################################
    static String handleWhitespace(String propID, String propValue){
// d.b.g (SGFParser.thisFileName + NL + " propID = " + propID + " - propValue = >" + propValue + "<"); // (in vals isn't filtered here)
      String returnValue = "";
      String textSimpleTextPropIDs = "AP C DI N SO US"; // just some IDs, which are (or will be) handled in the prg;
       // APplication, ChAracter encoding, Comment, DIrected, Nodename, SOurce, USer 
      String someNoWSValueIDs = "CR CH CO UC CA MN LN"; // CiRcle, CHeckmark, UnClear, ChAracterset, setMoveNumber, LiNe
      if (someNoWSValueIDs.indexOf(propID) > -1){ // no WhiteSpace values 
          if (textSimpleTextPropIDs.indexOf(propID) > -1){return propValue;}// d.b.g(propValue);
      }
      if (propValue.indexOf(":") != -1){ // if we have e.g. LB[ c d: XX ] (or line breaks instead of spaces) 
                                         // oh - what if LB[de:a b] - is thought of (some lines below)
// d.b.g (SGFParser.thisFileName + NL + " propID = " + propID + " - propValue m.\":\" = >" + propValue + "<"); // (in vals isn't filtered here)
        String[] splitValue = propValue.split(":", 2);
        for (int i=0; i<splitValue[0].length();i++){
          if (!Character.isWhitespace(splitValue[0].charAt(i)) ){
            returnValue += splitValue[0].charAt(i);
          }
        }
        returnValue += ":" + splitValue[1]; // I wanted to trim the splitValue[1] (....trim() ) - but that collides with valid space as label
        return returnValue;
      }
      // all values !text and !simpleText without ":" in it
// d.b.g (SGFParser.thisFileName + NL + " propID = " + propID + " - propValue no \":\" = >" + propValue + "<"); // (in vals isn't filtered here)
      for (int i=0; i<propValue.length();i++){ 
        if (!Character.isWhitespace(propValue.charAt(i)) ){
          returnValue += propValue.charAt(i);
        }
      } // if there is a label LB without ":" for dividing point from 
        // String, it is too seldom and an old program's bug (which program?)
      return returnValue;
    }
    
 // ################### GRAB_TOKEN #############################################################
    // takes a string and returns a string pair: the first token encountered and the rest of the string
    // we have to watch for crap like AW[dg][hg] too, (is this standard Smart Game Format?) ... yes, it is! Rue
    // this is only used by the sgf part
    static StringPair grabToken(String s) throws SGFParseException { // takes the sgf code and splits, when a new variation begins
    //  (this begins with getting the complete code - also of a multi-problem file)
    // token is meant as one part of the code, beginning with "(" (beginning of 
    //    game or var.) and ending with ")" of the act.probl. or var. // this needs to count up/down outside "[...]"!
    //  or beginning with ";" and ending before ")" of the current problem or variation)
    //  or beginning behind ";" and ending with the last value of that node (includ."]")
    //  with a multi problem file, this goes through all problems of that file"
//d.b.g(thisFileName, s);
        int i; // called several times from parse() and parseNode()
        s = s.trim();
        String token = ""; //$NON-NLS-1$
        String parserMsg = "";
        int start = 0, end = 0;
 //d.b.g(">" + s + "<");
        boolean inBrackets = false; // "[...]"
        // if (dpth == 0); // #################### every if has it's own dpth
        if (s.charAt(0) == '(') { // here we count up/down the deepth of (;...(;...)) (a branch) // for ";" -> some lines down (else if)
        // 1 = main branch - oh! NO!! // next char !! MUST BE !! ";" !!
          if (!s.substring(1, s.length()).trim().startsWith(";") ){
            parserMsg = "Branch (or subbranch) doesn't begin with \"(;\" - we would accept WhiteSpace between \"(\" and \";\".";
            throw new SGFParseException(parserMsg, s);
          }
            // gotta find matching parenthesis // but they must not be inside [...]
            int dpth = 1; // "(...(...))"
            start = 1;
            for (i=1;i<s.length();i++) { // why no check for ";" after "(" ??
                if (s.charAt(i) == '[') {// find matching bracket or throw // ignore until "]" but should ignore "\]"
                    inBrackets = true; // "[...]"
                    int bdepth = 1; // "[...]", should never be 2, so true/false should be enough
                    while(true) { // looks only for "[", "\", "]"
                        if(!inBrackets && s.charAt(i) == '['){
                            // here we look for more values for param: LB[], AW[], etc. can have more values
                            inBrackets = true; // "[...]"
                            bdepth++;
                        }
                        else if(s.charAt(i) == '\\'){ // we need to look for escape characters "\" 
                          i++;// i++; 
                          //continue; // what, if next is [ - shouldn't be of interest!
                        }
                        else if(s.charAt(i) == ']') {
                            bdepth--;
                            inBrackets = false; // "[...]"
                  if (bdepth<0); //code error
                  else if (bdepth>0); // also code error
                            break;
                        }
                        i++;
                        if(i >= s.length()){ // testfile konstruieren!!
                          parserMsg = "Escape character(\"\\\") in \"[...]\" not used for escaping?";
                          throw new SGFParseException(parserMsg, s);
                        }
                    } // handle current char
                } // if(s.charAt(i) == '[')
                if (s.charAt(i) == '(') {dpth++;}//branchDeepth++ ;
                if (s.charAt(i) == ')') {dpth--;}// branchDeepth-- ;
                if (dpth == 0) // here its possible, that in a multi problem file the second problem begins
                    break;
            } // for...s.length(i)
            if (dpth != 0){ // how can we come here? - oh, if the string loop ended before the matching outer ")"
              parserMsg = "Error in SGF code: different number" 
                        + " of \"(\" / \")\" ";
 throw new SGFParseException(parserMsg, s);
            }
            end = i;
        }
        else if (s.charAt(0) == ';') { // beginning of a node
            int dpth = 0;
            start = 1;
            for (i=1;i<s.length();i++) {
                if (s.charAt(i) == '[') {// now find matching bracket or throw
                    inBrackets = true;
                    int bdepth = 1;
                    while(true) {
                        if(!inBrackets && s.charAt(i) == '['){
                            inBrackets = true;
                            bdepth++;
                        }
                        else if(s.charAt(i) == ']') {
                            inBrackets = false;
                            bdepth--;
                            break;
                        }
                        else if(s.charAt(i) == '\\'){
                          i++;
                        }
                        i++;
                    }
                }
                if ((s.charAt(i) == '(' || s.charAt(i) == ';')) // next branch or node
                    break;
            }
            if (dpth != 0){
              parserMsg = "grabToken()1 - I don't know: > " + s + " <(" + Messages.getString("illegal_sem_token") + ")"; 
 throw new SGFParseException(parserMsg, s);
            }
            end = i;
        }
        else {
          parserMsg = "I don't know: > " + s + " <  <<< anywhere there ... " + NL
                    + "is a problem - uneven number of \"(;\" / \")\" ?" + NL
                    + "(" + Messages.getString("illegal_start_of_token")+ " > " + s.charAt(0) + " < " 
                    + Messages.getString("in") + " SGF" + ")";
 throw new SGFParseException(parserMsg, s);
        }
        token = s.substring(start, end);
        token = token.trim();
        s = s.substring(end, s.length());
        s = s.trim();
        if (s.length() > 0 && s.charAt(0) == ')')
            s = s.substring(1);
         return new StringPair(token, s);
    }
 
 // ################### PARSE_NODE ####################################################
    public static SGFNode parseNode(String sgf, SGFNode parent) throws SGFParseException { 
    // this is more of grab a main branch
        StringPair tokPair = grabToken(sgf);
//d.b.g("parseNode", currCodePartA, currCodePartB);
        SGFNode node = new SGFNode(tokPair.a, parent);
        if (tokPair.b.length() > 0) {
            if (tokPair.b.charAt(0) == ';')
                node.addChild(parseNode(tokPair.b, node));
            else {
                while (tokPair.b.length() > 0) {
                    tokPair = grabToken(tokPair.b);
                    node.addChild(parseNode(tokPair.a, node));
                }
            }
        }
        return node;
    }
    
 // ################### TRIM_COMMENTS ####################################################
    // checks for valid beginning of SGF code: "(;", searches suspected end of sgf code ")" and cuts
    //   off leading and trailing characters, so e.g. "xyz ( ;...) xyz" is cut down to "( ;...)"
    private static String trimComments(String sgf) throws SGFParseException {
        int i = 0;
        validSGFBegin = false;
        validSGFEnd = false;

        outer:
        for(i = 0; i < sgf.length(); i++) {
            if(sgf.charAt(i) == '(') { // then we search for ";"
                for(int j = i + 1; j < sgf.length(); j++) {
                    char c = sgf.charAt(j);
                    if(c == ';'){ // nice, >(...;< is our accepted beginning of the sgf code (at >...< only whitespace is allowed)
                        validSGFBegin = true;
                        sgf = sgf.substring(i); // cuts off leading characters before "(;"
                        break outer; // we're happy and end looping
                    } // ah! learned: break = don't go once more through the loop
                    if(!Character.isWhitespace(c)) // any other character
                        continue outer; // "(" was not the beginning of the sgf code; continue outer loop for next "(" - don't reset i
                } // and learned: continue LABEL = continue outside the loop (keeps iterator, when declared before the loop?)
            }
        }
        
        // and now cut off non-sgf characters at suspected end of sgf code
        int k = sgf.lastIndexOf(")"); if (k == -1){return sgf;} // validSGFEnd is still false
        sgf = sgf.substring(0,k+1); validSGFEnd = true;
        return sgf;
    }
    
 // ################### PARSE ####################################################
    public static ArrayList parse(String completeSGF) throws SGFParseException { // ArrayList<SGFNode>
        //checkingSGF // we set and reset this to false in SGCController and validator, its just because of the filename: 
                            // in SGFParseExc. checkingSGF decides the name string for the log file (false = WGF file)
        Node.currMainBranchSZ = 0;
        Node.szIsSet = false;
        String sgf = completeSGF;
        SGFLog.alreadyReported = false; // this is against a repeated message and logging of a bypassed sgf-code error
         // possibly needed (after validate) to parse the current sgf new in ProbFrame (for SZ to be up to date)
        if (VALIDATING) {
          thisFileName = Validator.currValidatorFile;
        }
        else { // and when parsing a wgf? (is used in Node, SGFLog, SGFUtils and SGFParser, but mostly for d.b.g()
          thisFileName = SGFController.currFile; // only in SGFLog it is used for logging, but there we have the other 
        }                                        // choice ...WGFController.thisWGFFileStr
         // thisFileMsg = "Current file: " + NL + "\"" + thisFileName + "\"" + NL;
        
        String reason = "";
        String codeExample = "";
        String useDef = "Using default code."; // obsolete?
        

        
        if (sgf == null){ // possibly this never happens, as in ProbData.getSGF() a StringBuffer.toString()
          parserMsg = "No valid content: null";          // is done to get this (String)sgf
          sgf = ""; // else I have to handle null
          throw new SGFParseException(parserMsg, sgf);
        } //                                  sgf, sgf: I work with codeExample in the error message
          
        sgf = sgf.trim();
        if (sgf.length() < 3){
          completeSGF = completeSGF.trim();
          codeExample = "> " + completeSGF + " <" + NL; // the line reader in ProbData is coded to add NL (\r\n) to every read line
          parserMsg = "Too small for a valid SGF file: " + Integer.toString(sgf.length()) + " bytes";// + toString(size);
          // "(;)" would be smallest valid sgf: empty root node
          throw new SGFParseException(parserMsg, codeExample);
        }
        if (sgf.length() < 9){
          completeSGF = completeSGF.trim();
          codeExample = "> " + completeSGF + " <" + NL;
          parserMsg = "Too small for making sense: " + Integer.toString(sgf.length()) + " bytes"; // + toString(size);
          throw new SGFParseException(parserMsg, codeExample);
           // "(;C[])" root node with empty Comment: 6 char.
           // "(;AB[dc])" just one setup stone in the root node, 9 char.
           // "(;;B[jj])" empty root node, empty board, one move on tengen
           //  and: GG doesn't like files without stones
        }

  // maybe first check, if the structure of the file is ok? 
  // then set missing parameters (e.g. SZ) to defaults
       
        sgf = trimComments(sgf); // unlucky name, as trimComments removes leading and trailing non-sgf characters
                                 // incl. mail headers, but first checks for valid begin and end of the code: "(;" + ")"
        if (!validSGFBegin) { // (found out in trimComments()) this is just for the error message; is this easy to repair? -> editor
          completeSGF = completeSGF.trim();
          if (completeSGF.length() > 100) sgf = completeSGF.substring(0, 50) + " ...";
          codeExample = "> " + sgf + " <" + NL;
          parserMsg = "doesn't begin with \"(;\" (we would accept whitespace between \"(\" and \";\"" + NL + " ..."
                 + "and negligible comments before \"(;\")"; 
          throw new SGFParseException(parserMsg, codeExample);
        }
        
        if (!validSGFEnd) { // (found out in trimComments()) this is just for the error message; is this easy to repair? -> editor
          completeSGF = completeSGF.trim(); // CODE- REPETITION!!
          if (completeSGF.length() > 100) sgf = " ..." + completeSGF.substring(completeSGF.length()-50, completeSGF.length()); 
          codeExample = "> " + sgf + " <" + NL;
          parserMsg = "Code doesn't end with \")\"";
          throw new SGFParseException(parserMsg, codeExample);
        }
        actSGF = sgf; // for error messages etc. 
        // I built up some confusion with sgf, actSGF, code, codeExample, theCurrCode, completeSGF, ...
 // #####################################################################################################################
        ArrayList returnArrayL = new ArrayList(); // ArrayList<SGFNode> (not a string!)
        // - but in SGFController.startProblem() it asks for ArrayList.size >1 -> = multiproblem file
        // so SGFNode would actually be a main branch with all sub branches (vars)
        StringPair tokPair = grabToken(sgf); // splits the sgf code; 1st loop: removes outside "(" / ")"
        while(true) { 
        // here we pass 1x for every main branch of a file (so usually 
        //  only one time - only collection files have more than 1 main branch)
            currCodePartA = tokPair.a; // this is for the error log
            currCodePartB = tokPair.b; //DEBUG
            returnArrayL.add(parseNode(tokPair.a, null)); 
            // parseNode gives an SGFNode (!!) (indeed a complete main branch), so returnArray has 1 or more main branches
            Node.currMainBranchSZ = 0;
            Node.szIsSet = false;

            if(tokPair.b.length() == 0)
                break;
            
            tokPair = grabToken(tokPair.b);
        }
        currCodePartA = "";
        return returnArrayL;
    }

 // ################## SPLIT #############################################################
    public static void split(File dir, String origName, String sgf, String useCharset) throws SGFParseException { 
      // File dir - is it relative or canonical?
//    public static void split(File dir, String sgf) throws SGFParseException { // File dir - is it relative or canonical?
                                  // all Exception caught in FileUtils.splitFile()
        int num = 1;
        
        sgf = sgf.trim();
        sgf = trimComments(sgf);

        StringPair tokPair = grabToken(sgf);

        boolean choseAll = false;
        boolean choseYes = false;
        long now = System.currentTimeMillis();
        
        String[] baseNameA = FileWCpMv.splitPath(origName); // c:\my-sgf\easyProblems.sgf -> c:\my-sgf + easyProblems + .sgf
        String baseName = baseNameA[1];
        
        while(true) {
            try {
                boolean writeFile = true;
                String filename = dir.getPath() + File.separatorChar + baseName+ "-"; //$NON-NLS-1$ 
                if(num < 1000)        // prob0001.sgf ... prob0062.sgf ... prob1042.sgf ...
                    filename += '0';
                if(num < 100)
                    filename += '0';
                if(num < 10)
                    filename += '0';
                filename += num + ".sgf"; //$NON-NLS-1$
                
                File f = new File(filename);
                if(f.exists()) { // compare file dates (the files could get the date of the original sgf, from where we split)
                    if(choseAll) {
                        if(!choseYes)
                            writeFile = false;
                    }
                    else { // overwrite dialog
                        ChoiceDialog c = new ChoiceDialog(ProbFrame.inst, f, now, tokPair.a.length() + 2);
                        int ch = c.getSelection();         // optics, 
                        switch(ch) {
                            case ChoiceDialog.YES_OPTION:
                                break;
                            case ChoiceDialog.NO_OPTION:
                                writeFile = false;
                                break;
                            case ChoiceDialog.YES_ALL_OPTION:
                                choseAll = choseYes = true;
                                break;
                            case ChoiceDialog.NO_ALL_OPTION:
                                choseAll = true;
                                choseYes = false;
                                writeFile = false;
                                break;
                        }
                    }
                }
                if(writeFile) { // try-catch could be restricted to this area
                  FileWReadWrite.writeFileStrCharset(filename, '(' + tokPair.a + ')', GS.getMyDefaultCharset());
                       // ### the reader uses this install's GS.myDefaultCharset for reading!!
                }
            }
            catch(Exception e) {
                parserMsg = "Problem while splitting file (in SGFParser.split)"; // : " + filename;
                throw new SGFParseException(e, parserMsg);
            }
            
            if(tokPair.b.length() == 0)
                break;
            
            tokPair = grabToken(tokPair.b);
            num++;
        }
    }
    
 // ############ STRING_PAIR #############################################################
    static class StringPair { // private class, used to create an object of 2 strings 
        String a;             // while splitting the sgf code in fragments
        String b;
        StringPair(String a, String b) { // this line is the constructor
            this.a = a;
            this.b = b;
        }
    }
}
