/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DeleteGroupsResponse;
import org.apache.kafka.common.utils.Utils;

public class DeleteGroupsRequest
extends AbstractRequest {
    private static final String GROUPS_KEY_NAME = "groups";
    private static final Schema DELETE_GROUPS_REQUEST_V0 = new Schema(new Field("groups", new ArrayOf(Type.STRING), "An array of groups to be deleted."));
    private final Set<String> groups;

    public static Schema[] schemaVersions() {
        return new Schema[]{DELETE_GROUPS_REQUEST_V0};
    }

    private DeleteGroupsRequest(Set<String> groups, short version) {
        super(version);
        this.groups = groups;
    }

    public DeleteGroupsRequest(Struct struct, short version) {
        super(version);
        Object[] groupsArray = struct.getArray(GROUPS_KEY_NAME);
        HashSet<String> groups = new HashSet<String>(groupsArray.length);
        for (Object group : groupsArray) {
            groups.add((String)group);
        }
        this.groups = groups;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.DELETE_GROUPS.requestSchema(this.version()));
        struct.set(GROUPS_KEY_NAME, (Object)this.groups.toArray());
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        HashMap<String, Errors> groupErrors = new HashMap<String, Errors>(this.groups.size());
        for (String group : this.groups) {
            groupErrors.put(group, error);
        }
        switch (this.version()) {
            case 0: {
                return new DeleteGroupsResponse(throttleTimeMs, groupErrors);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", this.version(), ApiKeys.DELETE_GROUPS.name, ApiKeys.DELETE_GROUPS.latestVersion()));
    }

    public Set<String> groups() {
        return this.groups;
    }

    public static DeleteGroupsRequest parse(ByteBuffer buffer, short version) {
        return new DeleteGroupsRequest(ApiKeys.DELETE_GROUPS.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteGroupsRequest> {
        private final Set<String> groups;

        public Builder(Set<String> groups) {
            super(ApiKeys.DELETE_GROUPS);
            this.groups = groups;
        }

        @Override
        public DeleteGroupsRequest build(short version) {
            return new DeleteGroupsRequest(this.groups, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=DeleteGroupsRequest").append(", groups=(").append(Utils.join(this.groups, ", ")).append(")").append(")");
            return bld.toString();
        }
    }
}

