/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class KunststoffProgressBarUI
extends BasicProgressBarUI {
    public static ComponentUI createUI(JComponent x) {
        return new KunststoffProgressBarUI();
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        JProgressBar prog = (JProgressBar)c;
        if (prog.getOrientation() == 0) {
            ColorUIResource colorShadow;
            ColorUIResource colorReflection = KunststoffLookAndFeel.getComponentGradientColorReflection();
            if (colorReflection != null) {
                Color colorReflectionFaded = KunststoffUtilities.getTranslucentColor(colorReflection, 0);
                Rectangle rect = new Rectangle(0, 0, c.getWidth(), c.getHeight() / 2);
                KunststoffUtilities.drawGradient(g, colorReflection, colorReflectionFaded, rect, true);
            }
            if ((colorShadow = KunststoffLookAndFeel.getComponentGradientColorShadow()) != null) {
                Color colorShadowFaded = KunststoffUtilities.getTranslucentColor(colorShadow, 0);
                Rectangle rect = new Rectangle(0, c.getHeight() / 2, c.getWidth(), c.getHeight() / 2);
                KunststoffUtilities.drawGradient(g, colorShadowFaded, colorShadow, rect, true);
            }
        } else {
            ColorUIResource colorShadow;
            ColorUIResource colorReflection = KunststoffLookAndFeel.getComponentGradientColorReflection();
            if (colorReflection != null) {
                Color colorReflectionFaded = KunststoffUtilities.getTranslucentColor(colorReflection, 0);
                Rectangle rect = new Rectangle(0, 0, c.getWidth() / 2, c.getHeight());
                KunststoffUtilities.drawGradient(g, colorReflection, colorReflectionFaded, rect, false);
            }
            if ((colorShadow = KunststoffLookAndFeel.getComponentGradientColorShadow()) != null) {
                Color colorShadowFaded = KunststoffUtilities.getTranslucentColor(colorShadow, 0);
                Rectangle rect = new Rectangle(c.getWidth() / 2, 0, c.getWidth() / 2, c.getHeight());
                KunststoffUtilities.drawGradient(g, colorShadowFaded, colorShadow, rect, false);
            }
        }
    }
}

