;;;
;;; irchat-pj-version-string.el
;;; last modify : Fri, 25 Aug 2000 02:27:39 +0900
;;;               by simm@irc.fan.gr.jp / irchat-PJ Project
;;; see file irchat-copyright.el for change log and copyright info
;;;

;; load version-specific module

(or (and (featurep 'xemacs)
	 (require 'irchat-pj-specific-xmas))
    (and (featurep 'mule)
	 (boundp 'emacs-major-version)
	 (<= 20 emacs-major-version)
	 (require 'irchat-pj-specific-emacs20))
    (and (featurep 'mule)
	 (require 'irchat-pj-specific-mule2))
    (and (boundp 'NEMACS)
	 (require 'irchat-pj-specific-nemacs))
    (require 'irchat-pj-specific-other-emacsen))

;; constants and variables

(defconst irchat-client-version-jp ".24.22[2002/07/21]")

(defvar irchat-pj-version-string-hook nil
  "Hook for modification irchat-pj-version-string")

(defconst irchat-client-version-major "2"
  "Major version number. Major functional changes change this number.")

(defconst irchat-client-version-minor "4"
  "Minor version number. Protocol changes and bug fixes change this number.")

(defconst irchat-client-version-release "$Date: 1994/02/23 15:05:00 $"
  "version release date")

(defconst irchat-client-name "irchat-pj"
  "*Name of this program.")

(defconst irchat-version
  (format "%s %s.%s%s" 
	  irchat-client-name 
	  irchat-client-version-major
	  irchat-client-version-minor
	  irchat-client-version-jp)
  "The version of irchat you are using.")

(defvar irchat-version-plus nil)

(defun irchat-pj-set-version-string ()
  "Set reply string when received CTCP VERSION"
  (setq irchat-pj-version-string
	(concat "VERSION " irchat-version
		(if (stringp irchat-version-plus)
		    (concat "+" irchat-version-plus " ")
		  " ")
		(if (stringp irchat-pj-emacs-version-string)
		    irchat-pj-emacs-version-string
		  (setq irchat-pj-emacs-version-string (irchat-pj-set-emacs-version-string)))
		" :for Emacsen"))
  (run-hooks 'irchat-pj-version-string-hook)
  irchat-pj-version-string)

(defvar irchat-pj-emacs-version-string
  (irchat-pj-set-emacs-version-string)
  "Emacs version string that returns when CTCP VERSION received")

(defvar irchat-pj-version-string
  (irchat-pj-set-version-string)
  "Reply string when CTCP VERSION received")

(provide 'irchat-pj-version-string)

;; end of irchat-pj-version-string.el
