/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.specs.Spec;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;

public class TransformedClassPath
implements ClassPath {
    public static final String INSTRUMENTED_DIR_NAME = "instrumented";
    public static final String ORIGINAL_DIR_NAME = "original";
    public static final String INSTRUMENTED_ENTRY_PREFIX = "instrumented-";
    private final ClassPath originalClassPath;
    private final ImmutableMap<File, File> transforms;

    private TransformedClassPath(ClassPath originalClassPath, Map<File, File> transforms) {
        assert (!(originalClassPath instanceof TransformedClassPath));
        this.originalClassPath = originalClassPath;
        this.transforms = ImmutableMap.copyOf(transforms);
    }

    @Override
    public boolean isEmpty() {
        return this.originalClassPath.isEmpty();
    }

    @Override
    public List<URI> getAsURIs() {
        return this.originalClassPath.getAsURIs();
    }

    @Override
    public List<File> getAsFiles() {
        return this.originalClassPath.getAsFiles();
    }

    public List<File> getAsTransformedFiles() {
        ArrayList<File> originals = new ArrayList<File>(this.originalClassPath.getAsFiles());
        ListIterator<Object> iter = originals.listIterator();
        while (iter.hasNext()) {
            File original = (File)iter.next();
            iter.set(this.transforms.getOrDefault((Object)original, (Object)original));
        }
        return originals;
    }

    @Override
    public List<URL> getAsURLs() {
        return this.originalClassPath.getAsURLs();
    }

    @Override
    public URL[] getAsURLArray() {
        return this.originalClassPath.getAsURLArray();
    }

    TransformedClassPath prepend(DefaultClassPath classPath) {
        return new TransformedClassPath(classPath, (Map<File, File>)ImmutableMap.of()).plusWithTransforms(this);
    }

    private TransformedClassPath plusWithTransforms(TransformedClassPath classPath) {
        ClassPath mergedOriginals = this.originalClassPath.plus(classPath.originalClassPath);
        ImmutableMap.Builder mergedTransforms = ImmutableMap.builderWithExpectedSize((int)(this.transforms.size() + classPath.transforms.size()));
        ImmutableSet thisClassPathFiles = ImmutableSet.copyOf(this.originalClassPath.getAsFiles());
        mergedTransforms.putAll(this.transforms);
        for (Map.Entry appendedTransform : classPath.transforms.entrySet()) {
            if (thisClassPathFiles.contains(appendedTransform.getKey())) continue;
            mergedTransforms.put(appendedTransform);
        }
        return new TransformedClassPath(mergedOriginals, (Map<File, File>)mergedTransforms.buildOrThrow());
    }

    @Override
    public TransformedClassPath plus(Collection<File> classPath) {
        return new TransformedClassPath(this.originalClassPath.plus(classPath), (Map<File, File>)this.transforms);
    }

    @Override
    public TransformedClassPath plus(ClassPath classPath) {
        if (classPath instanceof TransformedClassPath) {
            return this.plusWithTransforms((TransformedClassPath)classPath);
        }
        return new TransformedClassPath(this.originalClassPath.plus(classPath), (Map<File, File>)this.transforms);
    }

    @Override
    public TransformedClassPath removeIf(Spec<? super File> filter) {
        ClassPath filteredClassPath = this.originalClassPath.removeIf(filter);
        ImmutableSet remainingOriginals = ImmutableSet.copyOf(filteredClassPath.getAsFiles());
        ImmutableMap.Builder remainingTransforms = ImmutableMap.builderWithExpectedSize((int)Math.min(remainingOriginals.size(), this.transforms.size()));
        for (Map.Entry remainingEntry : this.transforms.entrySet()) {
            if (!remainingOriginals.contains(remainingEntry.getKey())) continue;
            remainingTransforms.put(remainingEntry);
        }
        return new TransformedClassPath(filteredClassPath, (Map<File, File>)remainingTransforms.build());
    }

    @Nullable
    public File findTransformedEntryFor(File originalClassPathEntry) {
        return (File)this.transforms.get((Object)originalClassPathEntry);
    }

    public int hashCode() {
        return this.originalClassPath.hashCode() + this.transforms.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TransformedClassPath other = (TransformedClassPath)obj;
        return this.originalClassPath.equals(other.originalClassPath) && this.transforms.equals(other.transforms);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        boolean first = true;
        for (File original : this.originalClassPath.getAsFiles()) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(original);
            File transformed = this.findTransformedEntryFor(original);
            if (transformed != null) {
                builder.append("->").append(transformed);
            }
            first = false;
        }
        builder.append("]");
        return builder.toString();
    }

    public static ClassPath handleInstrumentingArtifactTransform(List<File> classPath) {
        if (classPath.isEmpty()) {
            return DefaultClassPath.of(classPath);
        }
        return TransformedClassPath.fromInstrumentingArtifactTransformOutput(classPath);
    }

    private static ClassPath fromInstrumentingArtifactTransformOutput(List<File> inputFiles) {
        LinkedHashMap transformedEntries = Maps.newLinkedHashMapWithExpectedSize((int)inputFiles.size());
        int i = 0;
        block5: while (i < inputFiles.size()) {
            File markerFile = inputFiles.get(i++);
            FileMarker fileMarker = FileMarker.of(markerFile.getName());
            switch (fileMarker) {
                case AGENT_INSTRUMENTATION_MARKER: {
                    Preconditions.checkArgument((i + 1 < inputFiles.size() ? 1 : 0) != 0, (String)"Missing the instrumented or original entry for classpath %s", inputFiles);
                    File instrumentedEntry = inputFiles.get(i++);
                    File originalEntry = inputFiles.get(i++);
                    Preconditions.checkArgument((boolean)TransformedClassPath.areInstrumentedAndOriginalEntriesValid(instrumentedEntry, originalEntry), (String)"Instrumented entry %s doesn't match original entry %s", (Object)instrumentedEntry.getAbsolutePath(), (Object)originalEntry.getAbsolutePath());
                    TransformedClassPath.putIfAbsent(transformedEntries, originalEntry, instrumentedEntry);
                    continue block5;
                }
                case LEGACY_INSTRUMENTATION_MARKER: {
                    Preconditions.checkArgument((i < inputFiles.size() ? 1 : 0) != 0, (String)"Missing the instrumented entry for classpath %s", inputFiles);
                    File legacyInstrumentedEntry = inputFiles.get(i++);
                    TransformedClassPath.putIfAbsent(transformedEntries, legacyInstrumentedEntry, legacyInstrumentedEntry);
                    continue block5;
                }
                case INSTRUMENTATION_CLASSPATH_MARKER: 
                case ORIGINAL_FILE_DOES_NOT_EXIST_MARKER: {
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unexpected marker file: " + markerFile + " in instrumented buildscript classpath. Possible reason: Injecting custom artifact transform in between instrumentation stages is not supported.");
        }
        Builder result = TransformedClassPath.builderWithExactSize(transformedEntries.size());
        for (Map.Entry entry : transformedEntries.entrySet()) {
            result.add((File)entry.getKey(), (File)entry.getValue());
        }
        return result.build();
    }

    private static <K, V> void putIfAbsent(Map<K, V> map, K key, V value) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        }
    }

    private static boolean areInstrumentedAndOriginalEntriesValid(File instrumentedEntry, File originalEntry) {
        return instrumentedEntry.getParentFile() != null && instrumentedEntry.getParentFile().getName().equals(INSTRUMENTED_DIR_NAME) && !originalEntry.equals(instrumentedEntry) && instrumentedEntry.getName().equals(INSTRUMENTED_ENTRY_PREFIX + originalEntry.getName());
    }

    public static Builder builderWithExactSize(int size) {
        return new Builder(size);
    }

    public static class Builder {
        private final DefaultClassPath.Builder originals;
        private final ImmutableMap.Builder<File, File> transforms;

        private Builder(int exactSize) {
            this.originals = DefaultClassPath.builderWithExactSize(exactSize);
            this.transforms = ImmutableMap.builderWithExpectedSize((int)exactSize);
        }

        public Builder add(File original, File transformed) {
            this.originals.add(original);
            if (!original.equals(transformed)) {
                this.transforms.put((Object)original, (Object)transformed);
            }
            return this;
        }

        public Builder addUntransformed(File original) {
            this.originals.add(original);
            return this;
        }

        public TransformedClassPath build() {
            ImmutableMap transformedMap = this.transforms.build();
            return new TransformedClassPath(this.originals.build(), (Map)transformedMap);
        }
    }

    @NonNullApi
    public static enum FileMarker {
        INSTRUMENTATION_CLASSPATH_MARKER(".gradle-instrumented-classpath.marker"),
        AGENT_INSTRUMENTATION_MARKER(".gradle-agent-instrumented.marker"),
        LEGACY_INSTRUMENTATION_MARKER(".gradle-legacy-instrumented.marker"),
        ORIGINAL_FILE_DOES_NOT_EXIST_MARKER(".original-file-does-not-exist.marker"),
        UNKNOWN_FILE_MARKER("");

        private static final Map<String, FileMarker> FILE_MARKER_MAP;
        private final String fileName;

        private FileMarker(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public static FileMarker of(String fileName) {
            FileMarker marker = FILE_MARKER_MAP.get(fileName);
            return marker == null ? UNKNOWN_FILE_MARKER : marker;
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (FileMarker fileMarker : FileMarker.values()) {
                builder.put((Object)fileMarker.fileName, (Object)fileMarker);
            }
            FILE_MARKER_MAP = builder.build();
        }
    }
}

