/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.ColopediaDetailPanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.ColopediaTreeItem;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.ModifierFormat;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.UnitType;

public abstract class ColopediaGameObjectTypePanel<T extends FreeColGameObjectType>
extends FreeColPanel
implements ColopediaDetailPanel<T> {
    private ColopediaPanel colopediaPanel;
    private final String id;

    public ColopediaGameObjectTypePanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel, String id) {
        super(freeColClient);
        this.colopediaPanel = colopediaPanel;
        this.id = "colopediaAction." + id;
    }

    protected String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return Messages.getName(this.id);
    }

    public void addSubTrees(DefaultMutableTreeNode root, List<T> types) {
        this.addSubTrees(root, this.id, types);
    }

    public void addSubTrees(DefaultMutableTreeNode root, String id, List<T> types) {
        String name = this.getName();
        ColopediaTreeItem cti = new ColopediaTreeItem(this, id, name, null);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(cti);
        int width = ImageLibrary.ICON_SIZE.width;
        int height = ImageLibrary.ICON_SIZE.height;
        for (FreeColGameObjectType type : types) {
            BufferedImage image = type instanceof GoodsType ? ImageLibrary.getMiscImage("image.icon." + type.getId(), ImageLibrary.ICON_SIZE) : (type instanceof ResourceType ? ImageLibrary.getMiscImage("image.tileitem." + type.getId(), ImageLibrary.ICON_SIZE) : (type instanceof Nation ? ImageLibrary.getMiscIconImage(type, ImageLibrary.ICON_SIZE) : (type instanceof BuildableType ? ImageLibrary.getBuildableImage((BuildableType)type, ImageLibrary.ICON_SIZE) : ImageLibrary.getMiscImage("image.miscicon.delete", ImageLibrary.ICON_SIZE))));
            int x = (width - ((Image)image).getWidth(null)) / 2;
            int y = (height - ((Image)image).getHeight(null)) / 2;
            BufferedImage centeredImage = new BufferedImage(width, height, 2);
            Graphics2D g = centeredImage.createGraphics();
            g.drawImage((Image)image, x, y, null);
            g.dispose();
            node.add(this.buildItem(type, new ImageIcon(centeredImage)));
        }
        root.add(node);
    }

    protected DefaultMutableTreeNode buildItem(FreeColGameObjectType type, ImageIcon icon) {
        String name = Messages.getName(type);
        return new DefaultMutableTreeNode(new ColopediaTreeItem(this, type.getId(), name, icon));
    }

    protected JButton getButton(FreeColGameObjectType type, String text, ImageIcon icon) {
        JButton button = Utility.getLinkButton(text != null ? text : Messages.getName(type), icon, type.getId());
        button.addActionListener(this.colopediaPanel);
        return button;
    }

    protected JButton getButton(ColopediaAction.PanelType panelType, String text, ImageIcon icon) {
        JButton button = Utility.getLinkButton(text, icon, "colopediaAction." + panelType.getKey());
        button.addActionListener(this.colopediaPanel);
        return button;
    }

    protected JButton getButton(FreeColGameObjectType type) {
        return this.getButton(type, null, null);
    }

    protected JButton getResourceButton(ResourceType resourceType) {
        return this.getButton(resourceType, null, new ImageIcon(this.getImageLibrary().getMiscImage("image.tileitem." + resourceType.getId())));
    }

    protected JButton getGoodsButton(GoodsType goodsType) {
        return this.getGoodsButton(goodsType, null);
    }

    protected JButton getGoodsButton(GoodsType goodsType, int amount) {
        return this.getGoodsButton(goodsType, Integer.toString(amount));
    }

    protected JButton getGoodsButton(AbstractGoods goods) {
        return this.getGoodsButton(goods.getType(), goods.getAmount());
    }

    protected JButton getGoodsButton(GoodsType goodsType, String text) {
        JButton result = this.getButton(goodsType, text, new ImageIcon(this.getImageLibrary().getIconImage(goodsType)));
        result.setToolTipText(Messages.getName(goodsType));
        return result;
    }

    protected JButton getUnitButton(AbstractUnit au) {
        return this.getUnitButton(au.getType(this.getSpecification()), au.getRoleId());
    }

    protected JButton getUnitButton(UnitType unitType, String roleId) {
        ImageIcon unitIcon = new ImageIcon(this.getImageLibrary().getSmallUnitImage(unitType, roleId, false));
        JButton unitButton = this.getButton(unitType, null, unitIcon);
        unitButton.setHorizontalAlignment(2);
        return unitButton;
    }

    protected JButton getUnitButton(UnitType unitType) {
        return this.getUnitButton(unitType, unitType.getDisplayRoleId());
    }

    public JComponent getModifierComponent(Modifier modifier) {
        try {
            GoodsType goodsType = this.getSpecification().getGoodsType(modifier.getId());
            String bonus = ModifierFormat.getModifierAsString(modifier);
            return this.getGoodsButton(goodsType, bonus);
        }
        catch (Exception e) {
            JLabel label = new JLabel(ModifierFormat.getFeatureAsString(modifier) + ": " + ModifierFormat.getModifierAsString(modifier));
            label.setToolTipText(Messages.getShortDescription(modifier));
            return label;
        }
    }

    public JLabel getAbilityComponent(Ability ability) {
        if (ability.getValue()) {
            JLabel label = new JLabel(ModifierFormat.getFeatureAsString(ability));
            label.setToolTipText(Messages.getShortDescription(ability));
            return label;
        }
        return null;
    }

    public void appendRequiredAbilities(StyledDocument doc, BuildableType buildableType) throws BadLocationException {
        ArrayList<JButton> requiredTypes = new ArrayList<JButton>();
        for (Map.Entry<String, Boolean> entry : buildableType.getRequiredAbilities().entrySet()) {
            doc.insertString(doc.getLength(), Messages.getName(entry.getKey()), doc.getStyle("regular"));
            requiredTypes.clear();
            for (FreeColGameObjectType type : this.getSpecification().getTypesProviding(entry.getKey(), entry.getValue())) {
                JButton typeButton = this.getButton(type);
                typeButton.addActionListener(this);
                requiredTypes.add(typeButton);
            }
            if (!requiredTypes.isEmpty()) {
                doc.insertString(doc.getLength(), " (", doc.getStyle("regular"));
                StyleConstants.setComponent(doc.getStyle("button"), (Component)requiredTypes.get(0));
                doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                for (int index = 1; index < requiredTypes.size(); ++index) {
                    JButton button = (JButton)requiredTypes.get(index);
                    doc.insertString(doc.getLength(), " / ", doc.getStyle("regular"));
                    StyleConstants.setComponent(doc.getStyle("button"), button);
                    doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                }
                doc.insertString(doc.getLength(), ")", doc.getStyle("regular"));
            }
            doc.insertString(doc.getLength(), "\n", doc.getStyle("regular"));
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.colopediaPanel = null;
    }
}

