/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.function.mapping.LambdaFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.IntValue;

class IntValueInIntValueOutFunction
extends IntValue.AbstractIntValue {
    private final IntValue param;
    private final LambdaFunction.IntInIntOutLambda lambda;
    private final String name;
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    private boolean exists = false;

    public IntValueInIntValueOutFunction(String name, LambdaFunction.IntInIntOutLambda lambda, IntValue param) {
        this.name = name;
        this.lambda = lambda;
        this.param = param;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
    }

    @Override
    public int getInt() {
        int value = this.lambda.apply(this.param.getInt());
        this.exists = this.param.exists();
        return value;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

