/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.common.SolrException;

class BooleanFilterFunction
extends BooleanValue.AbstractBooleanValue {
    private final BooleanValue baseExpr;
    private final BooleanValue filterExpr;
    public static final String name = "filter";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    boolean exists = false;

    public BooleanFilterFunction(BooleanValue baseExpr, BooleanValue filterExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.filterExpr = filterExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, filterExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
    }

    @Override
    public boolean getBoolean() {
        boolean value = this.baseExpr.getBoolean();
        this.exists = this.baseExpr.exists() && this.filterExpr.getBoolean() && this.filterExpr.exists();
        return value;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

