/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.util.Set;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.streaming.StreamEvent;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamRequest;
import org.apache.cassandra.streaming.StreamState;

public class StreamStateStore
implements StreamEventHandler {
    public Set<Range<Token>> getAvailableRanges(String keyspace, IPartitioner partitioner) {
        return SystemKeyspace.getAvailableRanges(keyspace, partitioner);
    }

    public boolean isDataAvailable(String keyspace, Token token) {
        Set<Range<Token>> availableRanges = this.getAvailableRanges(keyspace, token.getPartitioner());
        for (Range<Token> range : availableRanges) {
            if (!range.contains(token)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handleStreamEvent(StreamEvent event) {
        if (event.eventType == StreamEvent.Type.STREAM_COMPLETE) {
            StreamEvent.SessionCompleteEvent se = (StreamEvent.SessionCompleteEvent)event;
            if (se.success) {
                for (StreamRequest request : se.requests) {
                    SystemKeyspace.updateAvailableRanges(request.keyspace, request.ranges);
                }
            }
        }
    }

    public void onSuccess(StreamState streamState) {
    }

    public void onFailure(Throwable throwable) {
    }
}

