# Copyright (C) 2002-2003 Hewlett Packard
# Copyright (C) 2005 Jay Beale
# Copyright (C) 2005 Charlie Long, Delphi Research
# Licensed under the GNU General Public License


require Bastille::API;
import Bastille::API;

$GLOBAL_TEST{'FTP'}{'ftpgeneral'} = 
    sub { 
	if ( &B_is_service_off('ftp') and &B_is_service_off('vsftpd') ) {
	    return $SKIPQ;
	}
    };



if( &GetDistro =~ "^HP-UX") {

    $GLOBAL_TEST{'FTP'}{'ftpusers'} = 
	sub { 
	    # location of ftpusers file
	    my $ftpusers = &getGlobal('FILE',"ftpusers");
	    
	    # list users that should be restricted inside of the ftpusers file
	    my @restrictedUser = ("root","daemon","bin","sys","adm","uucp","lp","nuucp","hpdb","guest");
	    
	    # if the ftpusers file exists then
	    if(-e $ftpusers) {
		# check and see if each resticted user is in the file
		foreach my $user (@restrictedUser) {
		    if(! &B_match_line($ftpusers,"\^\\s\*$user\\s\*\$")) {
			# if a user is missing ask the question.
			return $ASKQ;
		    }
		}
	    }
	    else {
		# if the file does not exists ask the question
		return $ASKQ;
	    }	
	    
	    # if all resticted users are present inside of the 
	    # ftpusers file then don't ask the question.
	    return $SKIPQ;
	    
	};
}
else {

#    return;

######## This question has not yet been implemented on Linux #####
# TODO: Implemet this on Linux

# TO DO: Ask HP if they'll accept this more dynamic routine
    $GLOBAL_TEST{'FTP'}{'ftpaccess'} =
	sub {
	    # location of ftpusers file
	    my $ftpusers = &getGlobal('FILE',"ftpusers");
	    
	    # UID where human users start
	    my $human_uid_start = 500;
	    
	    if( &GetDistro =~ "^RH") {
		$human_uid_start = 500;
	    }
	    elsif( &GetDistro =~ "^SE") {
		$human_uid_start = 1000;
	    }
	    
	    @$restrictedUser = B_get_ftpuser_list($human_uid_start);
	    
	    # if the ftpusers file exists then
	    if(-e $ftpusers) {
		# check and see if each resticted user is in the file
		foreach my $user (@restrictedUser) {
		    if(! &B_match_line($ftpusers,"\^\\s\*$user\\s\*\$")) {
			# if a user is missing ask the question.
			return $ASKQ;
		    }
		}
	    }
	    else {
		# if the file does not exists ask the question
		return $ASKQ;
		
	    }
	    
	    # if all resticted users are present inside of the
	    # ftpusers file then don't ask the question.
	    return $SKIPQ;
	};
}

sub B_get_ftpuser_list($)
{
    $uid_where_human_users_start = shift;
    my $users;
    my $passwd = &getGlobal('FILE','passwd');
    open(PASSWD,$passwd);
    while(<PASSWD>) {
        #Get the users
        if (/([^:]+):([^:]+):([^:]+):([^:+])/)
        {
	    if ($3 < $uid_where_human_users_start) {
                push (@restrictedUsers, $1);
	    }
	}
    }
    return \@restrictedUsers;
}


$GLOBAL_TEST{'FTP'}{'ftpusers'} = 
    sub { 
	# location of ftpusers file
	my $ftpusers = &getGlobal('FILE',"ftpusers");

	# list users that should be restricted inside of the ftpusers file
	my @restrictedUser = ("root","daemon","bin","sys","adm","uucp","lp","nuucp","hpdb","guest");
	
	# if the ftpusers file exists then
	if(-e $ftpusers) {
	    # check and see if each resticted user is in the file
	    foreach my $user (@restrictedUser) {
		if(! &B_match_line($ftpusers,"\^\\s\*$user\\s\*\$")) {
		    # if a user is missing ask the question.
		    return $ASKQ;
		}
	    }
	}
	else {
	    # if the file does not exists ask the question
	    return $ASKQ;
	}	

	# if all resticted users are present inside of the 
        # ftpusers file then don't ask the question.
	return $SKIPQ;

    };

$GLOBAL_TEST{'FTP'}{'anonftp'} = 
    sub { 
	my $ftpaccess = &getGlobal('FILE','ftpaccess');
	my $vsftpdconf_location1 = '/etc/vsftpd/vsftpd.conf';
	my $vsftpdconf_location2 = '/etc/vsftpd.conf';
	my $vsftpdconf;

        # When we're dealing with ftpaccess (wu-ftpd)
	if ( -e $ftpaccess ) {
	    # ...look for a class line with anonymous on it.
	    if (&B_match_line($ftpaccess,'class\s+.*anonymous')) {
		return $ASKQ;
	    }
	}

	# Find the vsftpd.conf file, which is sometimes in its own directory.
	if ( -e $vsftpdconf_location1 ) {
	    $vsftpdconf = $vsftpdconf_location1;
	}
	elsif ( -e $vsftpdconf_location2 ) {
	    $vsftpdconf = $vsftpdconf_location2;
	}

	# When we're dealing with vsftpd, look for anonymous_enable=NO.
	# The default is YES, so there _must_ be a line saying no.
	if ( defined($vsftpdconf) ) {
	    unless (&B_match_line($vsftpdconf,'^\s*anonymous_enable\s*=\s*(no|NO)')) {
		return $ASKQ;
	    }
	}
	return $SKIPQ;
    };

$GLOBAL_TEST{'FTP'}{'userftp'} = 
    sub { 
	my $ftpaccess = &getGlobal('FILE','ftpaccess');
	my $vsftpdconf_location1 = '/etc/vsftpd/vsftpd.conf';
	my $vsftpdconf_location2 = '/etc/vsftpd.conf';
	my $vsftpdconf;

        # When we're dealing with ftpaccess (wu-ftpd)
	if ( -e $ftpaccess ) {
	    # ...look for a class line with anonymous on it.
	    if (&B_match_line($ftpaccess,'class\s+.*anonymous')) {
		return $ASKQ;
	    }
	}

	# Find the vsftpd.conf file, which is sometimes in its own directory.
	if ( -e $vsftpdconf_location1 ) {
	    $vsftpdconf = $vsftpdconf_location1;
	}
	elsif ( -e $vsftpdconf_location2 ) {
	    $vsftpdconf = $vsftpdconf_location2;
	}

	# When we're dealing with vsftpd, look for local_enable=YES.
	# The default is NO, so absence of this line is still good.
	if ( defined($vsftpdconf) ) {
	    if (&B_match_line($vsftpdconf,'^\s*local_enable\s*=\s*(yes|YES)')) {
		return $ASKQ;
	    }
	}
	return $SKIPQ;
    };



1;
