/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.cgoban;

import com.gokgs.client.android.AndRes;
import com.gokgs.client.swing.KSRes;
import com.gokgs.jsp.KJspRes;
import com.gokgs.server.KRes;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import org.igoweb.cgoban.CGobanRes;
import org.igoweb.goTutor.TutorRes;
import org.igoweb.igoweb.Config;
import org.igoweb.resource.ResEntry;
import org.igoweb.resource.Resource;
import org.igoweb.resource.swing.ResEditor;

public class Translator
extends JFrame {
    private ArrayList<ResEditor> editors;

    public static void main(String[] args) {
        new Translator();
    }

    public Translator() {
        super("Resource Editor");
        JTabbedPane tabPane = new JTabbedPane();
        this.getContentPane().add(tabPane);
        ArrayList<String> usedPkgs = new ArrayList<String>();
        this.editors = new ArrayList();
        ResEditor clientEditor = new ResEditor("Client & SGF Editor", new MasterRes(), Config.get("localeList"), usedPkgs);
        usedPkgs.addAll(clientEditor.getPackagesUsed());
        ResEditor dwpEditor = new ResEditor("Web Pages", new KJspRes(), Config.get("localeList"), usedPkgs);
        usedPkgs.addAll(dwpEditor.getPackagesUsed());
        ResEditor tutorEditor = new ResEditor("Go Tutor Applet", new TutorRes(), Config.get("localeList"), usedPkgs);
        usedPkgs.addAll(tutorEditor.getPackagesUsed());
        ResEditor androidEditor = new ResEditor("Android", new AndRes(), Config.get("localeList"), usedPkgs);
        usedPkgs.addAll(androidEditor.getPackagesUsed());
        this.editors.add(clientEditor);
        this.editors.add(dwpEditor);
        this.editors.add(tutorEditor);
        this.editors.add(androidEditor);
        for (ResEditor edit : this.editors) {
            edit.setPeers(this.editors);
            tabPane.add((Component)edit, edit.getName());
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ((ResEditor)Translator.this.editors.get(0)).quitPressed();
            }
        });
        this.pack();
        this.setVisible(true);
    }

    private static class MasterRes
    extends Resource {
        private MasterRes() {
        }

        @Override
        public Resource[] getChildren() {
            return new Resource[]{new CGobanRes(), new KSRes(), new KRes()};
        }

        @Override
        public String propFilePath() {
            return null;
        }

        @Override
        public ResEntry[] getContents() {
            return new ResEntry[0];
        }
    }
}

