/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.norm;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.search.Explanation;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.ltr.norm.NormalizerException;
import org.apache.solr.util.SolrPluginUtils;

public abstract class Normalizer {
    public abstract float normalize(float var1);

    public abstract LinkedHashMap<String, Object> paramsToMap();

    public Explanation explain(Explanation explain) {
        float normalized = this.normalize(explain.getValue().floatValue());
        String explainDesc = "normalized using " + this.toString();
        return Explanation.match((Number)Float.valueOf(normalized), (String)explainDesc, (Explanation[])new Explanation[]{explain});
    }

    public static Normalizer getInstance(SolrResourceLoader solrResourceLoader, String className, Map<String, Object> params) {
        Normalizer f = (Normalizer)solrResourceLoader.newInstance(className, Normalizer.class);
        if (params != null) {
            SolrPluginUtils.invokeSetters((Object)f, params.entrySet());
        }
        f.validate();
        return f;
    }

    protected abstract void validate() throws NormalizerException;
}

