/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DIHLogLevels;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.EntityProcessorWrapper;
import org.apache.solr.handler.dataimport.ScriptTransformer;
import org.apache.solr.handler.dataimport.SolrWriter;
import org.apache.solr.handler.dataimport.Transformer;

class DebugLogger {
    private Stack<DebugInfo> debugStack;
    NamedList output;
    private static final String LINE = "---------------------------------------------";
    private MessageFormat fmt = new MessageFormat("----------- row #{0}-------------", Locale.ROOT);
    boolean enabled = true;

    public DebugLogger() {
        this.output = new NamedList();
        this.debugStack = new Stack<DebugInfo>(){

            @Override
            public DebugInfo pop() {
                if (this.size() == 1) {
                    throw new DataImportHandlerException(500, "Stack is becoming empty");
                }
                return (DebugInfo)super.pop();
            }
        };
        this.debugStack.push(new DebugInfo(null, DIHLogLevels.NONE, null));
        this.output = this.debugStack.peek().lst;
    }

    private DebugInfo peekStack() {
        return this.debugStack.isEmpty() ? null : this.debugStack.peek();
    }

    public void log(DIHLogLevels event, String name, Object row) {
        if (event == DIHLogLevels.DISABLE_LOGGING) {
            this.enabled = false;
            return;
        }
        if (event == DIHLogLevels.ENABLE_LOGGING) {
            this.enabled = true;
            return;
        }
        if (!this.enabled && event != DIHLogLevels.START_ENTITY && event != DIHLogLevels.END_ENTITY) {
            return;
        }
        if (event == DIHLogLevels.START_DOC) {
            this.debugStack.push(new DebugInfo(null, DIHLogLevels.START_DOC, this.peekStack()));
        } else if (DIHLogLevels.START_ENTITY == event) {
            this.debugStack.push(new DebugInfo(name, DIHLogLevels.START_ENTITY, this.peekStack()));
        } else if (DIHLogLevels.ENTITY_OUT == event || DIHLogLevels.PRE_TRANSFORMER_ROW == event) {
            if (this.debugStack.peek().type == DIHLogLevels.START_ENTITY || this.debugStack.peek().type == DIHLogLevels.START_DOC) {
                this.debugStack.peek().lst.add(null, (Object)this.fmt.format(new Object[]{++this.debugStack.peek().rowCount}));
                this.addToNamedList(this.debugStack.peek().lst, row);
                this.debugStack.peek().lst.add(null, (Object)LINE);
            }
        } else if (event == DIHLogLevels.ROW_END) {
            this.popAllTransformers();
        } else if (DIHLogLevels.END_ENTITY == event) {
            while (this.debugStack.pop().type != DIHLogLevels.START_ENTITY) {
            }
        } else if (DIHLogLevels.END_DOC == event) {
            while (this.debugStack.pop().type != DIHLogLevels.START_DOC) {
            }
        } else if (event == DIHLogLevels.TRANSFORMER_EXCEPTION) {
            this.debugStack.push(new DebugInfo(name, event, this.peekStack()));
            this.debugStack.peek().lst.add("EXCEPTION", (Object)DebugLogger.getStacktraceString((Exception)row));
        } else if (DIHLogLevels.TRANSFORMED_ROW == event) {
            this.debugStack.push(new DebugInfo(name, event, this.peekStack()));
            this.debugStack.peek().lst.add(null, (Object)LINE);
            this.addToNamedList(this.debugStack.peek().lst, row);
            this.debugStack.peek().lst.add(null, (Object)LINE);
            if (row instanceof DataImportHandlerException) {
                DataImportHandlerException dataImportHandlerException = (DataImportHandlerException)row;
                dataImportHandlerException.debugged = true;
            }
        } else if (DIHLogLevels.ENTITY_META == event) {
            this.popAllTransformers();
            this.debugStack.peek().lst.add(name, row);
        } else if (DIHLogLevels.ENTITY_EXCEPTION == event) {
            if (row instanceof DataImportHandlerException) {
                DataImportHandlerException dihe = (DataImportHandlerException)row;
                if (dihe.debugged) {
                    return;
                }
                dihe.debugged = true;
            }
            this.popAllTransformers();
            this.debugStack.peek().lst.add("EXCEPTION", (Object)DebugLogger.getStacktraceString((Exception)row));
        }
    }

    private void popAllTransformers() {
        DIHLogLevels type;
        while ((type = this.debugStack.peek().type) != DIHLogLevels.START_DOC && type != DIHLogLevels.START_ENTITY) {
            this.debugStack.pop();
        }
    }

    private void addToNamedList(NamedList nl, Object row) {
        block4: {
            block3: {
                if (!(row instanceof List)) break block3;
                List list = (List)row;
                NamedList l = new NamedList();
                nl.add(null, (Object)l);
                for (Object o : list) {
                    Map map = (Map)o;
                    for (Map.Entry entry : map.entrySet()) {
                        nl.add((String)entry.getKey(), entry.getValue());
                    }
                }
                break block4;
            }
            if (!(row instanceof Map)) break block4;
            Map map = (Map)row;
            for (Map.Entry entry : map.entrySet()) {
                nl.add((String)entry.getKey(), entry.getValue());
            }
        }
    }

    DataSource wrapDs(final DataSource ds) {
        return new DataSource(){

            @Override
            public void init(Context context, Properties initProps) {
                ds.init(context, initProps);
            }

            @Override
            public void close() {
                ds.close();
            }

            public Object getData(String query) {
                DebugLogger.this.log(DIHLogLevels.ENTITY_META, "query", query);
                long start = System.nanoTime();
                try {
                    Object t = ds.getData(query);
                    return t;
                }
                catch (DataImportHandlerException de) {
                    DebugLogger.this.log(DIHLogLevels.ENTITY_EXCEPTION, null, de);
                    throw de;
                }
                catch (Exception e) {
                    DebugLogger.this.log(DIHLogLevels.ENTITY_EXCEPTION, null, e);
                    DataImportHandlerException de = new DataImportHandlerException(500, "", e);
                    de.debugged = true;
                    throw de;
                }
                finally {
                    DebugLogger.this.log(DIHLogLevels.ENTITY_META, "time-taken", DocBuilder.getTimeElapsedSince(start));
                }
            }
        };
    }

    Transformer wrapTransformer(final Transformer t) {
        return new Transformer(){

            @Override
            public Object transformRow(Map<String, Object> row, Context context) {
                DebugLogger.this.log(DIHLogLevels.PRE_TRANSFORMER_ROW, null, row);
                String tName = DebugLogger.getTransformerName(t);
                Object result = null;
                try {
                    result = t.transformRow(row, context);
                    DebugLogger.this.log(DIHLogLevels.TRANSFORMED_ROW, tName, result);
                }
                catch (DataImportHandlerException de) {
                    DebugLogger.this.log(DIHLogLevels.TRANSFORMER_EXCEPTION, tName, de);
                    de.debugged = true;
                    throw de;
                }
                catch (Exception e) {
                    DebugLogger.this.log(DIHLogLevels.TRANSFORMER_EXCEPTION, tName, e);
                    DataImportHandlerException de = new DataImportHandlerException(500, "", e);
                    de.debugged = true;
                    throw de;
                }
                return result;
            }
        };
    }

    public static String getStacktraceString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    static String getTransformerName(Transformer t) {
        Class<?> transClass = t.getClass();
        if (t instanceof EntityProcessorWrapper.ReflectionTransformer) {
            return ((EntityProcessorWrapper.ReflectionTransformer)t).trans;
        }
        if (t instanceof ScriptTransformer) {
            ScriptTransformer scriptTransformer = (ScriptTransformer)t;
            return "script:" + scriptTransformer.getFunctionName();
        }
        if (transClass.getPackage().equals(DebugLogger.class.getPackage())) {
            return transClass.getSimpleName();
        }
        return transClass.getName();
    }

    private static class DebugInfo {
        String name;
        int tCount;
        int rowCount;
        NamedList lst;
        DIHLogLevels type;
        DebugInfo parent;

        public DebugInfo(String name, DIHLogLevels type, DebugInfo parent) {
            this.name = name;
            this.type = type;
            this.parent = parent;
            this.lst = new NamedList();
            if (parent != null) {
                String displayName = null;
                if (type == DIHLogLevels.START_ENTITY) {
                    displayName = "entity:" + name;
                } else if (type == DIHLogLevels.TRANSFORMED_ROW || type == DIHLogLevels.TRANSFORMER_EXCEPTION) {
                    displayName = "transformer:" + name;
                } else if (type == DIHLogLevels.START_DOC) {
                    this.name = displayName = "document#" + SolrWriter.getDocCount();
                }
                parent.lst.add(displayName, (Object)this.lst);
            }
        }
    }
}

