/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import com.google.common.base.Function;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;

class OptionSimple
extends Option
implements Serializable {
    final String displayPrefix;
    private final Pattern matchPrefix;
    private final String defaultValue;
    private final Function<String, String> valueAdapter;
    private final String description;
    private final boolean required;
    private String value;

    public OptionSimple(String prefix, String valuePattern, String defaultValue, String description, boolean required) {
        this(prefix, Pattern.compile(Pattern.quote(prefix), 2), Pattern.compile(valuePattern, 2), defaultValue, description, required);
    }

    public OptionSimple(String prefix, Function<String, String> valueAdapter, String defaultValue, String description, boolean required) {
        this(prefix, Pattern.compile(Pattern.quote(prefix), 2), valueAdapter, defaultValue, description, required);
    }

    public OptionSimple(String displayPrefix, Pattern matchPrefix, Pattern valuePattern, String defaultValue, String description, boolean required) {
        this(displayPrefix, matchPrefix, new ValueMatcher(valuePattern), defaultValue, description, required);
    }

    public OptionSimple(String displayPrefix, Pattern matchPrefix, Function<String, String> valueAdapter, String defaultValue, String description, boolean required) {
        this.displayPrefix = displayPrefix;
        this.matchPrefix = matchPrefix;
        this.valueAdapter = valueAdapter;
        this.defaultValue = defaultValue;
        this.description = description;
        this.required = required;
    }

    @Override
    public boolean setByUser() {
        return this.value != null;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean present() {
        return this.value != null || this.defaultValue != null;
    }

    public String value() {
        return this.value != null ? this.value : this.defaultValue;
    }

    @Override
    public boolean accept(String param) {
        if (this.matchPrefix.matcher(param).lookingAt()) {
            if (this.value != null) {
                throw new IllegalArgumentException("Suboption " + this.displayPrefix + " has been specified more than once");
            }
            String v = param.substring(this.displayPrefix.length());
            this.value = (String)this.valueAdapter.apply((Object)v);
            assert (this.value != null);
            return true;
        }
        return false;
    }

    @Override
    public boolean happy() {
        return !this.required || this.value != null;
    }

    @Override
    public String shortDisplay() {
        StringBuilder sb = new StringBuilder();
        if (!this.required) {
            sb.append("[");
        }
        sb.append(this.displayPrefix);
        if (this.displayPrefix.endsWith("=")) {
            sb.append("?");
        }
        if (this.displayPrefix.endsWith("<")) {
            sb.append("?");
        }
        if (this.displayPrefix.endsWith(">")) {
            sb.append("?");
        }
        if (!this.required) {
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public String longDisplay() {
        if (this.description.equals("") && this.defaultValue == null && this.valueAdapter instanceof ValueMatcher && ((ValueMatcher)this.valueAdapter).pattern.pattern().equals("")) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.displayPrefix);
        if (this.displayPrefix.endsWith("=")) {
            sb.append("?");
        }
        if (this.displayPrefix.endsWith("<")) {
            sb.append("?");
        }
        if (this.displayPrefix.endsWith(">")) {
            sb.append("?");
        }
        if (this.defaultValue != null) {
            sb.append(" (default=");
            sb.append(this.defaultValue);
            sb.append(")");
        }
        return GroupedOptions.formatLong(sb.toString(), this.description);
    }

    @Override
    public String getOptionAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.displayPrefix);
        if (!(this.displayPrefix.endsWith("=") || this.displayPrefix.endsWith("<") || this.displayPrefix.endsWith(">"))) {
            sb.append(this.setByUser() ? ":*set*" : ":*not set*");
        } else {
            sb.append(this.value == null ? this.defaultValue : this.value);
        }
        return sb.toString();
    }

    @Override
    public List<String> multiLineDisplay() {
        return Collections.emptyList();
    }

    @Override
    public int hashCode() {
        return this.displayPrefix.hashCode();
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof OptionSimple && ((OptionSimple)that).displayPrefix.equals(this.displayPrefix);
    }

    private static final class ValueMatcher
    implements Function<String, String>,
    Serializable {
        final Pattern pattern;

        private ValueMatcher(Pattern pattern) {
            this.pattern = pattern;
        }

        public String apply(String s) {
            if (!this.pattern.matcher(s).matches()) {
                throw new IllegalArgumentException("Invalid value " + s + "; must match pattern " + this.pattern);
            }
            return s;
        }
    }
}

