/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.settings.CommandCategory;
import org.apache.cassandra.stress.settings.Legacy;
import org.apache.cassandra.stress.settings.SettingsCommandPreDefined;
import org.apache.cassandra.stress.settings.SettingsCommandPreDefinedMixed;
import org.apache.cassandra.stress.settings.SettingsCommandUser;
import org.apache.cassandra.stress.settings.SettingsMisc;

public enum Command {
    READ(false, "standard1", "Multiple concurrent reads - the cluster must first be populated by a write test", CommandCategory.BASIC),
    WRITE(true, "standard1", "insert", "Multiple concurrent writes against the cluster", CommandCategory.BASIC),
    MIXED(true, null, "Interleaving of any basic commands, with configurable ratio and distribution - the cluster must first be populated by a write test", CommandCategory.MIXED),
    COUNTER_WRITE(true, "counter1", "counter_add", "Multiple concurrent updates of counters.", CommandCategory.BASIC),
    COUNTER_READ(false, "counter1", "counter_get", "Multiple concurrent reads of counters. The cluster must first be populated by a counterwrite test.", CommandCategory.BASIC),
    USER(true, null, "Interleaving of user provided queries, with configurable ratio and distribution", CommandCategory.USER),
    HELP(false, null, "-?", "Print help for a command or option", null),
    PRINT(false, null, "Inspect the output of a distribution definition", null),
    LEGACY(false, null, "Legacy support mode", null),
    VERSION(false, null, "Print the version of cassandra stress", null);

    private static final Map<String, Command> LOOKUP;
    public final boolean updates;
    public final CommandCategory category;
    public final List<String> names;
    public final String description;
    public final String table;

    public static Command get(String command) {
        return LOOKUP.get(command.toLowerCase());
    }

    private Command(boolean updates, String table, String description, CommandCategory category) {
        this(updates, table, null, description, category);
    }

    private Command(boolean updates, String table, String extra, String description, CommandCategory category) {
        this.table = table;
        this.updates = updates;
        this.category = category;
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.toString().toLowerCase());
        names.add(this.toString().replaceAll("_", "").toLowerCase());
        if (extra != null) {
            names.add(extra.toLowerCase());
            names.add(extra.replaceAll("_", "").toLowerCase());
        }
        this.names = ImmutableList.copyOf(names);
        this.description = description;
    }

    public void printHelp() {
        this.helpPrinter().run();
    }

    public final Runnable helpPrinter() {
        switch (this) {
            case PRINT: {
                return SettingsMisc.printHelpPrinter();
            }
            case HELP: {
                return SettingsMisc.helpHelpPrinter();
            }
            case LEGACY: {
                return Legacy.helpPrinter();
            }
        }
        switch (this.category) {
            case USER: {
                return SettingsCommandUser.helpPrinter();
            }
            case BASIC: {
                return SettingsCommandPreDefined.helpPrinter(this);
            }
            case MIXED: {
                return SettingsCommandPreDefinedMixed.helpPrinter();
            }
        }
        throw new AssertionError();
    }

    static {
        HashMap<String, Command> lookup = new HashMap<String, Command>();
        for (Command cmd : Command.values()) {
            for (String name : cmd.names) {
                lookup.put(name, cmd);
            }
        }
        LOOKUP = lookup;
    }
}

