/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ClusterNameMismatchException;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.UnsupportedProtocolVersionException;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.utils.MoreFutures;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SingleConnectionPool
extends HostConnectionPool {
    private static final Logger logger = LoggerFactory.getLogger(SingleConnectionPool.class);
    private static final int MIN_AVAILABLE_STREAMS = 24576;
    volatile AtomicReference<Connection> connectionRef = new AtomicReference();
    private final AtomicBoolean open = new AtomicBoolean();
    private final Set<Connection> trash = new CopyOnWriteArraySet<Connection>();
    private volatile int waiter = 0;
    private final Lock waitLock = new ReentrantLock(true);
    private final Condition hasAvailableConnection = this.waitLock.newCondition();
    private final Runnable newConnectionTask;
    private final AtomicBoolean scheduledForCreation = new AtomicBoolean();

    public SingleConnectionPool(Host host, HostDistance hostDistance, SessionManager manager) {
        super(host, hostDistance, manager);
        this.newConnectionTask = new Runnable(){

            @Override
            public void run() {
                SingleConnectionPool.this.addConnectionIfNeeded();
                SingleConnectionPool.this.scheduledForCreation.set(false);
            }
        };
    }

    @Override
    ListenableFuture<Void> initAsync(Connection reusedConnection) {
        ListenableFuture<Void> connectionFuture;
        Connection connection;
        if (reusedConnection != null && reusedConnection.setPool(this)) {
            connection = reusedConnection;
            connectionFuture = MoreFutures.VOID_SUCCESS;
        } else {
            connection = this.manager.connectionFactory().newConnection(this);
            connectionFuture = connection.initAsync();
        }
        Executor initExecutor = this.manager.cluster.manager.configuration.getPoolingOptions().getInitializationExecutor();
        final SettableFuture initFuture = SettableFuture.create();
        Futures.addCallback(connectionFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                SingleConnectionPool.this.connectionRef.set(connection);
                SingleConnectionPool.this.open.set(true);
                if (SingleConnectionPool.this.isClosed()) {
                    initFuture.setException((Throwable)new ConnectionException(SingleConnectionPool.this.host.getSocketAddress(), "Pool was closed during initialization"));
                    connection.closeAsync().force();
                } else {
                    logger.trace("Created connection pool to host {}", (Object)SingleConnectionPool.this.host);
                    SingleConnectionPool.this.phase.compareAndSet(HostConnectionPool.Phase.INITIALIZING, HostConnectionPool.Phase.READY);
                    initFuture.set(null);
                }
            }

            public void onFailure(Throwable t) {
                SingleConnectionPool.this.phase.compareAndSet(HostConnectionPool.Phase.INITIALIZING, HostConnectionPool.Phase.INIT_FAILED);
                initFuture.setException(t);
            }
        }, (Executor)initExecutor);
        return initFuture;
    }

    private PoolingOptions options() {
        return this.manager.configuration().getPoolingOptions();
    }

    @Override
    public Connection borrowConnection(long timeout, TimeUnit unit) throws ConnectionException, TimeoutException {
        HostConnectionPool.Phase phase = (HostConnectionPool.Phase)((Object)this.phase.get());
        if (phase != HostConnectionPool.Phase.READY) {
            throw new ConnectionException(this.host.getSocketAddress(), "Pool is " + (Object)((Object)phase));
        }
        Connection connection = this.connectionRef.get();
        if (connection == null) {
            if (this.scheduledForCreation.compareAndSet(false, true)) {
                this.manager.blockingExecutor().submit(this.newConnectionTask);
            }
            connection = this.waitForConnection(timeout, unit);
        } else {
            int inFlight;
            do {
                if ((inFlight = connection.inFlight.get()) < Math.min(connection.maxAvailableStreams(), this.options().getMaxSimultaneousRequestsPerHostThreshold(this.hostDistance))) continue;
                connection = this.waitForConnection(timeout, unit);
                break;
            } while (!connection.inFlight.compareAndSet(inFlight, inFlight + 1));
        }
        connection.setKeyspace(this.manager.poolsState.keyspace);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitAvailableConnection(long timeout, TimeUnit unit) throws InterruptedException {
        this.waitLock.lock();
        ++this.waiter;
        try {
            this.hasAvailableConnection.await(timeout, unit);
        }
        finally {
            --this.waiter;
            this.waitLock.unlock();
        }
    }

    private void signalAvailableConnection() {
        if (this.waiter == 0) {
            return;
        }
        this.waitLock.lock();
        try {
            this.hasAvailableConnection.signal();
        }
        finally {
            this.waitLock.unlock();
        }
    }

    private void signalAllAvailableConnection() {
        if (this.waiter == 0) {
            return;
        }
        this.waitLock.lock();
        try {
            this.hasAvailableConnection.signalAll();
        }
        finally {
            this.waitLock.unlock();
        }
    }

    private Connection waitForConnection(long timeout, TimeUnit unit) throws ConnectionException, TimeoutException {
        if (timeout == 0L) {
            throw new TimeoutException();
        }
        long start = System.nanoTime();
        long remaining = timeout;
        do {
            int inFlight;
            try {
                this.awaitAvailableConnection(remaining, unit);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                timeout = 0L;
            }
            if (this.isClosed()) {
                throw new ConnectionException(this.host.getSocketAddress(), "Pool is shutdown");
            }
            Connection connection = this.connectionRef.get();
            if (connection == null) continue;
            while ((inFlight = connection.inFlight.get()) < Math.min(connection.maxAvailableStreams(), this.options().getMaxSimultaneousRequestsPerHostThreshold(this.hostDistance))) {
                if (!connection.inFlight.compareAndSet(inFlight, inFlight + 1)) continue;
                return connection;
            }
        } while ((remaining = timeout - Cluster.timeSince(start, unit)) > 0L);
        throw new TimeoutException();
    }

    @Override
    public void returnConnection(Connection connection) {
        int inFlight = connection.inFlight.decrementAndGet();
        if (this.isClosed()) {
            this.close(connection);
            return;
        }
        if (connection.isDefunct()) {
            return;
        }
        if (this.trash.contains(connection)) {
            if (inFlight == 0 && this.trash.remove(connection)) {
                this.close(connection);
            }
        } else if (connection.maxAvailableStreams() < 24576) {
            this.replaceConnection(connection);
        } else {
            this.signalAvailableConnection();
        }
    }

    private void replaceConnection(Connection connection) {
        if (!connection.state.compareAndSet(Connection.State.OPEN, Connection.State.TRASHED)) {
            return;
        }
        this.open.set(false);
        this.maybeSpawnNewConnection();
        this.doTrashConnection(connection);
    }

    private void doTrashConnection(Connection connection) {
        this.connectionRef.compareAndSet(connection, null);
        this.trash.add(connection);
        if (connection.inFlight.get() == 0 && this.trash.remove(connection)) {
            this.close(connection);
        }
    }

    private boolean addConnectionIfNeeded() {
        if (!this.open.compareAndSet(false, true)) {
            return false;
        }
        if (this.phase.get() != HostConnectionPool.Phase.READY) {
            this.open.set(false);
            return false;
        }
        try {
            logger.debug("Creating new connection on busy pool to {}", (Object)this.host);
            Connection newConnection = this.manager.connectionFactory().open(this);
            this.connectionRef.set(newConnection);
            if (this.isClosed() && !newConnection.isClosed()) {
                this.close(newConnection);
                this.open.set(false);
                return false;
            }
            this.signalAvailableConnection();
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.open.set(false);
            return false;
        }
        catch (ConnectionException e) {
            this.open.set(false);
            logger.debug("Connection error to {} while creating additional connection", (Object)this.host);
            return false;
        }
        catch (AuthenticationException e) {
            this.open.set(false);
            logger.error("Authentication error while creating additional connection (error is: {})", (Object)e.getMessage());
            return false;
        }
        catch (UnsupportedProtocolVersionException e) {
            this.open.set(false);
            logger.error("UnsupportedProtocolVersionException error while creating additional connection (error is: {})", (Object)e.getMessage());
            return false;
        }
        catch (ClusterNameMismatchException e) {
            this.open.set(false);
            logger.error("ClusterNameMismatchException error while creating additional connection (error is: {})", (Object)e.getMessage());
            return false;
        }
    }

    private void maybeSpawnNewConnection() {
        if (!this.scheduledForCreation.compareAndSet(false, true)) {
            return;
        }
        this.manager.blockingExecutor().submit(this.newConnectionTask);
    }

    @Override
    public void replaceDefunctConnection(Connection connection) {
        if (connection.state.compareAndSet(Connection.State.OPEN, Connection.State.GONE)) {
            this.open.set(false);
        }
        if (this.connectionRef.compareAndSet(connection, null)) {
            this.manager.blockingExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    SingleConnectionPool.this.addConnectionIfNeeded();
                }
            });
        }
    }

    @Override
    void cleanupIdleConnections(long now) {
    }

    private void close(Connection connection) {
        connection.closeAsync();
    }

    @Override
    protected CloseFuture makeCloseFuture() {
        this.signalAllAvailableConnection();
        return new CloseFuture.Forwarding(this.discardConnection());
    }

    private List<CloseFuture> discardConnection() {
        ArrayList<CloseFuture> futures = new ArrayList<CloseFuture>();
        final Connection connection = this.connectionRef.get();
        if (connection != null) {
            CloseFuture future = connection.closeAsync();
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    if (connection.state.compareAndSet(Connection.State.OPEN, Connection.State.GONE)) {
                        SingleConnectionPool.this.open.set(false);
                    }
                }
            }, (Executor)MoreExecutors.sameThreadExecutor());
            futures.add(future);
        }
        return futures;
    }

    @Override
    public void ensureCoreConnections() {
        if (this.isClosed()) {
            return;
        }
        if (!this.open.get() && this.scheduledForCreation.compareAndSet(false, true)) {
            this.manager.blockingExecutor().submit(this.newConnectionTask);
        }
    }

    @Override
    public int opened() {
        return this.open.get() ? 1 : 0;
    }

    @Override
    int trashed() {
        return this.trash.size();
    }

    @Override
    public int inFlightQueriesCount() {
        Connection connection = this.connectionRef.get();
        return connection == null ? 0 : connection.inFlight.get();
    }
}

