/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.CompoundDenseCellNameType;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.composites.CompositesIndex;
import org.apache.cassandra.db.marshal.AbstractType;

public abstract class CompositesIndexIncludingCollectionKey
extends CompositesIndex {
    public static CellNameType buildIndexComparator(CFMetaData baseMetadata, ColumnDefinition columnDef) {
        int count = 1 + baseMetadata.clusteringColumns().size();
        ArrayList types = new ArrayList(count);
        types.add(SecondaryIndex.keyComparator);
        for (int i = 0; i < count - 1; ++i) {
            types.add(baseMetadata.comparator.subtype(i));
        }
        return new CompoundDenseCellNameType(types);
    }

    @Override
    protected Composite makeIndexColumnPrefix(ByteBuffer rowKey, Composite cellName) {
        int count = 1 + this.baseCfs.metadata.clusteringColumns().size();
        CBuilder builder = this.getIndexComparator().builder();
        builder.add(rowKey);
        for (int i = 0; i < Math.min(cellName.size(), count - 1); ++i) {
            builder.add(cellName.get(i));
        }
        return builder.build();
    }

    @Override
    public CompositesIndex.IndexedEntry decodeEntry(DecoratedKey indexedValue, Cell indexEntry) {
        int count = 1 + this.baseCfs.metadata.clusteringColumns().size();
        CBuilder builder = this.baseCfs.getComparator().builder();
        for (int i = 0; i < count - 1; ++i) {
            builder.add(indexEntry.name().get(i + 1));
        }
        return new CompositesIndex.IndexedEntry(indexedValue, indexEntry.name(), indexEntry.timestamp(), indexEntry.name().get(0), builder.build());
    }

    @Override
    public boolean indexes(CellName name) {
        AbstractType<?> comp = this.baseCfs.metadata.getColumnDefinitionComparator(this.columnDef);
        return name.size() > this.columnDef.position() && comp.compare(name.get(this.columnDef.position()), this.columnDef.name.bytes) == 0;
    }
}

