/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.cassandra.db.ReadResponseSerializer;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.io.IVersionedSerializer;

public class ReadResponse {
    public static final IVersionedSerializer<ReadResponse> serializer = new ReadResponseSerializer();
    private static final AtomicReferenceFieldUpdater<ReadResponse, ByteBuffer> digestUpdater = AtomicReferenceFieldUpdater.newUpdater(ReadResponse.class, ByteBuffer.class, "digest");
    private final Row row;
    private volatile ByteBuffer digest;

    public ReadResponse(ByteBuffer digest) {
        this(null, digest);
        assert (digest != null);
    }

    public ReadResponse(Row row) {
        this(row, null);
        assert (row != null);
    }

    public ReadResponse(Row row, ByteBuffer digest) {
        this.row = row;
        this.digest = digest;
    }

    public Row row() {
        return this.row;
    }

    public ByteBuffer digest() {
        return this.digest;
    }

    public void setDigest(ByteBuffer digest) {
        ByteBuffer curr = this.digest;
        if (!digestUpdater.compareAndSet(this, curr, digest)) assert (digest.equals(this.digest)) : String.format("Digest mismatch : %s vs %s", Arrays.toString(digest.array()), Arrays.toString(this.digest.array()));
    }

    public boolean isDigestQuery() {
        return this.digest != null && this.row == null;
    }
}

