/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import java.awt.Dimension;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import org.omegat.gui.editor.autotext.Autotext;
import org.omegat.gui.editor.autotext.AutotextTableModel;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.AutotextAutoCompleterOptionsPanel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.StaticUIUtils;

public class AutotextAutoCompleterOptionsController
extends BasePreferencesController {
    private static final int MAX_ROW_COUNT = 10;
    private final JFileChooser fc = new JFileChooser();
    private AutotextAutoCompleterOptionsPanel panel;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_AUTOCOMPLETER_AUTOTEXT");
    }

    private void initGui() {
        this.panel = new AutotextAutoCompleterOptionsPanel();
        this.fc.setDialogType(0);
        this.fc.addChoosableFileFilter(new FileNameExtensionFilter(OStrings.getString("AC_AUTOTEXT_FILE"), "autotext"));
        this.panel.entryTable.setModel(new AutotextTableModel(Autotext.getItems()));
        this.panel.saveButton.addActionListener(e -> this.saveFile());
        this.panel.loadButton.addActionListener(e -> this.loadFile());
        TableColumnModel cModel = this.panel.entryTable.getColumnModel();
        cModel.getColumn(0).setHeaderValue(OStrings.getString("AC_AUTOTEXT_ABBREVIATION"));
        cModel.getColumn(1).setHeaderValue(OStrings.getString("AC_AUTOTEXT_TEXT"));
        cModel.getColumn(2).setHeaderValue(OStrings.getString("AC_AUTOTEXT_COMMENT"));
        this.panel.sortAlphabeticallyCheckBox.addActionListener(e -> this.panel.sortFullTextCheckBox.setEnabled(this.panel.sortAlphabeticallyCheckBox.isSelected()));
        this.panel.addNewRowButton.addActionListener(e -> {
            int newRow = ((AutotextTableModel)this.panel.entryTable.getModel()).addRow(new Autotext.AutotextItem(), this.panel.entryTable.getSelectedRow());
            this.panel.entryTable.changeSelection(newRow, 0, false, false);
            this.panel.entryTable.changeSelection(newRow, this.panel.entryTable.getColumnCount() - 1, false, true);
            this.panel.entryTable.editCellAt(newRow, 0);
            this.panel.entryTable.transferFocus();
        });
        this.panel.removeEntryButton.addActionListener(e -> {
            if (this.panel.entryTable.getSelectedRow() != -1) {
                ((AutotextTableModel)this.panel.entryTable.getModel()).removeRow(this.panel.entryTable.getSelectedRow());
            }
        });
        this.panel.enabledCheckBox.addActionListener(e -> this.updateEnabledness());
        Dimension tableSize = this.panel.entryTable.getPreferredSize();
        this.panel.entryTable.setPreferredScrollableViewportSize(new Dimension(tableSize.width, this.panel.entryTable.getRowHeight() * 10));
    }

    private void updateEnabledness() {
        this.panel.sortFullTextCheckBox.setEnabled(this.panel.sortAlphabeticallyCheckBox.isSelected());
        StaticUIUtils.setHierarchyEnabled(this.panel.displayPanel, this.panel.enabledCheckBox.isSelected());
        StaticUIUtils.setHierarchyEnabled(this.panel.entriesPanel, this.panel.enabledCheckBox.isSelected());
    }

    private void loadFile() {
        if (0 == this.fc.showOpenDialog(this.panel)) {
            try {
                List<Autotext.AutotextItem> data = Autotext.load(this.fc.getSelectedFile());
                this.panel.entryTable.setModel(new AutotextTableModel(data));
            }
            catch (IOException ex) {
                Logger.getLogger(AutotextAutoCompleterOptionsPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void saveFile() {
        if (0 == this.fc.showSaveDialog(this.panel)) {
            try {
                List<Autotext.AutotextItem> data = ((AutotextTableModel)this.panel.entryTable.getModel()).getData();
                Autotext.save(data, this.fc.getSelectedFile());
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.panel, OStrings.getString("AC_AUTOTEXT_UNABLE_TO_SAVE"));
            }
        }
    }

    @Override
    protected void initFromPrefs() {
        this.panel.sortByLengthCheckBox.setSelected(Preferences.isPreference("ac_autotext_sort_by_length"));
        this.panel.sortAlphabeticallyCheckBox.setSelected(Preferences.isPreference("ac_autotext_sort_alphabetically"));
        this.panel.sortFullTextCheckBox.setSelected(Preferences.isPreference("ac_autotext_sort_full_text"));
        this.panel.enabledCheckBox.setSelected(Preferences.isPreferenceDefault("ac_autotext_enabled", true));
        this.updateEnabledness();
    }

    @Override
    public void restoreDefaults() {
        this.panel.sortByLengthCheckBox.setSelected(false);
        this.panel.sortAlphabeticallyCheckBox.setSelected(false);
        this.panel.sortFullTextCheckBox.setSelected(false);
        this.panel.enabledCheckBox.setSelected(true);
        this.updateEnabledness();
    }

    @Override
    public void persist() {
        TableCellEditor editor = this.panel.entryTable.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        Autotext.setList(((AutotextTableModel)this.panel.entryTable.getModel()).getData());
        try {
            Autotext.save();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.panel, OStrings.getString("AC_AUTOTEXT_UNABLE_TO_SAVE"));
        }
        Preferences.setPreference("ac_autotext_sort_by_length", this.panel.sortByLengthCheckBox.isSelected());
        Preferences.setPreference("ac_autotext_sort_alphabetically", this.panel.sortAlphabeticallyCheckBox.isSelected());
        Preferences.setPreference("ac_autotext_sort_full_text", this.panel.sortFullTextCheckBox.isSelected());
        Preferences.setPreference("ac_autotext_enabled", this.panel.enabledCheckBox.isSelected());
    }
}

