/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class SegmentProperties {
    public static final String[] EMPTY_PROPS = new String[0];
    public static final String COMMENT = "comment";
    public static final String REFERENCE = "reference";

    private SegmentProperties() {
    }

    public static boolean isEmpty(String[] props) {
        return props == null || props.length == 0;
    }

    public static String[] copy(String[] props) {
        return SegmentProperties.isEmpty(props) ? EMPTY_PROPS : Arrays.copyOf(props, props.length);
    }

    public static String joinValues(String[] props) {
        if (props.length == 0) {
            return "";
        }
        if (props.length == 2) {
            return props[1];
        }
        return IntStream.range(0, props.length).filter(i -> i % 2 != 0).mapToObj(i -> props[i]).collect(Collectors.joining("\n"));
    }

    public static boolean isReferenceEntry(String[] props) {
        if (SegmentProperties.isEmpty(props)) {
            return false;
        }
        String value = SegmentProperties.getProperty(props, REFERENCE);
        return Boolean.parseBoolean(value);
    }

    public static String getProperty(String[] props, String key) {
        for (int i = 0; i < props.length; i += 2) {
            if (!key.equals(props[i])) continue;
            return props[i + 1];
        }
        return null;
    }
}

